/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { BindingTypeEnum } from './BindingTypeEnum';
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import type { NameIdPolicyEnum } from './NameIdPolicyEnum';
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * SAMLSource Serializer
 * @export
 * @interface SAMLSource
 */
export interface SAMLSource {
    /**
     *
     * @type {string}
     * @memberof SAMLSource
     */
    readonly pk: string;
    /**
     * Source's display Name.
     * @type {string}
     * @memberof SAMLSource
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof SAMLSource
     */
    slug: string;
    /**
     *
     * @type {boolean}
     * @memberof SAMLSource
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof SAMLSource
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof SAMLSource
     */
    enrollmentFlow?: string | null;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof SAMLSource
     */
    readonly component: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof SAMLSource
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof SAMLSource
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof SAMLSource
     */
    readonly metaModelName: string;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof SAMLSource
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof SAMLSource
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     * Objects that are managed by authentik. These objects are created and updated automatically. This flag only indicates that an object can be overwritten by migrations. You can still modify the objects via the API, but expect changes to be overwritten in a later update.
     * @type {string}
     * @memberof SAMLSource
     */
    readonly managed: string | null;
    /**
     *
     * @type {string}
     * @memberof SAMLSource
     */
    userPathTemplate?: string;
    /**
     *
     * @type {string}
     * @memberof SAMLSource
     */
    readonly icon: string;
    /**
     * Flow used before authentication.
     * @type {string}
     * @memberof SAMLSource
     */
    preAuthenticationFlow: string;
    /**
     * Also known as Entity ID. Defaults the Metadata URL.
     * @type {string}
     * @memberof SAMLSource
     */
    issuer?: string;
    /**
     * URL that the initial Login request is sent to.
     * @type {string}
     * @memberof SAMLSource
     */
    ssoUrl: string;
    /**
     * Optional URL if your IDP supports Single-Logout.
     * @type {string}
     * @memberof SAMLSource
     */
    sloUrl?: string | null;
    /**
     * Allows authentication flows initiated by the IdP. This can be a security risk, as no validation of the request ID is done.
     * @type {boolean}
     * @memberof SAMLSource
     */
    allowIdpInitiated?: boolean;
    /**
     *
     * @type {NameIdPolicyEnum}
     * @memberof SAMLSource
     */
    nameIdPolicy?: NameIdPolicyEnum;
    /**
     *
     * @type {BindingTypeEnum}
     * @memberof SAMLSource
     */
    bindingType?: BindingTypeEnum;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLSource
     */
    verificationKp?: string | null;
    /**
     * Keypair used to sign outgoing Responses going to the Identity Provider.
     * @type {string}
     * @memberof SAMLSource
     */
    signingKp?: string | null;
    /**
     *
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLSource
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     *
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLSource
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Time offset when temporary users should be deleted. This only applies if your IDP uses the NameID Format 'transient', and the user doesn't log out manually. (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLSource
     */
    temporaryUserDeleteAfter?: string;
}
/**
 * Check if a given object implements the SAMLSource interface.
 */
export declare function instanceOfSAMLSource(value: object): boolean;
export declare function SAMLSourceFromJSON(json: any): SAMLSource;
export declare function SAMLSourceFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLSource;
export declare function SAMLSourceToJSON(value?: SAMLSource | null): any;
