/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { ProviderTypeEnum } from './ProviderTypeEnum';
import type { SourceType } from './SourceType';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * OAuth Source Serializer
 * @export
 * @interface OAuthSource
 */
export interface OAuthSource {
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    readonly pk: string;
    /**
     * Source's display Name.
     * @type {string}
     * @memberof OAuthSource
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof OAuthSource
     */
    slug: string;
    /**
     *
     * @type {boolean}
     * @memberof OAuthSource
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof OAuthSource
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof OAuthSource
     */
    enrollmentFlow?: string | null;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof OAuthSource
     */
    readonly component: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof OAuthSource
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof OAuthSource
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof OAuthSource
     */
    readonly metaModelName: string;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof OAuthSource
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof OAuthSource
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     * Objects that are managed by authentik. These objects are created and updated automatically. This flag only indicates that an object can be overwritten by migrations. You can still modify the objects via the API, but expect changes to be overwritten in a later update.
     * @type {string}
     * @memberof OAuthSource
     */
    readonly managed: string | null;
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    userPathTemplate?: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    readonly icon: string | null;
    /**
     *
     * @type {ProviderTypeEnum}
     * @memberof OAuthSource
     */
    providerType: ProviderTypeEnum;
    /**
     * URL used to request the initial token. This URL is only required for OAuth 1.
     * @type {string}
     * @memberof OAuthSource
     */
    requestTokenUrl?: string | null;
    /**
     * URL the user is redirect to to conest the flow.
     * @type {string}
     * @memberof OAuthSource
     */
    authorizationUrl?: string | null;
    /**
     * URL used by authentik to retrieve tokens.
     * @type {string}
     * @memberof OAuthSource
     */
    accessTokenUrl?: string | null;
    /**
     * URL used by authentik to get user information.
     * @type {string}
     * @memberof OAuthSource
     */
    profileUrl?: string | null;
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    consumerKey: string;
    /**
     * Get OAuth Callback URL
     * @type {string}
     * @memberof OAuthSource
     */
    readonly callbackUrl: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    additionalScopes?: string;
    /**
     *
     * @type {SourceType}
     * @memberof OAuthSource
     */
    readonly type: SourceType;
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    oidcWellKnownUrl?: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSource
     */
    oidcJwksUrl?: string;
    /**
     *
     * @type {any}
     * @memberof OAuthSource
     */
    oidcJwks?: any | null;
}
/**
 * Check if a given object implements the OAuthSource interface.
 */
export declare function instanceOfOAuthSource(value: object): boolean;
export declare function OAuthSourceFromJSON(json: any): OAuthSource;
export declare function OAuthSourceFromJSONTyped(json: any, ignoreDiscriminator: boolean): OAuthSource;
export declare function OAuthSourceToJSON(value?: OAuthSource | null): any;
