/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime';
import type { FilePathRequest, LDAPDebug, LDAPSource, LDAPSourceRequest, OAuthSource, OAuthSourceRequest, PaginatedLDAPSourceList, PaginatedOAuthSourceList, PaginatedPlexSourceConnectionList, PaginatedPlexSourceList, PaginatedSAMLSourceList, PaginatedSCIMSourceGroupList, PaginatedSCIMSourceList, PaginatedSCIMSourceUserList, PaginatedSourceList, PaginatedUserOAuthSourceConnectionList, PaginatedUserSAMLSourceConnectionList, PaginatedUserSourceConnectionList, PatchedLDAPSourceRequest, PatchedOAuthSourceRequest, PatchedPlexSourceConnectionRequest, PatchedPlexSourceRequest, PatchedSAMLSourceRequest, PatchedSCIMSourceGroupRequest, PatchedSCIMSourceRequest, PatchedSCIMSourceUserRequest, PatchedUserOAuthSourceConnectionRequest, PatchedUserSAMLSourceConnectionRequest, PlexSource, PlexSourceConnection, PlexSourceConnectionRequest, PlexSourceRequest, PlexTokenRedeemRequest, RedirectChallenge, SAMLMetadata, SAMLSource, SAMLSourceRequest, SCIMSource, SCIMSourceGroup, SCIMSourceGroupRequest, SCIMSourceRequest, SCIMSourceUser, SCIMSourceUserRequest, Source, SourceType, SyncStatus, TypeCreate, UsedBy, UserOAuthSourceConnection, UserOAuthSourceConnectionRequest, UserSAMLSourceConnection, UserSAMLSourceConnectionRequest, UserSetting, UserSourceConnection } from '../models';
export interface SourcesAllDestroyRequest {
    slug: string;
}
export interface SourcesAllListRequest {
    managed?: string;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    slug?: string;
}
export interface SourcesAllRetrieveRequest {
    slug: string;
}
export interface SourcesAllSetIconCreateRequest {
    slug: string;
    file?: Blob;
    clear?: boolean;
}
export interface SourcesAllSetIconUrlCreateRequest {
    slug: string;
    filePathRequest: FilePathRequest;
}
export interface SourcesAllUsedByListRequest {
    slug: string;
}
export interface SourcesLdapCreateRequest {
    lDAPSourceRequest: LDAPSourceRequest;
}
export interface SourcesLdapDebugRetrieveRequest {
    slug: string;
}
export interface SourcesLdapDestroyRequest {
    slug: string;
}
export interface SourcesLdapListRequest {
    additionalGroupDn?: string;
    additionalUserDn?: string;
    baseDn?: string;
    bindCn?: string;
    clientCertificate?: string;
    enabled?: boolean;
    groupMembershipField?: string;
    groupObjectFilter?: string;
    name?: string;
    objectUniquenessField?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    passwordLoginUpdateInternalPassword?: boolean;
    peerCertificate?: string;
    propertyMappings?: Array<string>;
    propertyMappingsGroup?: Array<string>;
    search?: string;
    serverUri?: string;
    slug?: string;
    sni?: boolean;
    startTls?: boolean;
    syncGroups?: boolean;
    syncParentGroup?: string;
    syncUsers?: boolean;
    syncUsersPassword?: boolean;
    userObjectFilter?: string;
}
export interface SourcesLdapPartialUpdateRequest {
    slug: string;
    patchedLDAPSourceRequest?: PatchedLDAPSourceRequest;
}
export interface SourcesLdapRetrieveRequest {
    slug: string;
}
export interface SourcesLdapSyncStatusRetrieveRequest {
    slug: string;
}
export interface SourcesLdapUpdateRequest {
    slug: string;
    lDAPSourceRequest: LDAPSourceRequest;
}
export interface SourcesLdapUsedByListRequest {
    slug: string;
}
export interface SourcesOauthCreateRequest {
    oAuthSourceRequest: OAuthSourceRequest;
}
export interface SourcesOauthDestroyRequest {
    slug: string;
}
export interface SourcesOauthListRequest {
    accessTokenUrl?: string;
    additionalScopes?: string;
    authenticationFlow?: string;
    authorizationUrl?: string;
    consumerKey?: string;
    enabled?: boolean;
    enrollmentFlow?: string;
    hasJwks?: boolean;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    policyEngineMode?: SourcesOauthListPolicyEngineModeEnum;
    profileUrl?: string;
    providerType?: string;
    requestTokenUrl?: string;
    search?: string;
    slug?: string;
    userMatchingMode?: SourcesOauthListUserMatchingModeEnum;
}
export interface SourcesOauthPartialUpdateRequest {
    slug: string;
    patchedOAuthSourceRequest?: PatchedOAuthSourceRequest;
}
export interface SourcesOauthRetrieveRequest {
    slug: string;
}
export interface SourcesOauthSourceTypesListRequest {
    name?: string;
}
export interface SourcesOauthUpdateRequest {
    slug: string;
    oAuthSourceRequest: OAuthSourceRequest;
}
export interface SourcesOauthUsedByListRequest {
    slug: string;
}
export interface SourcesPlexCreateRequest {
    plexSourceRequest: PlexSourceRequest;
}
export interface SourcesPlexDestroyRequest {
    slug: string;
}
export interface SourcesPlexListRequest {
    allowFriends?: boolean;
    authenticationFlow?: string;
    clientId?: string;
    enabled?: boolean;
    enrollmentFlow?: string;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    policyEngineMode?: SourcesPlexListPolicyEngineModeEnum;
    search?: string;
    slug?: string;
    userMatchingMode?: SourcesPlexListUserMatchingModeEnum;
}
export interface SourcesPlexPartialUpdateRequest {
    slug: string;
    patchedPlexSourceRequest?: PatchedPlexSourceRequest;
}
export interface SourcesPlexRedeemTokenAuthenticatedCreateRequest {
    plexTokenRedeemRequest: PlexTokenRedeemRequest;
    slug?: string;
}
export interface SourcesPlexRedeemTokenCreateRequest {
    plexTokenRedeemRequest: PlexTokenRedeemRequest;
    slug?: string;
}
export interface SourcesPlexRetrieveRequest {
    slug: string;
}
export interface SourcesPlexUpdateRequest {
    slug: string;
    plexSourceRequest: PlexSourceRequest;
}
export interface SourcesPlexUsedByListRequest {
    slug: string;
}
export interface SourcesSamlCreateRequest {
    sAMLSourceRequest: SAMLSourceRequest;
}
export interface SourcesSamlDestroyRequest {
    slug: string;
}
export interface SourcesSamlListRequest {
    allowIdpInitiated?: boolean;
    authenticationFlow?: string;
    bindingType?: SourcesSamlListBindingTypeEnum;
    digestAlgorithm?: SourcesSamlListDigestAlgorithmEnum;
    enabled?: boolean;
    enrollmentFlow?: string;
    issuer?: string;
    managed?: string;
    name?: string;
    nameIdPolicy?: SourcesSamlListNameIdPolicyEnum;
    ordering?: string;
    page?: number;
    pageSize?: number;
    policyEngineMode?: SourcesSamlListPolicyEngineModeEnum;
    preAuthenticationFlow?: string;
    search?: string;
    signatureAlgorithm?: SourcesSamlListSignatureAlgorithmEnum;
    signingKp?: string;
    sloUrl?: string;
    slug?: string;
    ssoUrl?: string;
    temporaryUserDeleteAfter?: string;
    userMatchingMode?: SourcesSamlListUserMatchingModeEnum;
    verificationKp?: string;
}
export interface SourcesSamlMetadataRetrieveRequest {
    slug: string;
}
export interface SourcesSamlPartialUpdateRequest {
    slug: string;
    patchedSAMLSourceRequest?: PatchedSAMLSourceRequest;
}
export interface SourcesSamlRetrieveRequest {
    slug: string;
}
export interface SourcesSamlUpdateRequest {
    slug: string;
    sAMLSourceRequest: SAMLSourceRequest;
}
export interface SourcesSamlUsedByListRequest {
    slug: string;
}
export interface SourcesScimCreateRequest {
    sCIMSourceRequest: SCIMSourceRequest;
}
export interface SourcesScimDestroyRequest {
    slug: string;
}
export interface SourcesScimGroupsCreateRequest {
    sCIMSourceGroupRequest: SCIMSourceGroupRequest;
}
export interface SourcesScimGroupsDestroyRequest {
    id: string;
}
export interface SourcesScimGroupsListRequest {
    groupGroupUuid?: string;
    groupName?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    sourceSlug?: string;
}
export interface SourcesScimGroupsPartialUpdateRequest {
    id: string;
    patchedSCIMSourceGroupRequest?: PatchedSCIMSourceGroupRequest;
}
export interface SourcesScimGroupsRetrieveRequest {
    id: string;
}
export interface SourcesScimGroupsUpdateRequest {
    id: string;
    sCIMSourceGroupRequest: SCIMSourceGroupRequest;
}
export interface SourcesScimGroupsUsedByListRequest {
    id: string;
}
export interface SourcesScimListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    slug?: string;
}
export interface SourcesScimPartialUpdateRequest {
    slug: string;
    patchedSCIMSourceRequest?: PatchedSCIMSourceRequest;
}
export interface SourcesScimRetrieveRequest {
    slug: string;
}
export interface SourcesScimUpdateRequest {
    slug: string;
    sCIMSourceRequest: SCIMSourceRequest;
}
export interface SourcesScimUsedByListRequest {
    slug: string;
}
export interface SourcesScimUsersCreateRequest {
    sCIMSourceUserRequest: SCIMSourceUserRequest;
}
export interface SourcesScimUsersDestroyRequest {
    id: string;
}
export interface SourcesScimUsersListRequest {
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    sourceSlug?: string;
    userId?: number;
    userUsername?: string;
}
export interface SourcesScimUsersPartialUpdateRequest {
    id: string;
    patchedSCIMSourceUserRequest?: PatchedSCIMSourceUserRequest;
}
export interface SourcesScimUsersRetrieveRequest {
    id: string;
}
export interface SourcesScimUsersUpdateRequest {
    id: string;
    sCIMSourceUserRequest: SCIMSourceUserRequest;
}
export interface SourcesScimUsersUsedByListRequest {
    id: string;
}
export interface SourcesUserConnectionsAllDestroyRequest {
    id: number;
}
export interface SourcesUserConnectionsAllListRequest {
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    user?: number;
}
export interface SourcesUserConnectionsAllPartialUpdateRequest {
    id: number;
}
export interface SourcesUserConnectionsAllRetrieveRequest {
    id: number;
}
export interface SourcesUserConnectionsAllUpdateRequest {
    id: number;
}
export interface SourcesUserConnectionsAllUsedByListRequest {
    id: number;
}
export interface SourcesUserConnectionsOauthCreateRequest {
    userOAuthSourceConnectionRequest: UserOAuthSourceConnectionRequest;
}
export interface SourcesUserConnectionsOauthDestroyRequest {
    id: number;
}
export interface SourcesUserConnectionsOauthListRequest {
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    sourceSlug?: string;
}
export interface SourcesUserConnectionsOauthPartialUpdateRequest {
    id: number;
    patchedUserOAuthSourceConnectionRequest?: PatchedUserOAuthSourceConnectionRequest;
}
export interface SourcesUserConnectionsOauthRetrieveRequest {
    id: number;
}
export interface SourcesUserConnectionsOauthUpdateRequest {
    id: number;
    userOAuthSourceConnectionRequest: UserOAuthSourceConnectionRequest;
}
export interface SourcesUserConnectionsOauthUsedByListRequest {
    id: number;
}
export interface SourcesUserConnectionsPlexCreateRequest {
    plexSourceConnectionRequest: PlexSourceConnectionRequest;
}
export interface SourcesUserConnectionsPlexDestroyRequest {
    id: number;
}
export interface SourcesUserConnectionsPlexListRequest {
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    sourceSlug?: string;
}
export interface SourcesUserConnectionsPlexPartialUpdateRequest {
    id: number;
    patchedPlexSourceConnectionRequest?: PatchedPlexSourceConnectionRequest;
}
export interface SourcesUserConnectionsPlexRetrieveRequest {
    id: number;
}
export interface SourcesUserConnectionsPlexUpdateRequest {
    id: number;
    plexSourceConnectionRequest: PlexSourceConnectionRequest;
}
export interface SourcesUserConnectionsPlexUsedByListRequest {
    id: number;
}
export interface SourcesUserConnectionsSamlCreateRequest {
    userSAMLSourceConnectionRequest: UserSAMLSourceConnectionRequest;
}
export interface SourcesUserConnectionsSamlDestroyRequest {
    id: number;
}
export interface SourcesUserConnectionsSamlListRequest {
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    sourceSlug?: string;
}
export interface SourcesUserConnectionsSamlPartialUpdateRequest {
    id: number;
    patchedUserSAMLSourceConnectionRequest?: PatchedUserSAMLSourceConnectionRequest;
}
export interface SourcesUserConnectionsSamlRetrieveRequest {
    id: number;
}
export interface SourcesUserConnectionsSamlUpdateRequest {
    id: number;
    userSAMLSourceConnectionRequest: UserSAMLSourceConnectionRequest;
}
export interface SourcesUserConnectionsSamlUsedByListRequest {
    id: number;
}
/**
 *
 */
export declare class SourcesApi extends runtime.BaseAPI {
    /**
     * Source Viewset
     */
    sourcesAllDestroyRaw(requestParameters: SourcesAllDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Source Viewset
     */
    sourcesAllDestroy(requestParameters: SourcesAllDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Source Viewset
     */
    sourcesAllListRaw(requestParameters: SourcesAllListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSourceList>>;
    /**
     * Source Viewset
     */
    sourcesAllList(requestParameters?: SourcesAllListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSourceList>;
    /**
     * Source Viewset
     */
    sourcesAllRetrieveRaw(requestParameters: SourcesAllRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Source>>;
    /**
     * Source Viewset
     */
    sourcesAllRetrieve(requestParameters: SourcesAllRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Source>;
    /**
     * Set source icon
     */
    sourcesAllSetIconCreateRaw(requestParameters: SourcesAllSetIconCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Set source icon
     */
    sourcesAllSetIconCreate(requestParameters: SourcesAllSetIconCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Set source icon (as URL)
     */
    sourcesAllSetIconUrlCreateRaw(requestParameters: SourcesAllSetIconUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Set source icon (as URL)
     */
    sourcesAllSetIconUrlCreate(requestParameters: SourcesAllSetIconUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Get all creatable types
     */
    sourcesAllTypesListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<TypeCreate>>>;
    /**
     * Get all creatable types
     */
    sourcesAllTypesList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<TypeCreate>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesAllUsedByListRaw(requestParameters: SourcesAllUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesAllUsedByList(requestParameters: SourcesAllUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Get all sources the user can configure
     */
    sourcesAllUserSettingsListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UserSetting>>>;
    /**
     * Get all sources the user can configure
     */
    sourcesAllUserSettingsList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UserSetting>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapCreateRaw(requestParameters: SourcesLdapCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LDAPSource>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapCreate(requestParameters: SourcesLdapCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LDAPSource>;
    /**
     * Get raw LDAP data to debug
     */
    sourcesLdapDebugRetrieveRaw(requestParameters: SourcesLdapDebugRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LDAPDebug>>;
    /**
     * Get raw LDAP data to debug
     */
    sourcesLdapDebugRetrieve(requestParameters: SourcesLdapDebugRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LDAPDebug>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapDestroyRaw(requestParameters: SourcesLdapDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapDestroy(requestParameters: SourcesLdapDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapListRaw(requestParameters: SourcesLdapListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedLDAPSourceList>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapList(requestParameters?: SourcesLdapListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedLDAPSourceList>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapPartialUpdateRaw(requestParameters: SourcesLdapPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LDAPSource>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapPartialUpdate(requestParameters: SourcesLdapPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LDAPSource>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapRetrieveRaw(requestParameters: SourcesLdapRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LDAPSource>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapRetrieve(requestParameters: SourcesLdapRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LDAPSource>;
    /**
     * Get source\'s sync status
     */
    sourcesLdapSyncStatusRetrieveRaw(requestParameters: SourcesLdapSyncStatusRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SyncStatus>>;
    /**
     * Get source\'s sync status
     */
    sourcesLdapSyncStatusRetrieve(requestParameters: SourcesLdapSyncStatusRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SyncStatus>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapUpdateRaw(requestParameters: SourcesLdapUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LDAPSource>>;
    /**
     * LDAP Source Viewset
     */
    sourcesLdapUpdate(requestParameters: SourcesLdapUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LDAPSource>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesLdapUsedByListRaw(requestParameters: SourcesLdapUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesLdapUsedByList(requestParameters: SourcesLdapUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Source Viewset
     */
    sourcesOauthCreateRaw(requestParameters: SourcesOauthCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<OAuthSource>>;
    /**
     * Source Viewset
     */
    sourcesOauthCreate(requestParameters: SourcesOauthCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<OAuthSource>;
    /**
     * Source Viewset
     */
    sourcesOauthDestroyRaw(requestParameters: SourcesOauthDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Source Viewset
     */
    sourcesOauthDestroy(requestParameters: SourcesOauthDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Source Viewset
     */
    sourcesOauthListRaw(requestParameters: SourcesOauthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedOAuthSourceList>>;
    /**
     * Source Viewset
     */
    sourcesOauthList(requestParameters?: SourcesOauthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedOAuthSourceList>;
    /**
     * Source Viewset
     */
    sourcesOauthPartialUpdateRaw(requestParameters: SourcesOauthPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<OAuthSource>>;
    /**
     * Source Viewset
     */
    sourcesOauthPartialUpdate(requestParameters: SourcesOauthPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<OAuthSource>;
    /**
     * Source Viewset
     */
    sourcesOauthRetrieveRaw(requestParameters: SourcesOauthRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<OAuthSource>>;
    /**
     * Source Viewset
     */
    sourcesOauthRetrieve(requestParameters: SourcesOauthRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<OAuthSource>;
    /**
     * Get all creatable source types. If ?name is set, only returns the type for <name>. If <name> isn\'t found, returns the default type.
     */
    sourcesOauthSourceTypesListRaw(requestParameters: SourcesOauthSourceTypesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<SourceType>>>;
    /**
     * Get all creatable source types. If ?name is set, only returns the type for <name>. If <name> isn\'t found, returns the default type.
     */
    sourcesOauthSourceTypesList(requestParameters?: SourcesOauthSourceTypesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<SourceType>>;
    /**
     * Source Viewset
     */
    sourcesOauthUpdateRaw(requestParameters: SourcesOauthUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<OAuthSource>>;
    /**
     * Source Viewset
     */
    sourcesOauthUpdate(requestParameters: SourcesOauthUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<OAuthSource>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesOauthUsedByListRaw(requestParameters: SourcesOauthUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesOauthUsedByList(requestParameters: SourcesOauthUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexCreateRaw(requestParameters: SourcesPlexCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSource>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexCreate(requestParameters: SourcesPlexCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSource>;
    /**
     * Plex source Viewset
     */
    sourcesPlexDestroyRaw(requestParameters: SourcesPlexDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexDestroy(requestParameters: SourcesPlexDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Plex source Viewset
     */
    sourcesPlexListRaw(requestParameters: SourcesPlexListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedPlexSourceList>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexList(requestParameters?: SourcesPlexListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedPlexSourceList>;
    /**
     * Plex source Viewset
     */
    sourcesPlexPartialUpdateRaw(requestParameters: SourcesPlexPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSource>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexPartialUpdate(requestParameters: SourcesPlexPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSource>;
    /**
     * Redeem a plex token for an authenticated user, creating a connection
     */
    sourcesPlexRedeemTokenAuthenticatedCreateRaw(requestParameters: SourcesPlexRedeemTokenAuthenticatedCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Redeem a plex token for an authenticated user, creating a connection
     */
    sourcesPlexRedeemTokenAuthenticatedCreate(requestParameters: SourcesPlexRedeemTokenAuthenticatedCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Redeem a plex token, check it\'s access to resources against what\'s allowed for the source, and redirect to an authentication/enrollment flow.
     */
    sourcesPlexRedeemTokenCreateRaw(requestParameters: SourcesPlexRedeemTokenCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RedirectChallenge>>;
    /**
     * Redeem a plex token, check it\'s access to resources against what\'s allowed for the source, and redirect to an authentication/enrollment flow.
     */
    sourcesPlexRedeemTokenCreate(requestParameters: SourcesPlexRedeemTokenCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RedirectChallenge>;
    /**
     * Plex source Viewset
     */
    sourcesPlexRetrieveRaw(requestParameters: SourcesPlexRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSource>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexRetrieve(requestParameters: SourcesPlexRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSource>;
    /**
     * Plex source Viewset
     */
    sourcesPlexUpdateRaw(requestParameters: SourcesPlexUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSource>>;
    /**
     * Plex source Viewset
     */
    sourcesPlexUpdate(requestParameters: SourcesPlexUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSource>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesPlexUsedByListRaw(requestParameters: SourcesPlexUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesPlexUsedByList(requestParameters: SourcesPlexUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlCreateRaw(requestParameters: SourcesSamlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SAMLSource>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlCreate(requestParameters: SourcesSamlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SAMLSource>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlDestroyRaw(requestParameters: SourcesSamlDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlDestroy(requestParameters: SourcesSamlDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlListRaw(requestParameters: SourcesSamlListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSAMLSourceList>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlList(requestParameters?: SourcesSamlListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSAMLSourceList>;
    /**
     * Return metadata as XML string
     */
    sourcesSamlMetadataRetrieveRaw(requestParameters: SourcesSamlMetadataRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SAMLMetadata>>;
    /**
     * Return metadata as XML string
     */
    sourcesSamlMetadataRetrieve(requestParameters: SourcesSamlMetadataRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SAMLMetadata>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlPartialUpdateRaw(requestParameters: SourcesSamlPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SAMLSource>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlPartialUpdate(requestParameters: SourcesSamlPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SAMLSource>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlRetrieveRaw(requestParameters: SourcesSamlRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SAMLSource>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlRetrieve(requestParameters: SourcesSamlRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SAMLSource>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlUpdateRaw(requestParameters: SourcesSamlUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SAMLSource>>;
    /**
     * SAMLSource Viewset
     */
    sourcesSamlUpdate(requestParameters: SourcesSamlUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SAMLSource>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesSamlUsedByListRaw(requestParameters: SourcesSamlUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesSamlUsedByList(requestParameters: SourcesSamlUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimCreateRaw(requestParameters: SourcesScimCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSource>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimCreate(requestParameters: SourcesScimCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSource>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimDestroyRaw(requestParameters: SourcesScimDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimDestroy(requestParameters: SourcesScimDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsCreateRaw(requestParameters: SourcesScimGroupsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceGroup>>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsCreate(requestParameters: SourcesScimGroupsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceGroup>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsDestroyRaw(requestParameters: SourcesScimGroupsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsDestroy(requestParameters: SourcesScimGroupsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsListRaw(requestParameters: SourcesScimGroupsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSCIMSourceGroupList>>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsList(requestParameters?: SourcesScimGroupsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSCIMSourceGroupList>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsPartialUpdateRaw(requestParameters: SourcesScimGroupsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceGroup>>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsPartialUpdate(requestParameters: SourcesScimGroupsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceGroup>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsRetrieveRaw(requestParameters: SourcesScimGroupsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceGroup>>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsRetrieve(requestParameters: SourcesScimGroupsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceGroup>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsUpdateRaw(requestParameters: SourcesScimGroupsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceGroup>>;
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsUpdate(requestParameters: SourcesScimGroupsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceGroup>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimGroupsUsedByListRaw(requestParameters: SourcesScimGroupsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimGroupsUsedByList(requestParameters: SourcesScimGroupsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimListRaw(requestParameters: SourcesScimListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSCIMSourceList>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimList(requestParameters?: SourcesScimListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSCIMSourceList>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimPartialUpdateRaw(requestParameters: SourcesScimPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSource>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimPartialUpdate(requestParameters: SourcesScimPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSource>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimRetrieveRaw(requestParameters: SourcesScimRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSource>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimRetrieve(requestParameters: SourcesScimRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSource>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimUpdateRaw(requestParameters: SourcesScimUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSource>>;
    /**
     * SCIMSource Viewset
     */
    sourcesScimUpdate(requestParameters: SourcesScimUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSource>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsedByListRaw(requestParameters: SourcesScimUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsedByList(requestParameters: SourcesScimUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersCreateRaw(requestParameters: SourcesScimUsersCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceUser>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersCreate(requestParameters: SourcesScimUsersCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceUser>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersDestroyRaw(requestParameters: SourcesScimUsersDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersDestroy(requestParameters: SourcesScimUsersDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersListRaw(requestParameters: SourcesScimUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSCIMSourceUserList>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersList(requestParameters?: SourcesScimUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSCIMSourceUserList>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersPartialUpdateRaw(requestParameters: SourcesScimUsersPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceUser>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersPartialUpdate(requestParameters: SourcesScimUsersPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceUser>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersRetrieveRaw(requestParameters: SourcesScimUsersRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceUser>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersRetrieve(requestParameters: SourcesScimUsersRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceUser>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersUpdateRaw(requestParameters: SourcesScimUsersUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SCIMSourceUser>>;
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersUpdate(requestParameters: SourcesScimUsersUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SCIMSourceUser>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsersUsedByListRaw(requestParameters: SourcesScimUsersUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsersUsedByList(requestParameters: SourcesScimUsersUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllDestroyRaw(requestParameters: SourcesUserConnectionsAllDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllDestroy(requestParameters: SourcesUserConnectionsAllDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllListRaw(requestParameters: SourcesUserConnectionsAllListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserSourceConnectionList>>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllList(requestParameters?: SourcesUserConnectionsAllListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserSourceConnectionList>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllPartialUpdateRaw(requestParameters: SourcesUserConnectionsAllPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSourceConnection>>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllPartialUpdate(requestParameters: SourcesUserConnectionsAllPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSourceConnection>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllRetrieveRaw(requestParameters: SourcesUserConnectionsAllRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSourceConnection>>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllRetrieve(requestParameters: SourcesUserConnectionsAllRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSourceConnection>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllUpdateRaw(requestParameters: SourcesUserConnectionsAllUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSourceConnection>>;
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllUpdate(requestParameters: SourcesUserConnectionsAllUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSourceConnection>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsAllUsedByListRaw(requestParameters: SourcesUserConnectionsAllUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsAllUsedByList(requestParameters: SourcesUserConnectionsAllUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthCreateRaw(requestParameters: SourcesUserConnectionsOauthCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserOAuthSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthCreate(requestParameters: SourcesUserConnectionsOauthCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserOAuthSourceConnection>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthDestroyRaw(requestParameters: SourcesUserConnectionsOauthDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthDestroy(requestParameters: SourcesUserConnectionsOauthDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthListRaw(requestParameters: SourcesUserConnectionsOauthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserOAuthSourceConnectionList>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthList(requestParameters?: SourcesUserConnectionsOauthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserOAuthSourceConnectionList>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthPartialUpdateRaw(requestParameters: SourcesUserConnectionsOauthPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserOAuthSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthPartialUpdate(requestParameters: SourcesUserConnectionsOauthPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserOAuthSourceConnection>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthRetrieveRaw(requestParameters: SourcesUserConnectionsOauthRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserOAuthSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthRetrieve(requestParameters: SourcesUserConnectionsOauthRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserOAuthSourceConnection>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthUpdateRaw(requestParameters: SourcesUserConnectionsOauthUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserOAuthSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthUpdate(requestParameters: SourcesUserConnectionsOauthUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserOAuthSourceConnection>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsOauthUsedByListRaw(requestParameters: SourcesUserConnectionsOauthUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsOauthUsedByList(requestParameters: SourcesUserConnectionsOauthUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexCreateRaw(requestParameters: SourcesUserConnectionsPlexCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSourceConnection>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexCreate(requestParameters: SourcesUserConnectionsPlexCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSourceConnection>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexDestroyRaw(requestParameters: SourcesUserConnectionsPlexDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexDestroy(requestParameters: SourcesUserConnectionsPlexDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexListRaw(requestParameters: SourcesUserConnectionsPlexListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedPlexSourceConnectionList>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexList(requestParameters?: SourcesUserConnectionsPlexListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedPlexSourceConnectionList>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexPartialUpdateRaw(requestParameters: SourcesUserConnectionsPlexPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSourceConnection>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexPartialUpdate(requestParameters: SourcesUserConnectionsPlexPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSourceConnection>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexRetrieveRaw(requestParameters: SourcesUserConnectionsPlexRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSourceConnection>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexRetrieve(requestParameters: SourcesUserConnectionsPlexRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSourceConnection>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexUpdateRaw(requestParameters: SourcesUserConnectionsPlexUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PlexSourceConnection>>;
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexUpdate(requestParameters: SourcesUserConnectionsPlexUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PlexSourceConnection>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsPlexUsedByListRaw(requestParameters: SourcesUserConnectionsPlexUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsPlexUsedByList(requestParameters: SourcesUserConnectionsPlexUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlCreateRaw(requestParameters: SourcesUserConnectionsSamlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSAMLSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlCreate(requestParameters: SourcesUserConnectionsSamlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSAMLSourceConnection>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlDestroyRaw(requestParameters: SourcesUserConnectionsSamlDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlDestroy(requestParameters: SourcesUserConnectionsSamlDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlListRaw(requestParameters: SourcesUserConnectionsSamlListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserSAMLSourceConnectionList>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlList(requestParameters?: SourcesUserConnectionsSamlListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserSAMLSourceConnectionList>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlPartialUpdateRaw(requestParameters: SourcesUserConnectionsSamlPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSAMLSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlPartialUpdate(requestParameters: SourcesUserConnectionsSamlPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSAMLSourceConnection>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlRetrieveRaw(requestParameters: SourcesUserConnectionsSamlRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSAMLSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlRetrieve(requestParameters: SourcesUserConnectionsSamlRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSAMLSourceConnection>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlUpdateRaw(requestParameters: SourcesUserConnectionsSamlUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSAMLSourceConnection>>;
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlUpdate(requestParameters: SourcesUserConnectionsSamlUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSAMLSourceConnection>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsSamlUsedByListRaw(requestParameters: SourcesUserConnectionsSamlUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsSamlUsedByList(requestParameters: SourcesUserConnectionsSamlUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
}
/**
 * @export
 */
export declare const SourcesOauthListPolicyEngineModeEnum: {
    readonly All: "all";
    readonly Any: "any";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesOauthListPolicyEngineModeEnum = typeof SourcesOauthListPolicyEngineModeEnum[keyof typeof SourcesOauthListPolicyEngineModeEnum];
/**
 * @export
 */
export declare const SourcesOauthListUserMatchingModeEnum: {
    readonly EmailDeny: "email_deny";
    readonly EmailLink: "email_link";
    readonly Identifier: "identifier";
    readonly UsernameDeny: "username_deny";
    readonly UsernameLink: "username_link";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesOauthListUserMatchingModeEnum = typeof SourcesOauthListUserMatchingModeEnum[keyof typeof SourcesOauthListUserMatchingModeEnum];
/**
 * @export
 */
export declare const SourcesPlexListPolicyEngineModeEnum: {
    readonly All: "all";
    readonly Any: "any";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesPlexListPolicyEngineModeEnum = typeof SourcesPlexListPolicyEngineModeEnum[keyof typeof SourcesPlexListPolicyEngineModeEnum];
/**
 * @export
 */
export declare const SourcesPlexListUserMatchingModeEnum: {
    readonly EmailDeny: "email_deny";
    readonly EmailLink: "email_link";
    readonly Identifier: "identifier";
    readonly UsernameDeny: "username_deny";
    readonly UsernameLink: "username_link";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesPlexListUserMatchingModeEnum = typeof SourcesPlexListUserMatchingModeEnum[keyof typeof SourcesPlexListUserMatchingModeEnum];
/**
 * @export
 */
export declare const SourcesSamlListBindingTypeEnum: {
    readonly Post: "POST";
    readonly PostAuto: "POST_AUTO";
    readonly Redirect: "REDIRECT";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesSamlListBindingTypeEnum = typeof SourcesSamlListBindingTypeEnum[keyof typeof SourcesSamlListBindingTypeEnum];
/**
 * @export
 */
export declare const SourcesSamlListDigestAlgorithmEnum: {
    readonly _200009Xmldsigsha1: "http://www.w3.org/2000/09/xmldsig#sha1";
    readonly _200104XmldsigMoresha384: "http://www.w3.org/2001/04/xmldsig-more#sha384";
    readonly _200104Xmlencsha256: "http://www.w3.org/2001/04/xmlenc#sha256";
    readonly _200104Xmlencsha512: "http://www.w3.org/2001/04/xmlenc#sha512";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesSamlListDigestAlgorithmEnum = typeof SourcesSamlListDigestAlgorithmEnum[keyof typeof SourcesSamlListDigestAlgorithmEnum];
/**
 * @export
 */
export declare const SourcesSamlListNameIdPolicyEnum: {
    readonly _11nameidFormatemailAddress: "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    readonly _20nameidFormatWindowsDomainQualifiedName: "urn:oasis:names:tc:SAML:2.0:nameid-format:WindowsDomainQualifiedName";
    readonly _20nameidFormatX509SubjectName: "urn:oasis:names:tc:SAML:2.0:nameid-format:X509SubjectName";
    readonly _20nameidFormatpersistent: "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
    readonly _20nameidFormattransient: "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesSamlListNameIdPolicyEnum = typeof SourcesSamlListNameIdPolicyEnum[keyof typeof SourcesSamlListNameIdPolicyEnum];
/**
 * @export
 */
export declare const SourcesSamlListPolicyEngineModeEnum: {
    readonly All: "all";
    readonly Any: "any";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesSamlListPolicyEngineModeEnum = typeof SourcesSamlListPolicyEngineModeEnum[keyof typeof SourcesSamlListPolicyEngineModeEnum];
/**
 * @export
 */
export declare const SourcesSamlListSignatureAlgorithmEnum: {
    readonly _200009XmldsigdsaSha1: "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    readonly _200009XmldsigrsaSha1: "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    readonly _200104XmldsigMoreecdsaSha1: "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    readonly _200104XmldsigMoreecdsaSha256: "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
    readonly _200104XmldsigMoreecdsaSha384: "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
    readonly _200104XmldsigMoreecdsaSha512: "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
    readonly _200104XmldsigMorersaSha256: "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    readonly _200104XmldsigMorersaSha384: "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    readonly _200104XmldsigMorersaSha512: "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesSamlListSignatureAlgorithmEnum = typeof SourcesSamlListSignatureAlgorithmEnum[keyof typeof SourcesSamlListSignatureAlgorithmEnum];
/**
 * @export
 */
export declare const SourcesSamlListUserMatchingModeEnum: {
    readonly EmailDeny: "email_deny";
    readonly EmailLink: "email_link";
    readonly Identifier: "identifier";
    readonly UsernameDeny: "username_deny";
    readonly UsernameLink: "username_link";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type SourcesSamlListUserMatchingModeEnum = typeof SourcesSamlListUserMatchingModeEnum[keyof typeof SourcesSamlListUserMatchingModeEnum];
