"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreUsersListTypeEnum = exports.CoreTokensListIntentEnum = exports.CoreApi = void 0;
const runtime = require("../runtime");
const models_1 = require("../models");
/**
 *
 */
class CoreApi extends runtime.BaseAPI {
    /**
     * Check access to a single application by slug
     */
    coreApplicationsCheckAccessRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsCheckAccessRetrieve.');
            }
            const queryParameters = {};
            if (requestParameters.forUser !== undefined) {
                queryParameters['for_user'] = requestParameters.forUser;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/check_access/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyTestResultFromJSON)(jsonValue));
        });
    }
    /**
     * Check access to a single application by slug
     */
    coreApplicationsCheckAccessRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsCheckAccessRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.applicationRequest === null || requestParameters.applicationRequest === undefined) {
                throw new runtime.RequiredError('applicationRequest', 'Required parameter requestParameters.applicationRequest was null or undefined when calling coreApplicationsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ApplicationRequestToJSON)(requestParameters.applicationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ApplicationFromJSON)(jsonValue));
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreApplicationsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Custom list method that checks Policy based access instead of guardian
     */
    coreApplicationsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.forUser !== undefined) {
                queryParameters['for_user'] = requestParameters.forUser;
            }
            if (requestParameters.group !== undefined) {
                queryParameters['group'] = requestParameters.group;
            }
            if (requestParameters.metaDescription !== undefined) {
                queryParameters['meta_description'] = requestParameters.metaDescription;
            }
            if (requestParameters.metaLaunchUrl !== undefined) {
                queryParameters['meta_launch_url'] = requestParameters.metaLaunchUrl;
            }
            if (requestParameters.metaPublisher !== undefined) {
                queryParameters['meta_publisher'] = requestParameters.metaPublisher;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            if (requestParameters.superuserFullList !== undefined) {
                queryParameters['superuser_full_list'] = requestParameters.superuserFullList;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedApplicationListFromJSON)(jsonValue));
        });
    }
    /**
     * Custom list method that checks Policy based access instead of guardian
     */
    coreApplicationsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Metrics for application logins
     */
    coreApplicationsMetricsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsMetricsList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/metrics/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.CoordinateFromJSON));
        });
    }
    /**
     * Metrics for application logins
     */
    coreApplicationsMetricsList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsMetricsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedApplicationRequestToJSON)(requestParameters.patchedApplicationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ApplicationFromJSON)(jsonValue));
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ApplicationFromJSON)(jsonValue));
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Set application icon
     */
    coreApplicationsSetIconCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsSetIconCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const consumes = [
                { contentType: 'multipart/form-data' },
            ];
            // @ts-ignore: canConsumeForm may be unused
            const canConsumeForm = runtime.canConsumeForm(consumes);
            let formParams;
            let useForm = false;
            // use FormData to transmit files using content-type "multipart/form-data"
            useForm = canConsumeForm;
            if (useForm) {
                formParams = new FormData();
            }
            else {
                formParams = new URLSearchParams();
            }
            if (requestParameters.file !== undefined) {
                formParams.append('file', requestParameters.file);
            }
            if (requestParameters.clear !== undefined) {
                formParams.append('clear', requestParameters.clear);
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/set_icon/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: formParams,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Set application icon
     */
    coreApplicationsSetIconCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreApplicationsSetIconCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Set application icon (as URL)
     */
    coreApplicationsSetIconUrlCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsSetIconUrlCreate.');
            }
            if (requestParameters.filePathRequest === null || requestParameters.filePathRequest === undefined) {
                throw new runtime.RequiredError('filePathRequest', 'Required parameter requestParameters.filePathRequest was null or undefined when calling coreApplicationsSetIconUrlCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/set_icon_url/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.FilePathRequestToJSON)(requestParameters.filePathRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Set application icon (as URL)
     */
    coreApplicationsSetIconUrlCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreApplicationsSetIconUrlCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsUpdate.');
            }
            if (requestParameters.applicationRequest === null || requestParameters.applicationRequest === undefined) {
                throw new runtime.RequiredError('applicationRequest', 'Required parameter requestParameters.applicationRequest was null or undefined when calling coreApplicationsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ApplicationRequestToJSON)(requestParameters.applicationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ApplicationFromJSON)(jsonValue));
        });
    }
    /**
     * Application Viewset
     */
    coreApplicationsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreApplicationsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling coreApplicationsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/applications/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreApplicationsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreApplicationsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
                throw new runtime.RequiredError('uuid', 'Required parameter requestParameters.uuid was null or undefined when calling coreAuthenticatedSessionsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/authenticated_sessions/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreAuthenticatedSessionsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.lastIp !== undefined) {
                queryParameters['last_ip'] = requestParameters.lastIp;
            }
            if (requestParameters.lastUserAgent !== undefined) {
                queryParameters['last_user_agent'] = requestParameters.lastUserAgent;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.userUsername !== undefined) {
                queryParameters['user__username'] = requestParameters.userUsername;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/authenticated_sessions/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatedSessionListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreAuthenticatedSessionsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
                throw new runtime.RequiredError('uuid', 'Required parameter requestParameters.uuid was null or undefined when calling coreAuthenticatedSessionsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/authenticated_sessions/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatedSessionFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreAuthenticatedSessionsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreAuthenticatedSessionsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
                throw new runtime.RequiredError('uuid', 'Required parameter requestParameters.uuid was null or undefined when calling coreAuthenticatedSessionsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/authenticated_sessions/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreAuthenticatedSessionsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreAuthenticatedSessionsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.brandRequest === null || requestParameters.brandRequest === undefined) {
                throw new runtime.RequiredError('brandRequest', 'Required parameter requestParameters.brandRequest was null or undefined when calling coreBrandsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.BrandRequestToJSON)(requestParameters.brandRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.BrandFromJSON)(jsonValue));
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get current brand
     */
    coreBrandsCurrentRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/current/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.CurrentBrandFromJSON)(jsonValue));
        });
    }
    /**
     * Get current brand
     */
    coreBrandsCurrentRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsCurrentRetrieveRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
                throw new runtime.RequiredError('brandUuid', 'Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreBrandsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.brandUuid !== undefined) {
                queryParameters['brand_uuid'] = requestParameters.brandUuid;
            }
            if (requestParameters.brandingFavicon !== undefined) {
                queryParameters['branding_favicon'] = requestParameters.brandingFavicon;
            }
            if (requestParameters.brandingLogo !== undefined) {
                queryParameters['branding_logo'] = requestParameters.brandingLogo;
            }
            if (requestParameters.brandingTitle !== undefined) {
                queryParameters['branding_title'] = requestParameters.brandingTitle;
            }
            if (requestParameters._default !== undefined) {
                queryParameters['default'] = requestParameters._default;
            }
            if (requestParameters.domain !== undefined) {
                queryParameters['domain'] = requestParameters.domain;
            }
            if (requestParameters.flowAuthentication !== undefined) {
                queryParameters['flow_authentication'] = requestParameters.flowAuthentication;
            }
            if (requestParameters.flowDeviceCode !== undefined) {
                queryParameters['flow_device_code'] = requestParameters.flowDeviceCode;
            }
            if (requestParameters.flowInvalidation !== undefined) {
                queryParameters['flow_invalidation'] = requestParameters.flowInvalidation;
            }
            if (requestParameters.flowRecovery !== undefined) {
                queryParameters['flow_recovery'] = requestParameters.flowRecovery;
            }
            if (requestParameters.flowUnenrollment !== undefined) {
                queryParameters['flow_unenrollment'] = requestParameters.flowUnenrollment;
            }
            if (requestParameters.flowUserSettings !== undefined) {
                queryParameters['flow_user_settings'] = requestParameters.flowUserSettings;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.webCertificate !== undefined) {
                queryParameters['web_certificate'] = requestParameters.webCertificate;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedBrandListFromJSON)(jsonValue));
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
                throw new runtime.RequiredError('brandUuid', 'Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedBrandRequestToJSON)(requestParameters.patchedBrandRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.BrandFromJSON)(jsonValue));
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
                throw new runtime.RequiredError('brandUuid', 'Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.BrandFromJSON)(jsonValue));
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
                throw new runtime.RequiredError('brandUuid', 'Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsUpdate.');
            }
            if (requestParameters.brandRequest === null || requestParameters.brandRequest === undefined) {
                throw new runtime.RequiredError('brandRequest', 'Required parameter requestParameters.brandRequest was null or undefined when calling coreBrandsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.BrandRequestToJSON)(requestParameters.brandRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.BrandFromJSON)(jsonValue));
        });
    }
    /**
     * Brand Viewset
     */
    coreBrandsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreBrandsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
                throw new runtime.RequiredError('brandUuid', 'Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/brands/{brand_uuid}/used_by/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreBrandsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreBrandsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Add user to group
     */
    coreGroupsAddUserCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsAddUserCreate.');
            }
            if (requestParameters.userAccountRequest === null || requestParameters.userAccountRequest === undefined) {
                throw new runtime.RequiredError('userAccountRequest', 'Required parameter requestParameters.userAccountRequest was null or undefined when calling coreGroupsAddUserCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/add_user/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserAccountRequestToJSON)(requestParameters.userAccountRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Add user to group
     */
    coreGroupsAddUserCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreGroupsAddUserCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupRequest === null || requestParameters.groupRequest === undefined) {
                throw new runtime.RequiredError('groupRequest', 'Required parameter requestParameters.groupRequest was null or undefined when calling coreGroupsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.GroupRequestToJSON)(requestParameters.groupRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.GroupFromJSON)(jsonValue));
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreGroupsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreGroupsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.attributes !== undefined) {
                queryParameters['attributes'] = requestParameters.attributes;
            }
            if (requestParameters.includeUsers !== undefined) {
                queryParameters['include_users'] = requestParameters.includeUsers;
            }
            if (requestParameters.isSuperuser !== undefined) {
                queryParameters['is_superuser'] = requestParameters.isSuperuser;
            }
            if (requestParameters.membersByPk) {
                queryParameters['members_by_pk'] = requestParameters.membersByPk;
            }
            if (requestParameters.membersByUsername) {
                queryParameters['members_by_username'] = requestParameters.membersByUsername;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedGroupListFromJSON)(jsonValue));
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreGroupsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedGroupRequestToJSON)(requestParameters.patchedGroupRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.GroupFromJSON)(jsonValue));
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreGroupsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Add user to group
     */
    coreGroupsRemoveUserCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsRemoveUserCreate.');
            }
            if (requestParameters.userAccountRequest === null || requestParameters.userAccountRequest === undefined) {
                throw new runtime.RequiredError('userAccountRequest', 'Required parameter requestParameters.userAccountRequest was null or undefined when calling coreGroupsRemoveUserCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/remove_user/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserAccountRequestToJSON)(requestParameters.userAccountRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Add user to group
     */
    coreGroupsRemoveUserCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreGroupsRemoveUserCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsRetrieve.');
            }
            const queryParameters = {};
            if (requestParameters.includeUsers !== undefined) {
                queryParameters['include_users'] = requestParameters.includeUsers;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.GroupFromJSON)(jsonValue));
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreGroupsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsUpdate.');
            }
            if (requestParameters.groupRequest === null || requestParameters.groupRequest === undefined) {
                throw new runtime.RequiredError('groupRequest', 'Required parameter requestParameters.groupRequest was null or undefined when calling coreGroupsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.GroupRequestToJSON)(requestParameters.groupRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.GroupFromJSON)(jsonValue));
        });
    }
    /**
     * Group Viewset
     */
    coreGroupsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreGroupsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreGroupsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
                throw new runtime.RequiredError('groupUuid', 'Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/groups/{group_uuid}/used_by/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreGroupsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreGroupsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Token Viewset
     */
    coreTokensCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.tokenRequest === null || requestParameters.tokenRequest === undefined) {
                throw new runtime.RequiredError('tokenRequest', 'Required parameter requestParameters.tokenRequest was null or undefined when calling coreTokensCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TokenRequestToJSON)(requestParameters.tokenRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TokenFromJSON)(jsonValue));
        });
    }
    /**
     * Token Viewset
     */
    coreTokensCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Token Viewset
     */
    coreTokensDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Token Viewset
     */
    coreTokensDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreTokensDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Token Viewset
     */
    coreTokensListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.description !== undefined) {
                queryParameters['description'] = requestParameters.description;
            }
            if (requestParameters.expires !== undefined) {
                queryParameters['expires'] = requestParameters.expires.toISOString();
            }
            if (requestParameters.expiring !== undefined) {
                queryParameters['expiring'] = requestParameters.expiring;
            }
            if (requestParameters.identifier !== undefined) {
                queryParameters['identifier'] = requestParameters.identifier;
            }
            if (requestParameters.intent !== undefined) {
                queryParameters['intent'] = requestParameters.intent;
            }
            if (requestParameters.managed !== undefined) {
                queryParameters['managed'] = requestParameters.managed;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.userUsername !== undefined) {
                queryParameters['user__username'] = requestParameters.userUsername;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedTokenListFromJSON)(jsonValue));
        });
    }
    /**
     * Token Viewset
     */
    coreTokensList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Token Viewset
     */
    coreTokensPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedTokenRequestToJSON)(requestParameters.patchedTokenRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TokenFromJSON)(jsonValue));
        });
    }
    /**
     * Token Viewset
     */
    coreTokensPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Token Viewset
     */
    coreTokensRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TokenFromJSON)(jsonValue));
        });
    }
    /**
     * Token Viewset
     */
    coreTokensRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Set token key. Action is logged as event. `authentik_core.set_token_key` permission is required.
     */
    coreTokensSetKeyCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensSetKeyCreate.');
            }
            if (requestParameters.tokenSetKeyRequest === null || requestParameters.tokenSetKeyRequest === undefined) {
                throw new runtime.RequiredError('tokenSetKeyRequest', 'Required parameter requestParameters.tokenSetKeyRequest was null or undefined when calling coreTokensSetKeyCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/set_key/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TokenSetKeyRequestToJSON)(requestParameters.tokenSetKeyRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Set token key. Action is logged as event. `authentik_core.set_token_key` permission is required.
     */
    coreTokensSetKeyCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreTokensSetKeyCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Token Viewset
     */
    coreTokensUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensUpdate.');
            }
            if (requestParameters.tokenRequest === null || requestParameters.tokenRequest === undefined) {
                throw new runtime.RequiredError('tokenRequest', 'Required parameter requestParameters.tokenRequest was null or undefined when calling coreTokensUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TokenRequestToJSON)(requestParameters.tokenRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TokenFromJSON)(jsonValue));
        });
    }
    /**
     * Token Viewset
     */
    coreTokensUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreTokensUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/used_by/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreTokensUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Return token key and log access
     */
    coreTokensViewKeyRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
                throw new runtime.RequiredError('identifier', 'Required parameter requestParameters.identifier was null or undefined when calling coreTokensViewKeyRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/tokens/{identifier}/view_key/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TokenViewFromJSON)(jsonValue));
        });
    }
    /**
     * Return token key and log access
     */
    coreTokensViewKeyRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTokensViewKeyRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Convert data into a blueprint, validate it and apply it
     */
    coreTransactionalApplicationsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.transactionApplicationRequest === null || requestParameters.transactionApplicationRequest === undefined) {
                throw new runtime.RequiredError('transactionApplicationRequest', 'Required parameter requestParameters.transactionApplicationRequest was null or undefined when calling coreTransactionalApplicationsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/transactional/applications/`,
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TransactionApplicationRequestToJSON)(requestParameters.transactionApplicationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TransactionApplicationResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Convert data into a blueprint, validate it and apply it
     */
    coreTransactionalApplicationsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreTransactionalApplicationsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserConsent Viewset
     */
    coreUserConsentDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUserConsentDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/user_consent/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * UserConsent Viewset
     */
    coreUserConsentDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreUserConsentDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * UserConsent Viewset
     */
    coreUserConsentListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.application !== undefined) {
                queryParameters['application'] = requestParameters.application;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.user !== undefined) {
                queryParameters['user'] = requestParameters.user;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/user_consent/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserConsentListFromJSON)(jsonValue));
        });
    }
    /**
     * UserConsent Viewset
     */
    coreUserConsentList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUserConsentListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserConsent Viewset
     */
    coreUserConsentRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUserConsentRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/user_consent/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserConsentFromJSON)(jsonValue));
        });
    }
    /**
     * UserConsent Viewset
     */
    coreUserConsentRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUserConsentRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreUserConsentUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUserConsentUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/user_consent/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreUserConsentUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUserConsentUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User Viewset
     */
    coreUsersCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userRequest === null || requestParameters.userRequest === undefined) {
                throw new runtime.RequiredError('userRequest', 'Required parameter requestParameters.userRequest was null or undefined when calling coreUsersCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserRequestToJSON)(requestParameters.userRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserFromJSON)(jsonValue));
        });
    }
    /**
     * User Viewset
     */
    coreUsersCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User Viewset
     */
    coreUsersDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * User Viewset
     */
    coreUsersDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreUsersDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Impersonate a user
     */
    coreUsersImpersonateCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersImpersonateCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/impersonate/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Impersonate a user
     */
    coreUsersImpersonateCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreUsersImpersonateCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * End Impersonation a user
     */
    coreUsersImpersonateEndRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/impersonate_end/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * End Impersonation a user
     */
    coreUsersImpersonateEndRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreUsersImpersonateEndRetrieveRaw(initOverrides);
        });
    }
    /**
     * User Viewset
     */
    coreUsersListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.attributes !== undefined) {
                queryParameters['attributes'] = requestParameters.attributes;
            }
            if (requestParameters.email !== undefined) {
                queryParameters['email'] = requestParameters.email;
            }
            if (requestParameters.groupsByName) {
                queryParameters['groups_by_name'] = requestParameters.groupsByName;
            }
            if (requestParameters.groupsByPk) {
                queryParameters['groups_by_pk'] = requestParameters.groupsByPk;
            }
            if (requestParameters.includeGroups !== undefined) {
                queryParameters['include_groups'] = requestParameters.includeGroups;
            }
            if (requestParameters.isActive !== undefined) {
                queryParameters['is_active'] = requestParameters.isActive;
            }
            if (requestParameters.isSuperuser !== undefined) {
                queryParameters['is_superuser'] = requestParameters.isSuperuser;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.path !== undefined) {
                queryParameters['path'] = requestParameters.path;
            }
            if (requestParameters.pathStartswith !== undefined) {
                queryParameters['path_startswith'] = requestParameters.pathStartswith;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.type) {
                queryParameters['type'] = requestParameters.type;
            }
            if (requestParameters.username !== undefined) {
                queryParameters['username'] = requestParameters.username;
            }
            if (requestParameters.uuid !== undefined) {
                queryParameters['uuid'] = requestParameters.uuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserListFromJSON)(jsonValue));
        });
    }
    /**
     * User Viewset
     */
    coreUsersList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get information about current user
     */
    coreUsersMeRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/me/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SessionUserFromJSON)(jsonValue));
        });
    }
    /**
     * Get information about current user
     */
    coreUsersMeRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersMeRetrieveRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * User metrics per 1h
     */
    coreUsersMetricsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersMetricsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/metrics/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserMetricsFromJSON)(jsonValue));
        });
    }
    /**
     * User metrics per 1h
     */
    coreUsersMetricsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersMetricsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User Viewset
     */
    coreUsersPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserRequestToJSON)(requestParameters.patchedUserRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserFromJSON)(jsonValue));
        });
    }
    /**
     * User Viewset
     */
    coreUsersPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all user paths
     */
    coreUsersPathsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/paths/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserPathFromJSON)(jsonValue));
        });
    }
    /**
     * Get all user paths
     */
    coreUsersPathsRetrieve(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersPathsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersRecoveryCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/recovery/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LinkFromJSON)(jsonValue));
        });
    }
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersRecoveryCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryEmailCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.emailStage === null || requestParameters.emailStage === undefined) {
                throw new runtime.RequiredError('emailStage', 'Required parameter requestParameters.emailStage was null or undefined when calling coreUsersRecoveryEmailCreate.');
            }
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersRecoveryEmailCreate.');
            }
            const queryParameters = {};
            if (requestParameters.emailStage !== undefined) {
                queryParameters['email_stage'] = requestParameters.emailStage;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/recovery_email/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryEmailCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreUsersRecoveryEmailCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * User Viewset
     */
    coreUsersRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserFromJSON)(jsonValue));
        });
    }
    /**
     * User Viewset
     */
    coreUsersRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a new user account that is marked as a service account
     */
    coreUsersServiceAccountCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userServiceAccountRequest === null || requestParameters.userServiceAccountRequest === undefined) {
                throw new runtime.RequiredError('userServiceAccountRequest', 'Required parameter requestParameters.userServiceAccountRequest was null or undefined when calling coreUsersServiceAccountCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/service_account/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserServiceAccountRequestToJSON)(requestParameters.userServiceAccountRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserServiceAccountResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Create a new user account that is marked as a service account
     */
    coreUsersServiceAccountCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersServiceAccountCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Set password for user
     */
    coreUsersSetPasswordCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersSetPasswordCreate.');
            }
            if (requestParameters.userPasswordSetRequest === null || requestParameters.userPasswordSetRequest === undefined) {
                throw new runtime.RequiredError('userPasswordSetRequest', 'Required parameter requestParameters.userPasswordSetRequest was null or undefined when calling coreUsersSetPasswordCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/set_password/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserPasswordSetRequestToJSON)(requestParameters.userPasswordSetRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Set password for user
     */
    coreUsersSetPasswordCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.coreUsersSetPasswordCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * User Viewset
     */
    coreUsersUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersUpdate.');
            }
            if (requestParameters.userRequest === null || requestParameters.userRequest === undefined) {
                throw new runtime.RequiredError('userRequest', 'Required parameter requestParameters.userRequest was null or undefined when calling coreUsersUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserRequestToJSON)(requestParameters.userRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserFromJSON)(jsonValue));
        });
    }
    /**
     * User Viewset
     */
    coreUsersUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreUsersUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling coreUsersUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/core/users/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    coreUsersUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.coreUsersUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
}
exports.CoreApi = CoreApi;
/**
 * @export
 */
exports.CoreTokensListIntentEnum = {
    Api: 'api',
    AppPassword: 'app_password',
    Recovery: 'recovery',
    Verification: 'verification',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.CoreUsersListTypeEnum = {
    External: 'external',
    Internal: 'internal',
    InternalServiceAccount: 'internal_service_account',
    ServiceAccount: 'service_account',
    UnknownDefaultOpenApi: '11184809'
};
