from __future__ import annotations
import datetime
from collections.abc import Callable
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .entity import Entity
    from .malware_state_for_windows_device import MalwareStateForWindowsDevice
    from .windows_malware_category import WindowsMalwareCategory
    from .windows_malware_severity import WindowsMalwareSeverity

from .entity import Entity

@dataclass
class WindowsMalwareInformation(Entity, Parsable):
    """
    Malware information entity.
    """
    # Indicates an informational URL to learn more about the malware
    additional_information_url: Optional[str] = None
    # Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
    category: Optional[WindowsMalwareCategory] = None
    # List of devices affected by current malware with the malware state on each device
    device_malware_states: Optional[list[MalwareStateForWindowsDevice]] = None
    # Indicates the name of the malware
    display_name: Optional[str] = None
    # Indicates the last time the malware was detected in UTC
    last_detection_date_time: Optional[datetime.datetime] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
    severity: Optional[WindowsMalwareSeverity] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> WindowsMalwareInformation:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareInformation
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return WindowsMalwareInformation()
    
    def get_field_deserializers(self,) -> dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: dict[str, Callable[[ParseNode], None]]
        """
        from .entity import Entity
        from .malware_state_for_windows_device import MalwareStateForWindowsDevice
        from .windows_malware_category import WindowsMalwareCategory
        from .windows_malware_severity import WindowsMalwareSeverity

        from .entity import Entity
        from .malware_state_for_windows_device import MalwareStateForWindowsDevice
        from .windows_malware_category import WindowsMalwareCategory
        from .windows_malware_severity import WindowsMalwareSeverity

        fields: dict[str, Callable[[Any], None]] = {
            "additionalInformationUrl": lambda n : setattr(self, 'additional_information_url', n.get_str_value()),
            "category": lambda n : setattr(self, 'category', n.get_enum_value(WindowsMalwareCategory)),
            "deviceMalwareStates": lambda n : setattr(self, 'device_malware_states', n.get_collection_of_object_values(MalwareStateForWindowsDevice)),
            "displayName": lambda n : setattr(self, 'display_name', n.get_str_value()),
            "lastDetectionDateTime": lambda n : setattr(self, 'last_detection_date_time', n.get_datetime_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_enum_value(WindowsMalwareSeverity)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        writer.write_str_value("additionalInformationUrl", self.additional_information_url)
        writer.write_enum_value("category", self.category)
        writer.write_collection_of_object_values("deviceMalwareStates", self.device_malware_states)
        writer.write_str_value("displayName", self.display_name)
        writer.write_datetime_value("lastDetectionDateTime", self.last_detection_date_time)
        writer.write_enum_value("severity", self.severity)
    

