# ------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation.  All Rights Reserved.
# Licensed under the MIT License.
# See License in the project root for license information.
# ------------------------------------------------------------------------------

from abc import ABC, abstractmethod
from typing import Any

from .allowed_hosts_validator import AllowedHostsValidator


class AccessTokenProvider(ABC):
    """Defines a contract for obtaining access tokens for a given url.
    """

    @abstractmethod
    async def get_authorization_token(
        self, uri: str, additional_authentication_context: dict[str, Any] = {}
    ) -> str:
        """This method is called by the BaseBearerTokenAuthenticationProvider class to get the
        access token.

        Args:
            uri (str): The target URI to get an access token for.
            additional_authentication_context (dict):
        Returns:
            str: The access token to use for the request.
        """
        pass

    @abstractmethod
    def get_allowed_hosts_validator(self) -> AllowedHostsValidator:
        """Retrieves the allowed hosts validator.

        Returns:
            AllowedHostsValidator: The allowed hosts validator.
        """
        pass
