# Generated by Django 3.1.1 on 2020-09-18 16:53

from django.apps.registry import Apps
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def remove_unintended_attributes(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    db_alias = schema_editor.connection.alias
    User = apps.get_model("authentik_core", "User")
    for user in User.objects.using(db_alias).all():
        if "password_repeat" in user.attributes:
            del user.attributes["password_repeat"]
        if "password" in user.attributes:
            del user.attributes["password"]
        user.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_stages_user_write", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(remove_unintended_attributes),
    ]
