# Generated by Django 4.1.7 on 2023-05-19 21:55

import django.db.models.deletion
from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def migrate_verification_cert(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    """Migrate signing cert to verification_kp for backwards compat"""

    SAMLSource = apps.get_model("authentik_sources_saml", "samlsource")
    for source in SAMLSource.objects.using(schema_editor.connection.alias).all():
        source.verification_kp = source.signing_kp
        source.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_crypto", "0004_alter_certificatekeypair_name"),
        ("authentik_sources_saml", "0012_usersamlsourceconnection"),
    ]

    operations = [
        migrations.AddField(
            model_name="samlsource",
            name="verification_kp",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="authentik_crypto.certificatekeypair",
                verbose_name="Verification Certificate",
            ),
        ),
        migrations.RunPython(migrate_verification_cert),
        migrations.AlterField(
            model_name="samlsource",
            name="signing_kp",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Keypair used to sign outgoing Responses going to the Identity Provider.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="authentik_crypto.certificatekeypair",
                verbose_name="Signing Keypair",
            ),
        ),
    ]
