# Generated by Django 5.0.2 on 2024-02-29 11:21

import textwrap

from django.db import migrations


def migrate_ldap_property_mappings_object_field(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    LDAPPropertyMapping = apps.get_model("authentik_sources_ldap", "LDAPPropertyMapping")
    for mapping in LDAPPropertyMapping.objects.using(db_alias).all():
        mapping.expression = f"""
# This property mapping has been automatically changed to
# match the new semantics of source property mappings.
# You can simplify it if you want.
# You should return a dictionary of fields to set on the user or the group.
# For instance:
# return {{
#     "{mapping.object_field}": ldap.get("{mapping.object_field}")
# }}
# Note that this example has been generated and should not be used as-is.
def get_field():
    {textwrap.indent(mapping.expression, prefix='    ')}

from authentik.lib.utils.dict import set_path_in_dict

field = "{mapping.object_field}"
result = {{"attributes": {{}}}}
if field.startswith("attributes."):
    set_path_in_dict(result, field, get_field(), sep=".")
else:
    result[field] = get_field()
return result
        """
        mapping.save()


def migrate_ldap_property_mappings_to_new_fields(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    LDAPSource = apps.get_model("authentik_sources_ldap", "LDAPSource")
    for source in LDAPSource.objects.using(db_alias).all():
        source.user_property_mappings.set(source.property_mappings.using(db_alias).all())
        source.group_property_mappings.set(source.property_mappings_group.using(db_alias).all())


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_sources_ldap", "0004_ldapsource_password_login_update_internal_password"),
        ("authentik_core", "0036_source_group_property_mappings_and_more"),
    ]

    operations = [
        migrations.RunPython(migrate_ldap_property_mappings_object_field),
        migrations.RunPython(migrate_ldap_property_mappings_to_new_fields),
        migrations.RemoveField(
            model_name="ldappropertymapping",
            name="object_field",
        ),
        migrations.RemoveField(
            model_name="ldapsource",
            name="property_mappings_group",
        ),
    ]
