# Generated by Django 3.2.8 on 2021-10-10 16:08

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ("authentik_flows", "0001_initial"),
        ("authentik_flows", "0003_auto_20200523_1133"),
        ("authentik_flows", "0006_auto_20200629_0857"),
        ("authentik_flows", "0007_auto_20200703_2059"),
    ]

    initial = True

    dependencies = [
        ("authentik_policies", "0001_initial"),
        ("authentik_policies", "0002_auto_20200528_1647"),
    ]

    operations = [
        migrations.CreateModel(
            name="Flow",
            fields=[
                (
                    "flow_uuid",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.TextField()),
                ("slug", models.SlugField(unique=True)),
                (
                    "designation",
                    models.CharField(
                        choices=[
                            ("authentication", "Authentication"),
                            ("invalidation", "Invalidation"),
                            ("enrollment", "Enrollment"),
                            ("unenrollment", "Unrenollment"),
                            ("recovery", "Recovery"),
                            ("password_change", "Password Change"),
                        ],
                        max_length=100,
                    ),
                ),
                (
                    "pbm",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        related_name="+",
                        to="authentik_policies.policybindingmodel",
                    ),
                ),
            ],
            options={
                "verbose_name": "Flow",
                "verbose_name_plural": "Flows",
            },
            bases=("authentik_policies.policybindingmodel",),
        ),
        migrations.CreateModel(
            name="Stage",
            fields=[
                (
                    "stage_uuid",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="FlowStageBinding",
            fields=[
                (
                    "policybindingmodel_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        to="authentik_policies.policybindingmodel",
                    ),
                ),
                (
                    "fsb_uuid",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "re_evaluate_policies",
                    models.BooleanField(
                        default=False,
                        help_text=(
                            "When this option is enabled, the planner will re-evaluate policies"
                            " bound to this."
                        ),
                    ),
                ),
                ("order", models.IntegerField()),
                (
                    "target",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="authentik_flows.flow"
                    ),
                ),
                (
                    "stage",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="authentik_flows.stage"
                    ),
                ),
            ],
            options={
                "verbose_name": "Flow Stage Binding",
                "verbose_name_plural": "Flow Stage Bindings",
                "ordering": ["order", "target"],
                "unique_together": {("target", "stage", "order")},
            },
            bases=("authentik_policies.policybindingmodel",),
        ),
        migrations.AddField(
            model_name="flow",
            name="stages",
            field=models.ManyToManyField(
                blank=True, through="authentik_flows.FlowStageBinding", to="authentik_flows.Stage"
            ),
        ),
        migrations.AlterField(
            model_name="flow",
            name="designation",
            field=models.CharField(
                choices=[
                    ("authentication", "Authentication"),
                    ("authorization", "Authorization"),
                    ("invalidation", "Invalidation"),
                    ("enrollment", "Enrollment"),
                    ("unenrollment", "Unrenollment"),
                    ("recovery", "Recovery"),
                    ("password_change", "Password Change"),
                ],
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="flow",
            name="designation",
            field=models.CharField(
                choices=[
                    ("authentication", "Authentication"),
                    ("authorization", "Authorization"),
                    ("invalidation", "Invalidation"),
                    ("enrollment", "Enrollment"),
                    ("unenrollment", "Unrenollment"),
                    ("recovery", "Recovery"),
                    ("stage_setup", "Stage Setup"),
                ],
                max_length=100,
            ),
        ),
        migrations.RenameField(
            model_name="flow",
            old_name="pbm",
            new_name="policybindingmodel_ptr",
        ),
        migrations.AlterField(
            model_name="flow",
            name="policybindingmodel_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                to="authentik_policies.policybindingmodel",
            ),
        ),
    ]
