/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { BindingTypeEnum } from './BindingTypeEnum';
import {
    BindingTypeEnumFromJSON,
    BindingTypeEnumFromJSONTyped,
    BindingTypeEnumToJSON,
} from './BindingTypeEnum';
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import {
    DigestAlgorithmEnumFromJSON,
    DigestAlgorithmEnumFromJSONTyped,
    DigestAlgorithmEnumToJSON,
} from './DigestAlgorithmEnum';
import type { NameIdPolicyEnum } from './NameIdPolicyEnum';
import {
    NameIdPolicyEnumFromJSON,
    NameIdPolicyEnumFromJSONTyped,
    NameIdPolicyEnumToJSON,
} from './NameIdPolicyEnum';
import type { PolicyEngineMode } from './PolicyEngineMode';
import {
    PolicyEngineModeFromJSON,
    PolicyEngineModeFromJSONTyped,
    PolicyEngineModeToJSON,
} from './PolicyEngineMode';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import {
    SignatureAlgorithmEnumFromJSON,
    SignatureAlgorithmEnumFromJSONTyped,
    SignatureAlgorithmEnumToJSON,
} from './SignatureAlgorithmEnum';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
import {
    UserMatchingModeEnumFromJSON,
    UserMatchingModeEnumFromJSONTyped,
    UserMatchingModeEnumToJSON,
} from './UserMatchingModeEnum';

/**
 * SAMLSource Serializer
 * @export
 * @interface SAMLSource
 */
export interface SAMLSource {
    /**
     * 
     * @type {string}
     * @memberof SAMLSource
     */
    readonly pk: string;
    /**
     * Source's display Name.
     * @type {string}
     * @memberof SAMLSource
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof SAMLSource
     */
    slug: string;
    /**
     * 
     * @type {boolean}
     * @memberof SAMLSource
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof SAMLSource
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof SAMLSource
     */
    enrollmentFlow?: string | null;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof SAMLSource
     */
    readonly component: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof SAMLSource
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof SAMLSource
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof SAMLSource
     */
    readonly metaModelName: string;
    /**
     * 
     * @type {PolicyEngineMode}
     * @memberof SAMLSource
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     * 
     * @type {UserMatchingModeEnum}
     * @memberof SAMLSource
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     * Objects that are managed by authentik. These objects are created and updated automatically. This flag only indicates that an object can be overwritten by migrations. You can still modify the objects via the API, but expect changes to be overwritten in a later update.
     * @type {string}
     * @memberof SAMLSource
     */
    readonly managed: string | null;
    /**
     * 
     * @type {string}
     * @memberof SAMLSource
     */
    userPathTemplate?: string;
    /**
     * 
     * @type {string}
     * @memberof SAMLSource
     */
    readonly icon: string;
    /**
     * Flow used before authentication.
     * @type {string}
     * @memberof SAMLSource
     */
    preAuthenticationFlow: string;
    /**
     * Also known as Entity ID. Defaults the Metadata URL.
     * @type {string}
     * @memberof SAMLSource
     */
    issuer?: string;
    /**
     * URL that the initial Login request is sent to.
     * @type {string}
     * @memberof SAMLSource
     */
    ssoUrl: string;
    /**
     * Optional URL if your IDP supports Single-Logout.
     * @type {string}
     * @memberof SAMLSource
     */
    sloUrl?: string | null;
    /**
     * Allows authentication flows initiated by the IdP. This can be a security risk, as no validation of the request ID is done.
     * @type {boolean}
     * @memberof SAMLSource
     */
    allowIdpInitiated?: boolean;
    /**
     * 
     * @type {NameIdPolicyEnum}
     * @memberof SAMLSource
     */
    nameIdPolicy?: NameIdPolicyEnum;
    /**
     * 
     * @type {BindingTypeEnum}
     * @memberof SAMLSource
     */
    bindingType?: BindingTypeEnum;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLSource
     */
    verificationKp?: string | null;
    /**
     * Keypair used to sign outgoing Responses going to the Identity Provider.
     * @type {string}
     * @memberof SAMLSource
     */
    signingKp?: string | null;
    /**
     * 
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLSource
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     * 
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLSource
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Time offset when temporary users should be deleted. This only applies if your IDP uses the NameID Format 'transient', and the user doesn't log out manually. (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLSource
     */
    temporaryUserDeleteAfter?: string;
}

/**
 * Check if a given object implements the SAMLSource interface.
 */
export function instanceOfSAMLSource(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "slug" in value;
    isInstance = isInstance && "component" in value;
    isInstance = isInstance && "verboseName" in value;
    isInstance = isInstance && "verboseNamePlural" in value;
    isInstance = isInstance && "metaModelName" in value;
    isInstance = isInstance && "managed" in value;
    isInstance = isInstance && "icon" in value;
    isInstance = isInstance && "preAuthenticationFlow" in value;
    isInstance = isInstance && "ssoUrl" in value;

    return isInstance;
}

export function SAMLSourceFromJSON(json: any): SAMLSource {
    return SAMLSourceFromJSONTyped(json, false);
}

export function SAMLSourceFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLSource {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'name': json['name'],
        'slug': json['slug'],
        'enabled': !exists(json, 'enabled') ? undefined : json['enabled'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'enrollmentFlow': !exists(json, 'enrollment_flow') ? undefined : json['enrollment_flow'],
        'component': json['component'],
        'verboseName': json['verbose_name'],
        'verboseNamePlural': json['verbose_name_plural'],
        'metaModelName': json['meta_model_name'],
        'policyEngineMode': !exists(json, 'policy_engine_mode') ? undefined : PolicyEngineModeFromJSON(json['policy_engine_mode']),
        'userMatchingMode': !exists(json, 'user_matching_mode') ? undefined : UserMatchingModeEnumFromJSON(json['user_matching_mode']),
        'managed': json['managed'],
        'userPathTemplate': !exists(json, 'user_path_template') ? undefined : json['user_path_template'],
        'icon': json['icon'],
        'preAuthenticationFlow': json['pre_authentication_flow'],
        'issuer': !exists(json, 'issuer') ? undefined : json['issuer'],
        'ssoUrl': json['sso_url'],
        'sloUrl': !exists(json, 'slo_url') ? undefined : json['slo_url'],
        'allowIdpInitiated': !exists(json, 'allow_idp_initiated') ? undefined : json['allow_idp_initiated'],
        'nameIdPolicy': !exists(json, 'name_id_policy') ? undefined : NameIdPolicyEnumFromJSON(json['name_id_policy']),
        'bindingType': !exists(json, 'binding_type') ? undefined : BindingTypeEnumFromJSON(json['binding_type']),
        'verificationKp': !exists(json, 'verification_kp') ? undefined : json['verification_kp'],
        'signingKp': !exists(json, 'signing_kp') ? undefined : json['signing_kp'],
        'digestAlgorithm': !exists(json, 'digest_algorithm') ? undefined : DigestAlgorithmEnumFromJSON(json['digest_algorithm']),
        'signatureAlgorithm': !exists(json, 'signature_algorithm') ? undefined : SignatureAlgorithmEnumFromJSON(json['signature_algorithm']),
        'temporaryUserDeleteAfter': !exists(json, 'temporary_user_delete_after') ? undefined : json['temporary_user_delete_after'],
    };
}

export function SAMLSourceToJSON(value?: SAMLSource | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'slug': value.slug,
        'enabled': value.enabled,
        'authentication_flow': value.authenticationFlow,
        'enrollment_flow': value.enrollmentFlow,
        'policy_engine_mode': PolicyEngineModeToJSON(value.policyEngineMode),
        'user_matching_mode': UserMatchingModeEnumToJSON(value.userMatchingMode),
        'user_path_template': value.userPathTemplate,
        'pre_authentication_flow': value.preAuthenticationFlow,
        'issuer': value.issuer,
        'sso_url': value.ssoUrl,
        'slo_url': value.sloUrl,
        'allow_idp_initiated': value.allowIdpInitiated,
        'name_id_policy': NameIdPolicyEnumToJSON(value.nameIdPolicy),
        'binding_type': BindingTypeEnumToJSON(value.bindingType),
        'verification_kp': value.verificationKp,
        'signing_kp': value.signingKp,
        'digest_algorithm': DigestAlgorithmEnumToJSON(value.digestAlgorithm),
        'signature_algorithm': SignatureAlgorithmEnumToJSON(value.signatureAlgorithm),
        'temporary_user_delete_after': value.temporaryUserDeleteAfter,
    };
}

