/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { ClientTypeEnum } from './ClientTypeEnum';
import {
    ClientTypeEnumFromJSON,
    ClientTypeEnumFromJSONTyped,
    ClientTypeEnumToJSON,
} from './ClientTypeEnum';
import type { IssuerModeEnum } from './IssuerModeEnum';
import {
    IssuerModeEnumFromJSON,
    IssuerModeEnumFromJSONTyped,
    IssuerModeEnumToJSON,
} from './IssuerModeEnum';
import type { SubModeEnum } from './SubModeEnum';
import {
    SubModeEnumFromJSON,
    SubModeEnumFromJSONTyped,
    SubModeEnumToJSON,
} from './SubModeEnum';

/**
 * OAuth2Provider Serializer
 * @export
 * @interface OAuth2Provider
 */
export interface OAuth2Provider {
    /**
     * 
     * @type {number}
     * @memberof OAuth2Provider
     */
    readonly pk: number;
    /**
     * 
     * @type {string}
     * @memberof OAuth2Provider
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof OAuth2Provider
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof OAuth2Provider
     */
    authorizationFlow: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof OAuth2Provider
     */
    propertyMappings?: Array<string>;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly component: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly assignedApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly assignedApplicationName: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly assignedBackchannelApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly assignedBackchannelApplicationName: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof OAuth2Provider
     */
    readonly metaModelName: string;
    /**
     * 
     * @type {ClientTypeEnum}
     * @memberof OAuth2Provider
     */
    clientType?: ClientTypeEnum;
    /**
     * 
     * @type {string}
     * @memberof OAuth2Provider
     */
    clientId?: string;
    /**
     * 
     * @type {string}
     * @memberof OAuth2Provider
     */
    clientSecret?: string;
    /**
     * Access codes not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof OAuth2Provider
     */
    accessCodeValidity?: string;
    /**
     * Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof OAuth2Provider
     */
    accessTokenValidity?: string;
    /**
     * Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof OAuth2Provider
     */
    refreshTokenValidity?: string;
    /**
     * Include User claims from scopes in the id_token, for applications that don't access the userinfo endpoint.
     * @type {boolean}
     * @memberof OAuth2Provider
     */
    includeClaimsInIdToken?: boolean;
    /**
     * Key used to sign the tokens. Only required when JWT Algorithm is set to RS256.
     * @type {string}
     * @memberof OAuth2Provider
     */
    signingKey?: string | null;
    /**
     * Enter each URI on a new line.
     * @type {string}
     * @memberof OAuth2Provider
     */
    redirectUris?: string;
    /**
     * 
     * @type {SubModeEnum}
     * @memberof OAuth2Provider
     */
    subMode?: SubModeEnum;
    /**
     * 
     * @type {IssuerModeEnum}
     * @memberof OAuth2Provider
     */
    issuerMode?: IssuerModeEnum;
    /**
     * 
     * @type {Array<string>}
     * @memberof OAuth2Provider
     */
    jwksSources?: Array<string>;
}

/**
 * Check if a given object implements the OAuth2Provider interface.
 */
export function instanceOfOAuth2Provider(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "authorizationFlow" in value;
    isInstance = isInstance && "component" in value;
    isInstance = isInstance && "assignedApplicationSlug" in value;
    isInstance = isInstance && "assignedApplicationName" in value;
    isInstance = isInstance && "assignedBackchannelApplicationSlug" in value;
    isInstance = isInstance && "assignedBackchannelApplicationName" in value;
    isInstance = isInstance && "verboseName" in value;
    isInstance = isInstance && "verboseNamePlural" in value;
    isInstance = isInstance && "metaModelName" in value;

    return isInstance;
}

export function OAuth2ProviderFromJSON(json: any): OAuth2Provider {
    return OAuth2ProviderFromJSONTyped(json, false);
}

export function OAuth2ProviderFromJSONTyped(json: any, ignoreDiscriminator: boolean): OAuth2Provider {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'name': json['name'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'authorizationFlow': json['authorization_flow'],
        'propertyMappings': !exists(json, 'property_mappings') ? undefined : json['property_mappings'],
        'component': json['component'],
        'assignedApplicationSlug': json['assigned_application_slug'],
        'assignedApplicationName': json['assigned_application_name'],
        'assignedBackchannelApplicationSlug': json['assigned_backchannel_application_slug'],
        'assignedBackchannelApplicationName': json['assigned_backchannel_application_name'],
        'verboseName': json['verbose_name'],
        'verboseNamePlural': json['verbose_name_plural'],
        'metaModelName': json['meta_model_name'],
        'clientType': !exists(json, 'client_type') ? undefined : ClientTypeEnumFromJSON(json['client_type']),
        'clientId': !exists(json, 'client_id') ? undefined : json['client_id'],
        'clientSecret': !exists(json, 'client_secret') ? undefined : json['client_secret'],
        'accessCodeValidity': !exists(json, 'access_code_validity') ? undefined : json['access_code_validity'],
        'accessTokenValidity': !exists(json, 'access_token_validity') ? undefined : json['access_token_validity'],
        'refreshTokenValidity': !exists(json, 'refresh_token_validity') ? undefined : json['refresh_token_validity'],
        'includeClaimsInIdToken': !exists(json, 'include_claims_in_id_token') ? undefined : json['include_claims_in_id_token'],
        'signingKey': !exists(json, 'signing_key') ? undefined : json['signing_key'],
        'redirectUris': !exists(json, 'redirect_uris') ? undefined : json['redirect_uris'],
        'subMode': !exists(json, 'sub_mode') ? undefined : SubModeEnumFromJSON(json['sub_mode']),
        'issuerMode': !exists(json, 'issuer_mode') ? undefined : IssuerModeEnumFromJSON(json['issuer_mode']),
        'jwksSources': !exists(json, 'jwks_sources') ? undefined : json['jwks_sources'],
    };
}

export function OAuth2ProviderToJSON(value?: OAuth2Provider | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'authentication_flow': value.authenticationFlow,
        'authorization_flow': value.authorizationFlow,
        'property_mappings': value.propertyMappings,
        'client_type': ClientTypeEnumToJSON(value.clientType),
        'client_id': value.clientId,
        'client_secret': value.clientSecret,
        'access_code_validity': value.accessCodeValidity,
        'access_token_validity': value.accessTokenValidity,
        'refresh_token_validity': value.refreshTokenValidity,
        'include_claims_in_id_token': value.includeClaimsInIdToken,
        'signing_key': value.signingKey,
        'redirect_uris': value.redirectUris,
        'sub_mode': SubModeEnumToJSON(value.subMode),
        'issuer_mode': IssuerModeEnumToJSON(value.issuerMode),
        'jwks_sources': value.jwksSources,
    };
}

