/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ConnectionToken,
  ConnectionTokenRequest,
  Endpoint,
  EndpointRequest,
  GenericError,
  PaginatedConnectionTokenList,
  PaginatedEndpointList,
  PatchedConnectionTokenRequest,
  PatchedEndpointRequest,
  UsedBy,
  ValidationError,
} from '../models';
import {
    ConnectionTokenFromJSON,
    ConnectionTokenToJSON,
    ConnectionTokenRequestFromJSON,
    ConnectionTokenRequestToJSON,
    EndpointFromJSON,
    EndpointToJSON,
    EndpointRequestFromJSON,
    EndpointRequestToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    PaginatedConnectionTokenListFromJSON,
    PaginatedConnectionTokenListToJSON,
    PaginatedEndpointListFromJSON,
    PaginatedEndpointListToJSON,
    PatchedConnectionTokenRequestFromJSON,
    PatchedConnectionTokenRequestToJSON,
    PatchedEndpointRequestFromJSON,
    PatchedEndpointRequestToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface RacConnectionTokensDestroyRequest {
    connectionTokenUuid: string;
}

export interface RacConnectionTokensListRequest {
    endpoint?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    provider?: number;
    search?: string;
    sessionUser?: number;
}

export interface RacConnectionTokensPartialUpdateRequest {
    connectionTokenUuid: string;
    patchedConnectionTokenRequest?: PatchedConnectionTokenRequest;
}

export interface RacConnectionTokensRetrieveRequest {
    connectionTokenUuid: string;
}

export interface RacConnectionTokensUpdateRequest {
    connectionTokenUuid: string;
    connectionTokenRequest: ConnectionTokenRequest;
}

export interface RacConnectionTokensUsedByListRequest {
    connectionTokenUuid: string;
}

export interface RacEndpointsCreateRequest {
    endpointRequest: EndpointRequest;
}

export interface RacEndpointsDestroyRequest {
    pbmUuid: string;
}

export interface RacEndpointsListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    provider?: number;
    search?: string;
    superuserFullList?: boolean;
}

export interface RacEndpointsPartialUpdateRequest {
    pbmUuid: string;
    patchedEndpointRequest?: PatchedEndpointRequest;
}

export interface RacEndpointsRetrieveRequest {
    pbmUuid: string;
}

export interface RacEndpointsUpdateRequest {
    pbmUuid: string;
    endpointRequest: EndpointRequest;
}

export interface RacEndpointsUsedByListRequest {
    pbmUuid: string;
}

/**
 * 
 */
export class RacApi extends runtime.BaseAPI {

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensDestroyRaw(requestParameters: RacConnectionTokensDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.connectionTokenUuid === null || requestParameters.connectionTokenUuid === undefined) {
            throw new runtime.RequiredError('connectionTokenUuid','Required parameter requestParameters.connectionTokenUuid was null or undefined when calling racConnectionTokensDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/connection_tokens/{connection_token_uuid}/`.replace(`{${"connection_token_uuid"}}`, encodeURIComponent(String(requestParameters.connectionTokenUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensDestroy(requestParameters: RacConnectionTokensDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.racConnectionTokensDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensListRaw(requestParameters: RacConnectionTokensListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedConnectionTokenList>> {
        const queryParameters: any = {};

        if (requestParameters.endpoint !== undefined) {
            queryParameters['endpoint'] = requestParameters.endpoint;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.provider !== undefined) {
            queryParameters['provider'] = requestParameters.provider;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.sessionUser !== undefined) {
            queryParameters['session__user'] = requestParameters.sessionUser;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/connection_tokens/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedConnectionTokenListFromJSON(jsonValue));
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensList(requestParameters: RacConnectionTokensListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedConnectionTokenList> {
        const response = await this.racConnectionTokensListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensPartialUpdateRaw(requestParameters: RacConnectionTokensPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConnectionToken>> {
        if (requestParameters.connectionTokenUuid === null || requestParameters.connectionTokenUuid === undefined) {
            throw new runtime.RequiredError('connectionTokenUuid','Required parameter requestParameters.connectionTokenUuid was null or undefined when calling racConnectionTokensPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/connection_tokens/{connection_token_uuid}/`.replace(`{${"connection_token_uuid"}}`, encodeURIComponent(String(requestParameters.connectionTokenUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedConnectionTokenRequestToJSON(requestParameters.patchedConnectionTokenRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConnectionTokenFromJSON(jsonValue));
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensPartialUpdate(requestParameters: RacConnectionTokensPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConnectionToken> {
        const response = await this.racConnectionTokensPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensRetrieveRaw(requestParameters: RacConnectionTokensRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConnectionToken>> {
        if (requestParameters.connectionTokenUuid === null || requestParameters.connectionTokenUuid === undefined) {
            throw new runtime.RequiredError('connectionTokenUuid','Required parameter requestParameters.connectionTokenUuid was null or undefined when calling racConnectionTokensRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/connection_tokens/{connection_token_uuid}/`.replace(`{${"connection_token_uuid"}}`, encodeURIComponent(String(requestParameters.connectionTokenUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConnectionTokenFromJSON(jsonValue));
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensRetrieve(requestParameters: RacConnectionTokensRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConnectionToken> {
        const response = await this.racConnectionTokensRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensUpdateRaw(requestParameters: RacConnectionTokensUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConnectionToken>> {
        if (requestParameters.connectionTokenUuid === null || requestParameters.connectionTokenUuid === undefined) {
            throw new runtime.RequiredError('connectionTokenUuid','Required parameter requestParameters.connectionTokenUuid was null or undefined when calling racConnectionTokensUpdate.');
        }

        if (requestParameters.connectionTokenRequest === null || requestParameters.connectionTokenRequest === undefined) {
            throw new runtime.RequiredError('connectionTokenRequest','Required parameter requestParameters.connectionTokenRequest was null or undefined when calling racConnectionTokensUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/connection_tokens/{connection_token_uuid}/`.replace(`{${"connection_token_uuid"}}`, encodeURIComponent(String(requestParameters.connectionTokenUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: ConnectionTokenRequestToJSON(requestParameters.connectionTokenRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConnectionTokenFromJSON(jsonValue));
    }

    /**
     * ConnectionToken Viewset
     */
    async racConnectionTokensUpdate(requestParameters: RacConnectionTokensUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConnectionToken> {
        const response = await this.racConnectionTokensUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async racConnectionTokensUsedByListRaw(requestParameters: RacConnectionTokensUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.connectionTokenUuid === null || requestParameters.connectionTokenUuid === undefined) {
            throw new runtime.RequiredError('connectionTokenUuid','Required parameter requestParameters.connectionTokenUuid was null or undefined when calling racConnectionTokensUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/connection_tokens/{connection_token_uuid}/used_by/`.replace(`{${"connection_token_uuid"}}`, encodeURIComponent(String(requestParameters.connectionTokenUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async racConnectionTokensUsedByList(requestParameters: RacConnectionTokensUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.racConnectionTokensUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsCreateRaw(requestParameters: RacEndpointsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Endpoint>> {
        if (requestParameters.endpointRequest === null || requestParameters.endpointRequest === undefined) {
            throw new runtime.RequiredError('endpointRequest','Required parameter requestParameters.endpointRequest was null or undefined when calling racEndpointsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: EndpointRequestToJSON(requestParameters.endpointRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EndpointFromJSON(jsonValue));
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsCreate(requestParameters: RacEndpointsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Endpoint> {
        const response = await this.racEndpointsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsDestroyRaw(requestParameters: RacEndpointsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling racEndpointsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsDestroy(requestParameters: RacEndpointsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.racEndpointsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * List accessible endpoints
     */
    async racEndpointsListRaw(requestParameters: RacEndpointsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedEndpointList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.provider !== undefined) {
            queryParameters['provider'] = requestParameters.provider;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.superuserFullList !== undefined) {
            queryParameters['superuser_full_list'] = requestParameters.superuserFullList;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedEndpointListFromJSON(jsonValue));
    }

    /**
     * List accessible endpoints
     */
    async racEndpointsList(requestParameters: RacEndpointsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedEndpointList> {
        const response = await this.racEndpointsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsPartialUpdateRaw(requestParameters: RacEndpointsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Endpoint>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling racEndpointsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedEndpointRequestToJSON(requestParameters.patchedEndpointRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EndpointFromJSON(jsonValue));
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsPartialUpdate(requestParameters: RacEndpointsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Endpoint> {
        const response = await this.racEndpointsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsRetrieveRaw(requestParameters: RacEndpointsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Endpoint>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling racEndpointsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EndpointFromJSON(jsonValue));
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsRetrieve(requestParameters: RacEndpointsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Endpoint> {
        const response = await this.racEndpointsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsUpdateRaw(requestParameters: RacEndpointsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Endpoint>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling racEndpointsUpdate.');
        }

        if (requestParameters.endpointRequest === null || requestParameters.endpointRequest === undefined) {
            throw new runtime.RequiredError('endpointRequest','Required parameter requestParameters.endpointRequest was null or undefined when calling racEndpointsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: EndpointRequestToJSON(requestParameters.endpointRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EndpointFromJSON(jsonValue));
    }

    /**
     * Endpoint Viewset
     */
    async racEndpointsUpdate(requestParameters: RacEndpointsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Endpoint> {
        const response = await this.racEndpointsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async racEndpointsUsedByListRaw(requestParameters: RacEndpointsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling racEndpointsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rac/endpoints/{pbm_uuid}/used_by/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async racEndpointsUsedByList(requestParameters: RacEndpointsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.racEndpointsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
