/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  GenericError,
  InstallID,
  License,
  LicenseForecast,
  LicenseRequest,
  LicenseSummary,
  PaginatedLicenseList,
  PatchedLicenseRequest,
  UsedBy,
  ValidationError,
} from '../models';
import {
    GenericErrorFromJSON,
    GenericErrorToJSON,
    InstallIDFromJSON,
    InstallIDToJSON,
    LicenseFromJSON,
    LicenseToJSON,
    LicenseForecastFromJSON,
    LicenseForecastToJSON,
    LicenseRequestFromJSON,
    LicenseRequestToJSON,
    LicenseSummaryFromJSON,
    LicenseSummaryToJSON,
    PaginatedLicenseListFromJSON,
    PaginatedLicenseListToJSON,
    PatchedLicenseRequestFromJSON,
    PatchedLicenseRequestToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface EnterpriseLicenseCreateRequest {
    licenseRequest: LicenseRequest;
}

export interface EnterpriseLicenseDestroyRequest {
    licenseUuid: string;
}

export interface EnterpriseLicenseListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface EnterpriseLicensePartialUpdateRequest {
    licenseUuid: string;
    patchedLicenseRequest?: PatchedLicenseRequest;
}

export interface EnterpriseLicenseRetrieveRequest {
    licenseUuid: string;
}

export interface EnterpriseLicenseUpdateRequest {
    licenseUuid: string;
    licenseRequest: LicenseRequest;
}

export interface EnterpriseLicenseUsedByListRequest {
    licenseUuid: string;
}

/**
 * 
 */
export class EnterpriseApi extends runtime.BaseAPI {

    /**
     * License Viewset
     */
    async enterpriseLicenseCreateRaw(requestParameters: EnterpriseLicenseCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<License>> {
        if (requestParameters.licenseRequest === null || requestParameters.licenseRequest === undefined) {
            throw new runtime.RequiredError('licenseRequest','Required parameter requestParameters.licenseRequest was null or undefined when calling enterpriseLicenseCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LicenseRequestToJSON(requestParameters.licenseRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LicenseFromJSON(jsonValue));
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseCreate(requestParameters: EnterpriseLicenseCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<License> {
        const response = await this.enterpriseLicenseCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseDestroyRaw(requestParameters: EnterpriseLicenseDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
            throw new runtime.RequiredError('licenseUuid','Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseDestroy(requestParameters: EnterpriseLicenseDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.enterpriseLicenseDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Forecast how many users will be required in a year
     */
    async enterpriseLicenseForecastRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LicenseForecast>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/forecast/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LicenseForecastFromJSON(jsonValue));
    }

    /**
     * Forecast how many users will be required in a year
     */
    async enterpriseLicenseForecastRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LicenseForecast> {
        const response = await this.enterpriseLicenseForecastRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get install_id
     */
    async enterpriseLicenseGetInstallIdRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InstallID>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/get_install_id/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => InstallIDFromJSON(jsonValue));
    }

    /**
     * Get install_id
     */
    async enterpriseLicenseGetInstallIdRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InstallID> {
        const response = await this.enterpriseLicenseGetInstallIdRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseListRaw(requestParameters: EnterpriseLicenseListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedLicenseList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedLicenseListFromJSON(jsonValue));
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseList(requestParameters: EnterpriseLicenseListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedLicenseList> {
        const response = await this.enterpriseLicenseListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * License Viewset
     */
    async enterpriseLicensePartialUpdateRaw(requestParameters: EnterpriseLicensePartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<License>> {
        if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
            throw new runtime.RequiredError('licenseUuid','Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicensePartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedLicenseRequestToJSON(requestParameters.patchedLicenseRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LicenseFromJSON(jsonValue));
    }

    /**
     * License Viewset
     */
    async enterpriseLicensePartialUpdate(requestParameters: EnterpriseLicensePartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<License> {
        const response = await this.enterpriseLicensePartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseRetrieveRaw(requestParameters: EnterpriseLicenseRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<License>> {
        if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
            throw new runtime.RequiredError('licenseUuid','Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LicenseFromJSON(jsonValue));
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseRetrieve(requestParameters: EnterpriseLicenseRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<License> {
        const response = await this.enterpriseLicenseRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the total license status
     */
    async enterpriseLicenseSummaryRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LicenseSummary>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/summary/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LicenseSummaryFromJSON(jsonValue));
    }

    /**
     * Get the total license status
     */
    async enterpriseLicenseSummaryRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LicenseSummary> {
        const response = await this.enterpriseLicenseSummaryRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseUpdateRaw(requestParameters: EnterpriseLicenseUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<License>> {
        if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
            throw new runtime.RequiredError('licenseUuid','Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseUpdate.');
        }

        if (requestParameters.licenseRequest === null || requestParameters.licenseRequest === undefined) {
            throw new runtime.RequiredError('licenseRequest','Required parameter requestParameters.licenseRequest was null or undefined when calling enterpriseLicenseUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: LicenseRequestToJSON(requestParameters.licenseRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LicenseFromJSON(jsonValue));
    }

    /**
     * License Viewset
     */
    async enterpriseLicenseUpdate(requestParameters: EnterpriseLicenseUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<License> {
        const response = await this.enterpriseLicenseUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async enterpriseLicenseUsedByListRaw(requestParameters: EnterpriseLicenseUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
            throw new runtime.RequiredError('licenseUuid','Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/enterprise/license/{license_uuid}/used_by/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async enterpriseLicenseUsedByList(requestParameters: EnterpriseLicenseUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.enterpriseLicenseUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
