/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Device,
  DuoDevice,
  DuoDeviceRequest,
  GenericError,
  PaginatedDuoDeviceList,
  PaginatedSMSDeviceList,
  PaginatedStaticDeviceList,
  PaginatedTOTPDeviceList,
  PaginatedWebAuthnDeviceList,
  PatchedDuoDeviceRequest,
  PatchedSMSDeviceRequest,
  PatchedStaticDeviceRequest,
  PatchedTOTPDeviceRequest,
  PatchedWebAuthnDeviceRequest,
  SMSDevice,
  SMSDeviceRequest,
  StaticDevice,
  StaticDeviceRequest,
  TOTPDevice,
  TOTPDeviceRequest,
  UsedBy,
  ValidationError,
  WebAuthnDevice,
  WebAuthnDeviceRequest,
} from '../models';
import {
    DeviceFromJSON,
    DeviceToJSON,
    DuoDeviceFromJSON,
    DuoDeviceToJSON,
    DuoDeviceRequestFromJSON,
    DuoDeviceRequestToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    PaginatedDuoDeviceListFromJSON,
    PaginatedDuoDeviceListToJSON,
    PaginatedSMSDeviceListFromJSON,
    PaginatedSMSDeviceListToJSON,
    PaginatedStaticDeviceListFromJSON,
    PaginatedStaticDeviceListToJSON,
    PaginatedTOTPDeviceListFromJSON,
    PaginatedTOTPDeviceListToJSON,
    PaginatedWebAuthnDeviceListFromJSON,
    PaginatedWebAuthnDeviceListToJSON,
    PatchedDuoDeviceRequestFromJSON,
    PatchedDuoDeviceRequestToJSON,
    PatchedSMSDeviceRequestFromJSON,
    PatchedSMSDeviceRequestToJSON,
    PatchedStaticDeviceRequestFromJSON,
    PatchedStaticDeviceRequestToJSON,
    PatchedTOTPDeviceRequestFromJSON,
    PatchedTOTPDeviceRequestToJSON,
    PatchedWebAuthnDeviceRequestFromJSON,
    PatchedWebAuthnDeviceRequestToJSON,
    SMSDeviceFromJSON,
    SMSDeviceToJSON,
    SMSDeviceRequestFromJSON,
    SMSDeviceRequestToJSON,
    StaticDeviceFromJSON,
    StaticDeviceToJSON,
    StaticDeviceRequestFromJSON,
    StaticDeviceRequestToJSON,
    TOTPDeviceFromJSON,
    TOTPDeviceToJSON,
    TOTPDeviceRequestFromJSON,
    TOTPDeviceRequestToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
    WebAuthnDeviceFromJSON,
    WebAuthnDeviceToJSON,
    WebAuthnDeviceRequestFromJSON,
    WebAuthnDeviceRequestToJSON,
} from '../models';

export interface AuthenticatorsAdminAllListRequest {
    user?: number;
}

export interface AuthenticatorsAdminDuoCreateRequest {
    duoDeviceRequest: DuoDeviceRequest;
}

export interface AuthenticatorsAdminDuoDestroyRequest {
    id: number;
}

export interface AuthenticatorsAdminDuoListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsAdminDuoPartialUpdateRequest {
    id: number;
    patchedDuoDeviceRequest?: PatchedDuoDeviceRequest;
}

export interface AuthenticatorsAdminDuoRetrieveRequest {
    id: number;
}

export interface AuthenticatorsAdminDuoUpdateRequest {
    id: number;
    duoDeviceRequest: DuoDeviceRequest;
}

export interface AuthenticatorsAdminSmsCreateRequest {
    sMSDeviceRequest: SMSDeviceRequest;
}

export interface AuthenticatorsAdminSmsDestroyRequest {
    id: number;
}

export interface AuthenticatorsAdminSmsListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsAdminSmsPartialUpdateRequest {
    id: number;
    patchedSMSDeviceRequest?: PatchedSMSDeviceRequest;
}

export interface AuthenticatorsAdminSmsRetrieveRequest {
    id: number;
}

export interface AuthenticatorsAdminSmsUpdateRequest {
    id: number;
    sMSDeviceRequest: SMSDeviceRequest;
}

export interface AuthenticatorsAdminStaticCreateRequest {
    staticDeviceRequest: StaticDeviceRequest;
}

export interface AuthenticatorsAdminStaticDestroyRequest {
    id: number;
}

export interface AuthenticatorsAdminStaticListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsAdminStaticPartialUpdateRequest {
    id: number;
    patchedStaticDeviceRequest?: PatchedStaticDeviceRequest;
}

export interface AuthenticatorsAdminStaticRetrieveRequest {
    id: number;
}

export interface AuthenticatorsAdminStaticUpdateRequest {
    id: number;
    staticDeviceRequest: StaticDeviceRequest;
}

export interface AuthenticatorsAdminTotpCreateRequest {
    tOTPDeviceRequest: TOTPDeviceRequest;
}

export interface AuthenticatorsAdminTotpDestroyRequest {
    id: number;
}

export interface AuthenticatorsAdminTotpListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsAdminTotpPartialUpdateRequest {
    id: number;
    patchedTOTPDeviceRequest?: PatchedTOTPDeviceRequest;
}

export interface AuthenticatorsAdminTotpRetrieveRequest {
    id: number;
}

export interface AuthenticatorsAdminTotpUpdateRequest {
    id: number;
    tOTPDeviceRequest: TOTPDeviceRequest;
}

export interface AuthenticatorsAdminWebauthnCreateRequest {
    webAuthnDeviceRequest: WebAuthnDeviceRequest;
}

export interface AuthenticatorsAdminWebauthnDestroyRequest {
    id: number;
}

export interface AuthenticatorsAdminWebauthnListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsAdminWebauthnPartialUpdateRequest {
    id: number;
    patchedWebAuthnDeviceRequest?: PatchedWebAuthnDeviceRequest;
}

export interface AuthenticatorsAdminWebauthnRetrieveRequest {
    id: number;
}

export interface AuthenticatorsAdminWebauthnUpdateRequest {
    id: number;
    webAuthnDeviceRequest: WebAuthnDeviceRequest;
}

export interface AuthenticatorsDuoDestroyRequest {
    id: number;
}

export interface AuthenticatorsDuoListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsDuoPartialUpdateRequest {
    id: number;
    patchedDuoDeviceRequest?: PatchedDuoDeviceRequest;
}

export interface AuthenticatorsDuoRetrieveRequest {
    id: number;
}

export interface AuthenticatorsDuoUpdateRequest {
    id: number;
    duoDeviceRequest: DuoDeviceRequest;
}

export interface AuthenticatorsDuoUsedByListRequest {
    id: number;
}

export interface AuthenticatorsSmsDestroyRequest {
    id: number;
}

export interface AuthenticatorsSmsListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsSmsPartialUpdateRequest {
    id: number;
    patchedSMSDeviceRequest?: PatchedSMSDeviceRequest;
}

export interface AuthenticatorsSmsRetrieveRequest {
    id: number;
}

export interface AuthenticatorsSmsUpdateRequest {
    id: number;
    sMSDeviceRequest: SMSDeviceRequest;
}

export interface AuthenticatorsSmsUsedByListRequest {
    id: number;
}

export interface AuthenticatorsStaticDestroyRequest {
    id: number;
}

export interface AuthenticatorsStaticListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsStaticPartialUpdateRequest {
    id: number;
    patchedStaticDeviceRequest?: PatchedStaticDeviceRequest;
}

export interface AuthenticatorsStaticRetrieveRequest {
    id: number;
}

export interface AuthenticatorsStaticUpdateRequest {
    id: number;
    staticDeviceRequest: StaticDeviceRequest;
}

export interface AuthenticatorsStaticUsedByListRequest {
    id: number;
}

export interface AuthenticatorsTotpDestroyRequest {
    id: number;
}

export interface AuthenticatorsTotpListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsTotpPartialUpdateRequest {
    id: number;
    patchedTOTPDeviceRequest?: PatchedTOTPDeviceRequest;
}

export interface AuthenticatorsTotpRetrieveRequest {
    id: number;
}

export interface AuthenticatorsTotpUpdateRequest {
    id: number;
    tOTPDeviceRequest: TOTPDeviceRequest;
}

export interface AuthenticatorsTotpUsedByListRequest {
    id: number;
}

export interface AuthenticatorsWebauthnDestroyRequest {
    id: number;
}

export interface AuthenticatorsWebauthnListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface AuthenticatorsWebauthnPartialUpdateRequest {
    id: number;
    patchedWebAuthnDeviceRequest?: PatchedWebAuthnDeviceRequest;
}

export interface AuthenticatorsWebauthnRetrieveRequest {
    id: number;
}

export interface AuthenticatorsWebauthnUpdateRequest {
    id: number;
    webAuthnDeviceRequest: WebAuthnDeviceRequest;
}

export interface AuthenticatorsWebauthnUsedByListRequest {
    id: number;
}

/**
 * 
 */
export class AuthenticatorsApi extends runtime.BaseAPI {

    /**
     * Get all devices for current user
     */
    async authenticatorsAdminAllListRaw(requestParameters: AuthenticatorsAdminAllListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Device>>> {
        const queryParameters: any = {};

        if (requestParameters.user !== undefined) {
            queryParameters['user'] = requestParameters.user;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/all/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(DeviceFromJSON));
    }

    /**
     * Get all devices for current user
     */
    async authenticatorsAdminAllList(requestParameters: AuthenticatorsAdminAllListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Device>> {
        const response = await this.authenticatorsAdminAllListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoCreateRaw(requestParameters: AuthenticatorsAdminDuoCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.duoDeviceRequest === null || requestParameters.duoDeviceRequest === undefined) {
            throw new runtime.RequiredError('duoDeviceRequest','Required parameter requestParameters.duoDeviceRequest was null or undefined when calling authenticatorsAdminDuoCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/duo/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: DuoDeviceRequestToJSON(requestParameters.duoDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoCreate(requestParameters: AuthenticatorsAdminDuoCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsAdminDuoCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoDestroyRaw(requestParameters: AuthenticatorsAdminDuoDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoDestroy(requestParameters: AuthenticatorsAdminDuoDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsAdminDuoDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoListRaw(requestParameters: AuthenticatorsAdminDuoListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedDuoDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/duo/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedDuoDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoList(requestParameters: AuthenticatorsAdminDuoListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedDuoDeviceList> {
        const response = await this.authenticatorsAdminDuoListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoPartialUpdateRaw(requestParameters: AuthenticatorsAdminDuoPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedDuoDeviceRequestToJSON(requestParameters.patchedDuoDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoPartialUpdate(requestParameters: AuthenticatorsAdminDuoPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsAdminDuoPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoRetrieveRaw(requestParameters: AuthenticatorsAdminDuoRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoRetrieve(requestParameters: AuthenticatorsAdminDuoRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsAdminDuoRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoUpdateRaw(requestParameters: AuthenticatorsAdminDuoUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoUpdate.');
        }

        if (requestParameters.duoDeviceRequest === null || requestParameters.duoDeviceRequest === undefined) {
            throw new runtime.RequiredError('duoDeviceRequest','Required parameter requestParameters.duoDeviceRequest was null or undefined when calling authenticatorsAdminDuoUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: DuoDeviceRequestToJSON(requestParameters.duoDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    async authenticatorsAdminDuoUpdate(requestParameters: AuthenticatorsAdminDuoUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsAdminDuoUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsCreateRaw(requestParameters: AuthenticatorsAdminSmsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.sMSDeviceRequest === null || requestParameters.sMSDeviceRequest === undefined) {
            throw new runtime.RequiredError('sMSDeviceRequest','Required parameter requestParameters.sMSDeviceRequest was null or undefined when calling authenticatorsAdminSmsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/sms/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: SMSDeviceRequestToJSON(requestParameters.sMSDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsCreate(requestParameters: AuthenticatorsAdminSmsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsAdminSmsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsDestroyRaw(requestParameters: AuthenticatorsAdminSmsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsDestroy(requestParameters: AuthenticatorsAdminSmsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsAdminSmsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsListRaw(requestParameters: AuthenticatorsAdminSmsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSMSDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/sms/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedSMSDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsList(requestParameters: AuthenticatorsAdminSmsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSMSDeviceList> {
        const response = await this.authenticatorsAdminSmsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsPartialUpdateRaw(requestParameters: AuthenticatorsAdminSmsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedSMSDeviceRequestToJSON(requestParameters.patchedSMSDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsPartialUpdate(requestParameters: AuthenticatorsAdminSmsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsAdminSmsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsRetrieveRaw(requestParameters: AuthenticatorsAdminSmsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsRetrieve(requestParameters: AuthenticatorsAdminSmsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsAdminSmsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsUpdateRaw(requestParameters: AuthenticatorsAdminSmsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsUpdate.');
        }

        if (requestParameters.sMSDeviceRequest === null || requestParameters.sMSDeviceRequest === undefined) {
            throw new runtime.RequiredError('sMSDeviceRequest','Required parameter requestParameters.sMSDeviceRequest was null or undefined when calling authenticatorsAdminSmsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: SMSDeviceRequestToJSON(requestParameters.sMSDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices (for admins)
     */
    async authenticatorsAdminSmsUpdate(requestParameters: AuthenticatorsAdminSmsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsAdminSmsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticCreateRaw(requestParameters: AuthenticatorsAdminStaticCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.staticDeviceRequest === null || requestParameters.staticDeviceRequest === undefined) {
            throw new runtime.RequiredError('staticDeviceRequest','Required parameter requestParameters.staticDeviceRequest was null or undefined when calling authenticatorsAdminStaticCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/static/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: StaticDeviceRequestToJSON(requestParameters.staticDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticCreate(requestParameters: AuthenticatorsAdminStaticCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsAdminStaticCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticDestroyRaw(requestParameters: AuthenticatorsAdminStaticDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticDestroy(requestParameters: AuthenticatorsAdminStaticDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsAdminStaticDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticListRaw(requestParameters: AuthenticatorsAdminStaticListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedStaticDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/static/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedStaticDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticList(requestParameters: AuthenticatorsAdminStaticListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedStaticDeviceList> {
        const response = await this.authenticatorsAdminStaticListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticPartialUpdateRaw(requestParameters: AuthenticatorsAdminStaticPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedStaticDeviceRequestToJSON(requestParameters.patchedStaticDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticPartialUpdate(requestParameters: AuthenticatorsAdminStaticPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsAdminStaticPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticRetrieveRaw(requestParameters: AuthenticatorsAdminStaticRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticRetrieve(requestParameters: AuthenticatorsAdminStaticRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsAdminStaticRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticUpdateRaw(requestParameters: AuthenticatorsAdminStaticUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticUpdate.');
        }

        if (requestParameters.staticDeviceRequest === null || requestParameters.staticDeviceRequest === undefined) {
            throw new runtime.RequiredError('staticDeviceRequest','Required parameter requestParameters.staticDeviceRequest was null or undefined when calling authenticatorsAdminStaticUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: StaticDeviceRequestToJSON(requestParameters.staticDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices (for admins)
     */
    async authenticatorsAdminStaticUpdate(requestParameters: AuthenticatorsAdminStaticUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsAdminStaticUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpCreateRaw(requestParameters: AuthenticatorsAdminTotpCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.tOTPDeviceRequest === null || requestParameters.tOTPDeviceRequest === undefined) {
            throw new runtime.RequiredError('tOTPDeviceRequest','Required parameter requestParameters.tOTPDeviceRequest was null or undefined when calling authenticatorsAdminTotpCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/totp/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: TOTPDeviceRequestToJSON(requestParameters.tOTPDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpCreate(requestParameters: AuthenticatorsAdminTotpCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsAdminTotpCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpDestroyRaw(requestParameters: AuthenticatorsAdminTotpDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpDestroy(requestParameters: AuthenticatorsAdminTotpDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsAdminTotpDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpListRaw(requestParameters: AuthenticatorsAdminTotpListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedTOTPDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/totp/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedTOTPDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpList(requestParameters: AuthenticatorsAdminTotpListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedTOTPDeviceList> {
        const response = await this.authenticatorsAdminTotpListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpPartialUpdateRaw(requestParameters: AuthenticatorsAdminTotpPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedTOTPDeviceRequestToJSON(requestParameters.patchedTOTPDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpPartialUpdate(requestParameters: AuthenticatorsAdminTotpPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsAdminTotpPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpRetrieveRaw(requestParameters: AuthenticatorsAdminTotpRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpRetrieve(requestParameters: AuthenticatorsAdminTotpRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsAdminTotpRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpUpdateRaw(requestParameters: AuthenticatorsAdminTotpUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpUpdate.');
        }

        if (requestParameters.tOTPDeviceRequest === null || requestParameters.tOTPDeviceRequest === undefined) {
            throw new runtime.RequiredError('tOTPDeviceRequest','Required parameter requestParameters.tOTPDeviceRequest was null or undefined when calling authenticatorsAdminTotpUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: TOTPDeviceRequestToJSON(requestParameters.tOTPDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices (for admins)
     */
    async authenticatorsAdminTotpUpdate(requestParameters: AuthenticatorsAdminTotpUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsAdminTotpUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnCreateRaw(requestParameters: AuthenticatorsAdminWebauthnCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.webAuthnDeviceRequest === null || requestParameters.webAuthnDeviceRequest === undefined) {
            throw new runtime.RequiredError('webAuthnDeviceRequest','Required parameter requestParameters.webAuthnDeviceRequest was null or undefined when calling authenticatorsAdminWebauthnCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/webauthn/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: WebAuthnDeviceRequestToJSON(requestParameters.webAuthnDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnCreate(requestParameters: AuthenticatorsAdminWebauthnCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsAdminWebauthnCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnDestroyRaw(requestParameters: AuthenticatorsAdminWebauthnDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnDestroy(requestParameters: AuthenticatorsAdminWebauthnDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsAdminWebauthnDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnListRaw(requestParameters: AuthenticatorsAdminWebauthnListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedWebAuthnDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/webauthn/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedWebAuthnDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnList(requestParameters: AuthenticatorsAdminWebauthnListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedWebAuthnDeviceList> {
        const response = await this.authenticatorsAdminWebauthnListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnPartialUpdateRaw(requestParameters: AuthenticatorsAdminWebauthnPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedWebAuthnDeviceRequestToJSON(requestParameters.patchedWebAuthnDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnPartialUpdate(requestParameters: AuthenticatorsAdminWebauthnPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsAdminWebauthnPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnRetrieveRaw(requestParameters: AuthenticatorsAdminWebauthnRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnRetrieve(requestParameters: AuthenticatorsAdminWebauthnRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsAdminWebauthnRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnUpdateRaw(requestParameters: AuthenticatorsAdminWebauthnUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnUpdate.');
        }

        if (requestParameters.webAuthnDeviceRequest === null || requestParameters.webAuthnDeviceRequest === undefined) {
            throw new runtime.RequiredError('webAuthnDeviceRequest','Required parameter requestParameters.webAuthnDeviceRequest was null or undefined when calling authenticatorsAdminWebauthnUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: WebAuthnDeviceRequestToJSON(requestParameters.webAuthnDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    async authenticatorsAdminWebauthnUpdate(requestParameters: AuthenticatorsAdminWebauthnUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsAdminWebauthnUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get all devices for current user
     */
    async authenticatorsAllListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Device>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/all/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(DeviceFromJSON));
    }

    /**
     * Get all devices for current user
     */
    async authenticatorsAllList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Device>> {
        const response = await this.authenticatorsAllListRaw(initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoDestroyRaw(requestParameters: AuthenticatorsDuoDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoDestroy(requestParameters: AuthenticatorsDuoDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsDuoDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoListRaw(requestParameters: AuthenticatorsDuoListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedDuoDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/duo/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedDuoDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoList(requestParameters: AuthenticatorsDuoListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedDuoDeviceList> {
        const response = await this.authenticatorsDuoListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoPartialUpdateRaw(requestParameters: AuthenticatorsDuoPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedDuoDeviceRequestToJSON(requestParameters.patchedDuoDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoPartialUpdate(requestParameters: AuthenticatorsDuoPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsDuoPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoRetrieveRaw(requestParameters: AuthenticatorsDuoRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoRetrieve(requestParameters: AuthenticatorsDuoRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsDuoRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoUpdateRaw(requestParameters: AuthenticatorsDuoUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DuoDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoUpdate.');
        }

        if (requestParameters.duoDeviceRequest === null || requestParameters.duoDeviceRequest === undefined) {
            throw new runtime.RequiredError('duoDeviceRequest','Required parameter requestParameters.duoDeviceRequest was null or undefined when calling authenticatorsDuoUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: DuoDeviceRequestToJSON(requestParameters.duoDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DuoDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for Duo authenticator devices
     */
    async authenticatorsDuoUpdate(requestParameters: AuthenticatorsDuoUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DuoDevice> {
        const response = await this.authenticatorsDuoUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsDuoUsedByListRaw(requestParameters: AuthenticatorsDuoUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/duo/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsDuoUsedByList(requestParameters: AuthenticatorsDuoUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.authenticatorsDuoUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsDestroyRaw(requestParameters: AuthenticatorsSmsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsDestroy(requestParameters: AuthenticatorsSmsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsSmsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsListRaw(requestParameters: AuthenticatorsSmsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSMSDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/sms/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedSMSDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsList(requestParameters: AuthenticatorsSmsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSMSDeviceList> {
        const response = await this.authenticatorsSmsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsPartialUpdateRaw(requestParameters: AuthenticatorsSmsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedSMSDeviceRequestToJSON(requestParameters.patchedSMSDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsPartialUpdate(requestParameters: AuthenticatorsSmsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsSmsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsRetrieveRaw(requestParameters: AuthenticatorsSmsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsRetrieve(requestParameters: AuthenticatorsSmsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsSmsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsUpdateRaw(requestParameters: AuthenticatorsSmsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SMSDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsUpdate.');
        }

        if (requestParameters.sMSDeviceRequest === null || requestParameters.sMSDeviceRequest === undefined) {
            throw new runtime.RequiredError('sMSDeviceRequest','Required parameter requestParameters.sMSDeviceRequest was null or undefined when calling authenticatorsSmsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: SMSDeviceRequestToJSON(requestParameters.sMSDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SMSDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for sms authenticator devices
     */
    async authenticatorsSmsUpdate(requestParameters: AuthenticatorsSmsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SMSDevice> {
        const response = await this.authenticatorsSmsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsSmsUsedByListRaw(requestParameters: AuthenticatorsSmsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/sms/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsSmsUsedByList(requestParameters: AuthenticatorsSmsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.authenticatorsSmsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticDestroyRaw(requestParameters: AuthenticatorsStaticDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticDestroy(requestParameters: AuthenticatorsStaticDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsStaticDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticListRaw(requestParameters: AuthenticatorsStaticListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedStaticDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/static/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedStaticDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticList(requestParameters: AuthenticatorsStaticListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedStaticDeviceList> {
        const response = await this.authenticatorsStaticListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticPartialUpdateRaw(requestParameters: AuthenticatorsStaticPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedStaticDeviceRequestToJSON(requestParameters.patchedStaticDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticPartialUpdate(requestParameters: AuthenticatorsStaticPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsStaticPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticRetrieveRaw(requestParameters: AuthenticatorsStaticRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticRetrieve(requestParameters: AuthenticatorsStaticRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsStaticRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticUpdateRaw(requestParameters: AuthenticatorsStaticUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StaticDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticUpdate.');
        }

        if (requestParameters.staticDeviceRequest === null || requestParameters.staticDeviceRequest === undefined) {
            throw new runtime.RequiredError('staticDeviceRequest','Required parameter requestParameters.staticDeviceRequest was null or undefined when calling authenticatorsStaticUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: StaticDeviceRequestToJSON(requestParameters.staticDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StaticDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for static authenticator devices
     */
    async authenticatorsStaticUpdate(requestParameters: AuthenticatorsStaticUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StaticDevice> {
        const response = await this.authenticatorsStaticUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsStaticUsedByListRaw(requestParameters: AuthenticatorsStaticUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/static/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsStaticUsedByList(requestParameters: AuthenticatorsStaticUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.authenticatorsStaticUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpDestroyRaw(requestParameters: AuthenticatorsTotpDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpDestroy(requestParameters: AuthenticatorsTotpDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsTotpDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpListRaw(requestParameters: AuthenticatorsTotpListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedTOTPDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/totp/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedTOTPDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpList(requestParameters: AuthenticatorsTotpListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedTOTPDeviceList> {
        const response = await this.authenticatorsTotpListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpPartialUpdateRaw(requestParameters: AuthenticatorsTotpPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedTOTPDeviceRequestToJSON(requestParameters.patchedTOTPDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpPartialUpdate(requestParameters: AuthenticatorsTotpPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsTotpPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpRetrieveRaw(requestParameters: AuthenticatorsTotpRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpRetrieve(requestParameters: AuthenticatorsTotpRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsTotpRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpUpdateRaw(requestParameters: AuthenticatorsTotpUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TOTPDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpUpdate.');
        }

        if (requestParameters.tOTPDeviceRequest === null || requestParameters.tOTPDeviceRequest === undefined) {
            throw new runtime.RequiredError('tOTPDeviceRequest','Required parameter requestParameters.tOTPDeviceRequest was null or undefined when calling authenticatorsTotpUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: TOTPDeviceRequestToJSON(requestParameters.tOTPDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TOTPDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for totp authenticator devices
     */
    async authenticatorsTotpUpdate(requestParameters: AuthenticatorsTotpUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TOTPDevice> {
        const response = await this.authenticatorsTotpUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsTotpUsedByListRaw(requestParameters: AuthenticatorsTotpUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/totp/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsTotpUsedByList(requestParameters: AuthenticatorsTotpUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.authenticatorsTotpUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnDestroyRaw(requestParameters: AuthenticatorsWebauthnDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnDestroy(requestParameters: AuthenticatorsWebauthnDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.authenticatorsWebauthnDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnListRaw(requestParameters: AuthenticatorsWebauthnListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedWebAuthnDeviceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/webauthn/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedWebAuthnDeviceListFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnList(requestParameters: AuthenticatorsWebauthnListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedWebAuthnDeviceList> {
        const response = await this.authenticatorsWebauthnListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnPartialUpdateRaw(requestParameters: AuthenticatorsWebauthnPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedWebAuthnDeviceRequestToJSON(requestParameters.patchedWebAuthnDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnPartialUpdate(requestParameters: AuthenticatorsWebauthnPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsWebauthnPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnRetrieveRaw(requestParameters: AuthenticatorsWebauthnRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnRetrieve(requestParameters: AuthenticatorsWebauthnRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsWebauthnRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnUpdateRaw(requestParameters: AuthenticatorsWebauthnUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WebAuthnDevice>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnUpdate.');
        }

        if (requestParameters.webAuthnDeviceRequest === null || requestParameters.webAuthnDeviceRequest === undefined) {
            throw new runtime.RequiredError('webAuthnDeviceRequest','Required parameter requestParameters.webAuthnDeviceRequest was null or undefined when calling authenticatorsWebauthnUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: WebAuthnDeviceRequestToJSON(requestParameters.webAuthnDeviceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => WebAuthnDeviceFromJSON(jsonValue));
    }

    /**
     * Viewset for WebAuthn authenticator devices
     */
    async authenticatorsWebauthnUpdate(requestParameters: AuthenticatorsWebauthnUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WebAuthnDevice> {
        const response = await this.authenticatorsWebauthnUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsWebauthnUsedByListRaw(requestParameters: AuthenticatorsWebauthnUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/authenticators/webauthn/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async authenticatorsWebauthnUsedByList(requestParameters: AuthenticatorsWebauthnUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.authenticatorsWebauthnUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
