/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import type { SpBindingEnum } from './SpBindingEnum';
/**
 * SAMLProvider Serializer
 * @export
 * @interface SAMLProviderRequest
 */
export interface SAMLProviderRequest {
    /**
     *
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    authorizationFlow: string;
    /**
     *
     * @type {Array<string>}
     * @memberof SAMLProviderRequest
     */
    propertyMappings?: Array<string>;
    /**
     *
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    acsUrl: string;
    /**
     * Value of the audience restriction field of the assertion. When left empty, no audience restriction will be added.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    audience?: string;
    /**
     * Also known as EntityID
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    issuer?: string;
    /**
     * Assertion valid not before current time + this value (Format: hours=-1;minutes=-2;seconds=-3).
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    assertionValidNotBefore?: string;
    /**
     * Assertion not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    assertionValidNotOnOrAfter?: string;
    /**
     * Session not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    sessionValidNotOnOrAfter?: string;
    /**
     * Configure how the NameID value will be created. When left empty, the NameIDPolicy of the incoming request will be considered
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    nameIdMapping?: string | null;
    /**
     *
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLProviderRequest
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     *
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLProviderRequest
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Keypair used to sign outgoing Responses going to the Service Provider.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    signingKp?: string | null;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    verificationKp?: string | null;
    /**
     *
     * @type {SpBindingEnum}
     * @memberof SAMLProviderRequest
     */
    spBinding?: SpBindingEnum;
    /**
     * Default relay_state value for IDP-initiated logins
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    defaultRelayState?: string;
}
/**
 * Check if a given object implements the SAMLProviderRequest interface.
 */
export declare function instanceOfSAMLProviderRequest(value: object): boolean;
export declare function SAMLProviderRequestFromJSON(json: any): SAMLProviderRequest;
export declare function SAMLProviderRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLProviderRequest;
export declare function SAMLProviderRequestToJSON(value?: SAMLProviderRequest | null): any;
