"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourcesSamlListUserMatchingModeEnum = exports.SourcesSamlListSignatureAlgorithmEnum = exports.SourcesSamlListPolicyEngineModeEnum = exports.SourcesSamlListNameIdPolicyEnum = exports.SourcesSamlListDigestAlgorithmEnum = exports.SourcesSamlListBindingTypeEnum = exports.SourcesPlexListUserMatchingModeEnum = exports.SourcesPlexListPolicyEngineModeEnum = exports.SourcesOauthListUserMatchingModeEnum = exports.SourcesOauthListPolicyEngineModeEnum = exports.SourcesApi = void 0;
const runtime = require("../runtime");
const models_1 = require("../models");
/**
 *
 */
class SourcesApi extends runtime.BaseAPI {
    /**
     * Source Viewset
     */
    sourcesAllDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesAllDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Source Viewset
     */
    sourcesAllDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesAllDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Source Viewset
     */
    sourcesAllListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.managed !== undefined) {
                queryParameters['managed'] = requestParameters.managed;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSourceListFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesAllList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesAllListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesAllRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesAllRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SourceFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesAllRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesAllRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Set source icon
     */
    sourcesAllSetIconCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesAllSetIconCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const consumes = [
                { contentType: 'multipart/form-data' },
            ];
            // @ts-ignore: canConsumeForm may be unused
            const canConsumeForm = runtime.canConsumeForm(consumes);
            let formParams;
            let useForm = false;
            // use FormData to transmit files using content-type "multipart/form-data"
            useForm = canConsumeForm;
            if (useForm) {
                formParams = new FormData();
            }
            else {
                formParams = new URLSearchParams();
            }
            if (requestParameters.file !== undefined) {
                formParams.append('file', requestParameters.file);
            }
            if (requestParameters.clear !== undefined) {
                formParams.append('clear', requestParameters.clear);
            }
            const response = yield this.request({
                path: `/sources/all/{slug}/set_icon/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: formParams,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Set source icon
     */
    sourcesAllSetIconCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesAllSetIconCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Set source icon (as URL)
     */
    sourcesAllSetIconUrlCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesAllSetIconUrlCreate.');
            }
            if (requestParameters.filePathRequest === null || requestParameters.filePathRequest === undefined) {
                throw new runtime.RequiredError('filePathRequest', 'Required parameter requestParameters.filePathRequest was null or undefined when calling sourcesAllSetIconUrlCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/{slug}/set_icon_url/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.FilePathRequestToJSON)(requestParameters.filePathRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Set source icon (as URL)
     */
    sourcesAllSetIconUrlCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesAllSetIconUrlCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Get all creatable types
     */
    sourcesAllTypesListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/types/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.TypeCreateFromJSON));
        });
    }
    /**
     * Get all creatable types
     */
    sourcesAllTypesList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesAllTypesListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesAllUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesAllUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesAllUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesAllUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all sources the user can configure
     */
    sourcesAllUserSettingsListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/all/user_settings/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UserSettingFromJSON));
        });
    }
    /**
     * Get all sources the user can configure
     */
    sourcesAllUserSettingsList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesAllUserSettingsListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.lDAPSourceRequest === null || requestParameters.lDAPSourceRequest === undefined) {
                throw new runtime.RequiredError('lDAPSourceRequest', 'Required parameter requestParameters.lDAPSourceRequest was null or undefined when calling sourcesLdapCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.LDAPSourceRequestToJSON)(requestParameters.lDAPSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LDAPSourceFromJSON)(jsonValue));
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get raw LDAP data to debug
     */
    sourcesLdapDebugRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapDebugRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/debug/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LDAPDebugFromJSON)(jsonValue));
        });
    }
    /**
     * Get raw LDAP data to debug
     */
    sourcesLdapDebugRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapDebugRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesLdapDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.additionalGroupDn !== undefined) {
                queryParameters['additional_group_dn'] = requestParameters.additionalGroupDn;
            }
            if (requestParameters.additionalUserDn !== undefined) {
                queryParameters['additional_user_dn'] = requestParameters.additionalUserDn;
            }
            if (requestParameters.baseDn !== undefined) {
                queryParameters['base_dn'] = requestParameters.baseDn;
            }
            if (requestParameters.bindCn !== undefined) {
                queryParameters['bind_cn'] = requestParameters.bindCn;
            }
            if (requestParameters.clientCertificate !== undefined) {
                queryParameters['client_certificate'] = requestParameters.clientCertificate;
            }
            if (requestParameters.enabled !== undefined) {
                queryParameters['enabled'] = requestParameters.enabled;
            }
            if (requestParameters.groupMembershipField !== undefined) {
                queryParameters['group_membership_field'] = requestParameters.groupMembershipField;
            }
            if (requestParameters.groupObjectFilter !== undefined) {
                queryParameters['group_object_filter'] = requestParameters.groupObjectFilter;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.objectUniquenessField !== undefined) {
                queryParameters['object_uniqueness_field'] = requestParameters.objectUniquenessField;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.passwordLoginUpdateInternalPassword !== undefined) {
                queryParameters['password_login_update_internal_password'] = requestParameters.passwordLoginUpdateInternalPassword;
            }
            if (requestParameters.peerCertificate !== undefined) {
                queryParameters['peer_certificate'] = requestParameters.peerCertificate;
            }
            if (requestParameters.propertyMappings) {
                queryParameters['property_mappings'] = requestParameters.propertyMappings;
            }
            if (requestParameters.propertyMappingsGroup) {
                queryParameters['property_mappings_group'] = requestParameters.propertyMappingsGroup;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.serverUri !== undefined) {
                queryParameters['server_uri'] = requestParameters.serverUri;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            if (requestParameters.sni !== undefined) {
                queryParameters['sni'] = requestParameters.sni;
            }
            if (requestParameters.startTls !== undefined) {
                queryParameters['start_tls'] = requestParameters.startTls;
            }
            if (requestParameters.syncGroups !== undefined) {
                queryParameters['sync_groups'] = requestParameters.syncGroups;
            }
            if (requestParameters.syncParentGroup !== undefined) {
                queryParameters['sync_parent_group'] = requestParameters.syncParentGroup;
            }
            if (requestParameters.syncUsers !== undefined) {
                queryParameters['sync_users'] = requestParameters.syncUsers;
            }
            if (requestParameters.syncUsersPassword !== undefined) {
                queryParameters['sync_users_password'] = requestParameters.syncUsersPassword;
            }
            if (requestParameters.userObjectFilter !== undefined) {
                queryParameters['user_object_filter'] = requestParameters.userObjectFilter;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedLDAPSourceListFromJSON)(jsonValue));
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedLDAPSourceRequestToJSON)(requestParameters.patchedLDAPSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LDAPSourceFromJSON)(jsonValue));
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LDAPSourceFromJSON)(jsonValue));
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get source\'s sync status
     */
    sourcesLdapSyncStatusRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapSyncStatusRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/sync/status/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SyncStatusFromJSON)(jsonValue));
        });
    }
    /**
     * Get source\'s sync status
     */
    sourcesLdapSyncStatusRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapSyncStatusRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapUpdate.');
            }
            if (requestParameters.lDAPSourceRequest === null || requestParameters.lDAPSourceRequest === undefined) {
                throw new runtime.RequiredError('lDAPSourceRequest', 'Required parameter requestParameters.lDAPSourceRequest was null or undefined when calling sourcesLdapUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.LDAPSourceRequestToJSON)(requestParameters.lDAPSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LDAPSourceFromJSON)(jsonValue));
        });
    }
    /**
     * LDAP Source Viewset
     */
    sourcesLdapUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesLdapUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesLdapUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/ldap/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesLdapUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesLdapUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.oAuthSourceRequest === null || requestParameters.oAuthSourceRequest === undefined) {
                throw new runtime.RequiredError('oAuthSourceRequest', 'Required parameter requestParameters.oAuthSourceRequest was null or undefined when calling sourcesOauthCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.OAuthSourceRequestToJSON)(requestParameters.oAuthSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.OAuthSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesOauthDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesOauthDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.accessTokenUrl !== undefined) {
                queryParameters['access_token_url'] = requestParameters.accessTokenUrl;
            }
            if (requestParameters.additionalScopes !== undefined) {
                queryParameters['additional_scopes'] = requestParameters.additionalScopes;
            }
            if (requestParameters.authenticationFlow !== undefined) {
                queryParameters['authentication_flow'] = requestParameters.authenticationFlow;
            }
            if (requestParameters.authorizationUrl !== undefined) {
                queryParameters['authorization_url'] = requestParameters.authorizationUrl;
            }
            if (requestParameters.consumerKey !== undefined) {
                queryParameters['consumer_key'] = requestParameters.consumerKey;
            }
            if (requestParameters.enabled !== undefined) {
                queryParameters['enabled'] = requestParameters.enabled;
            }
            if (requestParameters.enrollmentFlow !== undefined) {
                queryParameters['enrollment_flow'] = requestParameters.enrollmentFlow;
            }
            if (requestParameters.hasJwks !== undefined) {
                queryParameters['has_jwks'] = requestParameters.hasJwks;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyEngineMode !== undefined) {
                queryParameters['policy_engine_mode'] = requestParameters.policyEngineMode;
            }
            if (requestParameters.profileUrl !== undefined) {
                queryParameters['profile_url'] = requestParameters.profileUrl;
            }
            if (requestParameters.providerType !== undefined) {
                queryParameters['provider_type'] = requestParameters.providerType;
            }
            if (requestParameters.requestTokenUrl !== undefined) {
                queryParameters['request_token_url'] = requestParameters.requestTokenUrl;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            if (requestParameters.userMatchingMode !== undefined) {
                queryParameters['user_matching_mode'] = requestParameters.userMatchingMode;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedOAuthSourceListFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesOauthPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedOAuthSourceRequestToJSON)(requestParameters.patchedOAuthSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.OAuthSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesOauthRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.OAuthSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all creatable source types. If ?name is set, only returns the type for <name>. If <name> isn\'t found, returns the default type.
     */
    sourcesOauthSourceTypesListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/source_types/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.SourceTypeFromJSON));
        });
    }
    /**
     * Get all creatable source types. If ?name is set, only returns the type for <name>. If <name> isn\'t found, returns the default type.
     */
    sourcesOauthSourceTypesList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthSourceTypesListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesOauthUpdate.');
            }
            if (requestParameters.oAuthSourceRequest === null || requestParameters.oAuthSourceRequest === undefined) {
                throw new runtime.RequiredError('oAuthSourceRequest', 'Required parameter requestParameters.oAuthSourceRequest was null or undefined when calling sourcesOauthUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.OAuthSourceRequestToJSON)(requestParameters.oAuthSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.OAuthSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesOauthUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesOauthUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesOauthUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/oauth/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesOauthUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesOauthUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.plexSourceRequest === null || requestParameters.plexSourceRequest === undefined) {
                throw new runtime.RequiredError('plexSourceRequest', 'Required parameter requestParameters.plexSourceRequest was null or undefined when calling sourcesPlexCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PlexSourceRequestToJSON)(requestParameters.plexSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesPlexDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesPlexDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.allowFriends !== undefined) {
                queryParameters['allow_friends'] = requestParameters.allowFriends;
            }
            if (requestParameters.authenticationFlow !== undefined) {
                queryParameters['authentication_flow'] = requestParameters.authenticationFlow;
            }
            if (requestParameters.clientId !== undefined) {
                queryParameters['client_id'] = requestParameters.clientId;
            }
            if (requestParameters.enabled !== undefined) {
                queryParameters['enabled'] = requestParameters.enabled;
            }
            if (requestParameters.enrollmentFlow !== undefined) {
                queryParameters['enrollment_flow'] = requestParameters.enrollmentFlow;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyEngineMode !== undefined) {
                queryParameters['policy_engine_mode'] = requestParameters.policyEngineMode;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            if (requestParameters.userMatchingMode !== undefined) {
                queryParameters['user_matching_mode'] = requestParameters.userMatchingMode;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPlexSourceListFromJSON)(jsonValue));
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesPlexPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPlexSourceRequestToJSON)(requestParameters.patchedPlexSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Redeem a plex token for an authenticated user, creating a connection
     */
    sourcesPlexRedeemTokenAuthenticatedCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.plexTokenRedeemRequest === null || requestParameters.plexTokenRedeemRequest === undefined) {
                throw new runtime.RequiredError('plexTokenRedeemRequest', 'Required parameter requestParameters.plexTokenRedeemRequest was null or undefined when calling sourcesPlexRedeemTokenAuthenticatedCreate.');
            }
            const queryParameters = {};
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/redeem_token_authenticated/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PlexTokenRedeemRequestToJSON)(requestParameters.plexTokenRedeemRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Redeem a plex token for an authenticated user, creating a connection
     */
    sourcesPlexRedeemTokenAuthenticatedCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesPlexRedeemTokenAuthenticatedCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Redeem a plex token, check it\'s access to resources against what\'s allowed for the source, and redirect to an authentication/enrollment flow.
     */
    sourcesPlexRedeemTokenCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.plexTokenRedeemRequest === null || requestParameters.plexTokenRedeemRequest === undefined) {
                throw new runtime.RequiredError('plexTokenRedeemRequest', 'Required parameter requestParameters.plexTokenRedeemRequest was null or undefined when calling sourcesPlexRedeemTokenCreate.');
            }
            const queryParameters = {};
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/redeem_token/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PlexTokenRedeemRequestToJSON)(requestParameters.plexTokenRedeemRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.RedirectChallengeFromJSON)(jsonValue));
        });
    }
    /**
     * Redeem a plex token, check it\'s access to resources against what\'s allowed for the source, and redirect to an authentication/enrollment flow.
     */
    sourcesPlexRedeemTokenCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexRedeemTokenCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesPlexRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesPlexUpdate.');
            }
            if (requestParameters.plexSourceRequest === null || requestParameters.plexSourceRequest === undefined) {
                throw new runtime.RequiredError('plexSourceRequest', 'Required parameter requestParameters.plexSourceRequest was null or undefined when calling sourcesPlexUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PlexSourceRequestToJSON)(requestParameters.plexSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceFromJSON)(jsonValue));
        });
    }
    /**
     * Plex source Viewset
     */
    sourcesPlexUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesPlexUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesPlexUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/plex/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesPlexUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesPlexUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.sAMLSourceRequest === null || requestParameters.sAMLSourceRequest === undefined) {
                throw new runtime.RequiredError('sAMLSourceRequest', 'Required parameter requestParameters.sAMLSourceRequest was null or undefined when calling sourcesSamlCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SAMLSourceRequestToJSON)(requestParameters.sAMLSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SAMLSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesSamlDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesSamlDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.allowIdpInitiated !== undefined) {
                queryParameters['allow_idp_initiated'] = requestParameters.allowIdpInitiated;
            }
            if (requestParameters.authenticationFlow !== undefined) {
                queryParameters['authentication_flow'] = requestParameters.authenticationFlow;
            }
            if (requestParameters.bindingType !== undefined) {
                queryParameters['binding_type'] = requestParameters.bindingType;
            }
            if (requestParameters.digestAlgorithm !== undefined) {
                queryParameters['digest_algorithm'] = requestParameters.digestAlgorithm;
            }
            if (requestParameters.enabled !== undefined) {
                queryParameters['enabled'] = requestParameters.enabled;
            }
            if (requestParameters.enrollmentFlow !== undefined) {
                queryParameters['enrollment_flow'] = requestParameters.enrollmentFlow;
            }
            if (requestParameters.issuer !== undefined) {
                queryParameters['issuer'] = requestParameters.issuer;
            }
            if (requestParameters.managed !== undefined) {
                queryParameters['managed'] = requestParameters.managed;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.nameIdPolicy !== undefined) {
                queryParameters['name_id_policy'] = requestParameters.nameIdPolicy;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyEngineMode !== undefined) {
                queryParameters['policy_engine_mode'] = requestParameters.policyEngineMode;
            }
            if (requestParameters.preAuthenticationFlow !== undefined) {
                queryParameters['pre_authentication_flow'] = requestParameters.preAuthenticationFlow;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.signatureAlgorithm !== undefined) {
                queryParameters['signature_algorithm'] = requestParameters.signatureAlgorithm;
            }
            if (requestParameters.signingKp !== undefined) {
                queryParameters['signing_kp'] = requestParameters.signingKp;
            }
            if (requestParameters.sloUrl !== undefined) {
                queryParameters['slo_url'] = requestParameters.sloUrl;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            if (requestParameters.ssoUrl !== undefined) {
                queryParameters['sso_url'] = requestParameters.ssoUrl;
            }
            if (requestParameters.temporaryUserDeleteAfter !== undefined) {
                queryParameters['temporary_user_delete_after'] = requestParameters.temporaryUserDeleteAfter;
            }
            if (requestParameters.userMatchingMode !== undefined) {
                queryParameters['user_matching_mode'] = requestParameters.userMatchingMode;
            }
            if (requestParameters.verificationKp !== undefined) {
                queryParameters['verification_kp'] = requestParameters.verificationKp;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSAMLSourceListFromJSON)(jsonValue));
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Return metadata as XML string
     */
    sourcesSamlMetadataRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesSamlMetadataRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/{slug}/metadata/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SAMLMetadataFromJSON)(jsonValue));
        });
    }
    /**
     * Return metadata as XML string
     */
    sourcesSamlMetadataRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlMetadataRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesSamlPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSAMLSourceRequestToJSON)(requestParameters.patchedSAMLSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SAMLSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesSamlRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SAMLSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesSamlUpdate.');
            }
            if (requestParameters.sAMLSourceRequest === null || requestParameters.sAMLSourceRequest === undefined) {
                throw new runtime.RequiredError('sAMLSourceRequest', 'Required parameter requestParameters.sAMLSourceRequest was null or undefined when calling sourcesSamlUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SAMLSourceRequestToJSON)(requestParameters.sAMLSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SAMLSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SAMLSource Viewset
     */
    sourcesSamlUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesSamlUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesSamlUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/saml/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesSamlUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesSamlUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.sCIMSourceRequest === null || requestParameters.sCIMSourceRequest === undefined) {
                throw new runtime.RequiredError('sCIMSourceRequest', 'Required parameter requestParameters.sCIMSourceRequest was null or undefined when calling sourcesScimCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SCIMSourceRequestToJSON)(requestParameters.sCIMSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesScimDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesScimDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.sCIMSourceGroupRequest === null || requestParameters.sCIMSourceGroupRequest === undefined) {
                throw new runtime.RequiredError('sCIMSourceGroupRequest', 'Required parameter requestParameters.sCIMSourceGroupRequest was null or undefined when calling sourcesScimGroupsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SCIMSourceGroupRequestToJSON)(requestParameters.sCIMSourceGroupRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceGroupFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimGroupsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimGroupsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesScimGroupsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.groupGroupUuid !== undefined) {
                queryParameters['group__group_uuid'] = requestParameters.groupGroupUuid;
            }
            if (requestParameters.groupName !== undefined) {
                queryParameters['group__name'] = requestParameters.groupName;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.sourceSlug !== undefined) {
                queryParameters['source__slug'] = requestParameters.sourceSlug;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSCIMSourceGroupListFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimGroupsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimGroupsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSCIMSourceGroupRequestToJSON)(requestParameters.patchedSCIMSourceGroupRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceGroupFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimGroupsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimGroupsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceGroupFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimGroupsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimGroupsUpdate.');
            }
            if (requestParameters.sCIMSourceGroupRequest === null || requestParameters.sCIMSourceGroupRequest === undefined) {
                throw new runtime.RequiredError('sCIMSourceGroupRequest', 'Required parameter requestParameters.sCIMSourceGroupRequest was null or undefined when calling sourcesScimGroupsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SCIMSourceGroupRequestToJSON)(requestParameters.sCIMSourceGroupRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceGroupFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceGroup Viewset
     */
    sourcesScimGroupsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimGroupsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimGroupsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimGroupsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_groups/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimGroupsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimGroupsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.slug !== undefined) {
                queryParameters['slug'] = requestParameters.slug;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSCIMSourceListFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesScimPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSCIMSourceRequestToJSON)(requestParameters.patchedSCIMSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesScimRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesScimUpdate.');
            }
            if (requestParameters.sCIMSourceRequest === null || requestParameters.sCIMSourceRequest === undefined) {
                throw new runtime.RequiredError('sCIMSourceRequest', 'Required parameter requestParameters.sCIMSourceRequest was null or undefined when calling sourcesScimUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SCIMSourceRequestToJSON)(requestParameters.sCIMSourceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSource Viewset
     */
    sourcesScimUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.slug === null || requestParameters.slug === undefined) {
                throw new runtime.RequiredError('slug', 'Required parameter requestParameters.slug was null or undefined when calling sourcesScimUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.sCIMSourceUserRequest === null || requestParameters.sCIMSourceUserRequest === undefined) {
                throw new runtime.RequiredError('sCIMSourceUserRequest', 'Required parameter requestParameters.sCIMSourceUserRequest was null or undefined when calling sourcesScimUsersCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SCIMSourceUserRequestToJSON)(requestParameters.sCIMSourceUserRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceUserFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsersCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimUsersDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesScimUsersDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.sourceSlug !== undefined) {
                queryParameters['source__slug'] = requestParameters.sourceSlug;
            }
            if (requestParameters.userId !== undefined) {
                queryParameters['user__id'] = requestParameters.userId;
            }
            if (requestParameters.userUsername !== undefined) {
                queryParameters['user__username'] = requestParameters.userUsername;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSCIMSourceUserListFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsersListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimUsersPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSCIMSourceUserRequestToJSON)(requestParameters.patchedSCIMSourceUserRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceUserFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsersPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimUsersRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceUserFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsersRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimUsersUpdate.');
            }
            if (requestParameters.sCIMSourceUserRequest === null || requestParameters.sCIMSourceUserRequest === undefined) {
                throw new runtime.RequiredError('sCIMSourceUserRequest', 'Required parameter requestParameters.sCIMSourceUserRequest was null or undefined when calling sourcesScimUsersUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SCIMSourceUserRequestToJSON)(requestParameters.sCIMSourceUserRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SCIMSourceUserFromJSON)(jsonValue));
        });
    }
    /**
     * SCIMSourceUser Viewset
     */
    sourcesScimUsersUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsersUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsersUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesScimUsersUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/scim_users/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesScimUsersUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesScimUsersUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsAllDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/all/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesUserConnectionsAllDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.user !== undefined) {
                queryParameters['user'] = requestParameters.user;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/all/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserSourceConnectionListFromJSON)(jsonValue));
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsAllListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsAllPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/all/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsAllPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsAllRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/all/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsAllRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsAllUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/all/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * User-source connection Viewset
     */
    sourcesUserConnectionsAllUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsAllUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsAllUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsAllUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/all/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsAllUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsAllUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userOAuthSourceConnectionRequest === null || requestParameters.userOAuthSourceConnectionRequest === undefined) {
                throw new runtime.RequiredError('userOAuthSourceConnectionRequest', 'Required parameter requestParameters.userOAuthSourceConnectionRequest was null or undefined when calling sourcesUserConnectionsOauthCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserOAuthSourceConnectionRequestToJSON)(requestParameters.userOAuthSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserOAuthSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsOauthCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsOauthDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesUserConnectionsOauthDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.sourceSlug !== undefined) {
                queryParameters['source__slug'] = requestParameters.sourceSlug;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserOAuthSourceConnectionListFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsOauthListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsOauthPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserOAuthSourceConnectionRequestToJSON)(requestParameters.patchedUserOAuthSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserOAuthSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsOauthPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsOauthRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserOAuthSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsOauthRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsOauthUpdate.');
            }
            if (requestParameters.userOAuthSourceConnectionRequest === null || requestParameters.userOAuthSourceConnectionRequest === undefined) {
                throw new runtime.RequiredError('userOAuthSourceConnectionRequest', 'Required parameter requestParameters.userOAuthSourceConnectionRequest was null or undefined when calling sourcesUserConnectionsOauthUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserOAuthSourceConnectionRequestToJSON)(requestParameters.userOAuthSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserOAuthSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsOauthUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsOauthUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsOauthUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsOauthUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/oauth/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsOauthUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsOauthUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.plexSourceConnectionRequest === null || requestParameters.plexSourceConnectionRequest === undefined) {
                throw new runtime.RequiredError('plexSourceConnectionRequest', 'Required parameter requestParameters.plexSourceConnectionRequest was null or undefined when calling sourcesUserConnectionsPlexCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PlexSourceConnectionRequestToJSON)(requestParameters.plexSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsPlexCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsPlexDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesUserConnectionsPlexDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.sourceSlug !== undefined) {
                queryParameters['source__slug'] = requestParameters.sourceSlug;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPlexSourceConnectionListFromJSON)(jsonValue));
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsPlexListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsPlexPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPlexSourceConnectionRequestToJSON)(requestParameters.patchedPlexSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsPlexPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsPlexRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsPlexRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsPlexUpdate.');
            }
            if (requestParameters.plexSourceConnectionRequest === null || requestParameters.plexSourceConnectionRequest === undefined) {
                throw new runtime.RequiredError('plexSourceConnectionRequest', 'Required parameter requestParameters.plexSourceConnectionRequest was null or undefined when calling sourcesUserConnectionsPlexUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PlexSourceConnectionRequestToJSON)(requestParameters.plexSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PlexSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Plex Source connection Serializer
     */
    sourcesUserConnectionsPlexUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsPlexUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsPlexUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsPlexUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/plex/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsPlexUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsPlexUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userSAMLSourceConnectionRequest === null || requestParameters.userSAMLSourceConnectionRequest === undefined) {
                throw new runtime.RequiredError('userSAMLSourceConnectionRequest', 'Required parameter requestParameters.userSAMLSourceConnectionRequest was null or undefined when calling sourcesUserConnectionsSamlCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserSAMLSourceConnectionRequestToJSON)(requestParameters.userSAMLSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSAMLSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsSamlCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsSamlDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sourcesUserConnectionsSamlDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.sourceSlug !== undefined) {
                queryParameters['source__slug'] = requestParameters.sourceSlug;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserSAMLSourceConnectionListFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsSamlListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsSamlPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserSAMLSourceConnectionRequestToJSON)(requestParameters.patchedUserSAMLSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSAMLSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsSamlPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsSamlRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSAMLSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsSamlRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsSamlUpdate.');
            }
            if (requestParameters.userSAMLSourceConnectionRequest === null || requestParameters.userSAMLSourceConnectionRequest === undefined) {
                throw new runtime.RequiredError('userSAMLSourceConnectionRequest', 'Required parameter requestParameters.userSAMLSourceConnectionRequest was null or undefined when calling sourcesUserConnectionsSamlUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserSAMLSourceConnectionRequestToJSON)(requestParameters.userSAMLSourceConnectionRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserSAMLSourceConnectionFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    sourcesUserConnectionsSamlUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsSamlUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsSamlUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling sourcesUserConnectionsSamlUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/sources/user_connections/saml/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    sourcesUserConnectionsSamlUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.sourcesUserConnectionsSamlUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
}
exports.SourcesApi = SourcesApi;
/**
 * @export
 */
exports.SourcesOauthListPolicyEngineModeEnum = {
    All: 'all',
    Any: 'any',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesOauthListUserMatchingModeEnum = {
    EmailDeny: 'email_deny',
    EmailLink: 'email_link',
    Identifier: 'identifier',
    UsernameDeny: 'username_deny',
    UsernameLink: 'username_link',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesPlexListPolicyEngineModeEnum = {
    All: 'all',
    Any: 'any',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesPlexListUserMatchingModeEnum = {
    EmailDeny: 'email_deny',
    EmailLink: 'email_link',
    Identifier: 'identifier',
    UsernameDeny: 'username_deny',
    UsernameLink: 'username_link',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesSamlListBindingTypeEnum = {
    Post: 'POST',
    PostAuto: 'POST_AUTO',
    Redirect: 'REDIRECT',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesSamlListDigestAlgorithmEnum = {
    _200009Xmldsigsha1: 'http://www.w3.org/2000/09/xmldsig#sha1',
    _200104XmldsigMoresha384: 'http://www.w3.org/2001/04/xmldsig-more#sha384',
    _200104Xmlencsha256: 'http://www.w3.org/2001/04/xmlenc#sha256',
    _200104Xmlencsha512: 'http://www.w3.org/2001/04/xmlenc#sha512',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesSamlListNameIdPolicyEnum = {
    _11nameidFormatemailAddress: 'urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress',
    _20nameidFormatWindowsDomainQualifiedName: 'urn:oasis:names:tc:SAML:2.0:nameid-format:WindowsDomainQualifiedName',
    _20nameidFormatX509SubjectName: 'urn:oasis:names:tc:SAML:2.0:nameid-format:X509SubjectName',
    _20nameidFormatpersistent: 'urn:oasis:names:tc:SAML:2.0:nameid-format:persistent',
    _20nameidFormattransient: 'urn:oasis:names:tc:SAML:2.0:nameid-format:transient',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesSamlListPolicyEngineModeEnum = {
    All: 'all',
    Any: 'any',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesSamlListSignatureAlgorithmEnum = {
    _200009XmldsigdsaSha1: 'http://www.w3.org/2000/09/xmldsig#dsa-sha1',
    _200009XmldsigrsaSha1: 'http://www.w3.org/2000/09/xmldsig#rsa-sha1',
    _200104XmldsigMoreecdsaSha1: 'http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1',
    _200104XmldsigMoreecdsaSha256: 'http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256',
    _200104XmldsigMoreecdsaSha384: 'http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384',
    _200104XmldsigMoreecdsaSha512: 'http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512',
    _200104XmldsigMorersaSha256: 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256',
    _200104XmldsigMorersaSha384: 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha384',
    _200104XmldsigMorersaSha512: 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha512',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.SourcesSamlListUserMatchingModeEnum = {
    EmailDeny: 'email_deny',
    EmailLink: 'email_link',
    Identifier: 'identifier',
    UsernameDeny: 'username_deny',
    UsernameLink: 'username_link',
    UnknownDefaultOpenApi: '11184809'
};
