{"content":"```yaml\nhttp:\n    middlewares:\n        authentik:\n            forwardAuth:\n                address: http://outpost.company:9000/outpost.goauthentik.io/auth/traefik\n                trustForwardHeader: true\n                authResponseHeaders:\n                    - X-authentik-username\n                    - X-authentik-groups\n                    - X-authentik-entitlements\n                    - X-authentik-email\n                    - X-authentik-name\n                    - X-authentik-uid\n                    - X-authentik-jwt\n                    - X-authentik-meta-jwks\n                    - X-authentik-meta-outpost\n                    - X-authentik-meta-provider\n                    - X-authentik-meta-app\n                    - X-authentik-meta-version\n    routers:\n        default-router:\n            rule: \"Host(`app.company`)\"\n            middlewares:\n                - authentik\n            priority: 10\n            service: app\n        default-router-auth:\n            rule: \"Host(`app.company`) && PathPrefix(`/outpost.goauthentik.io/`)\"\n            priority: 15\n            service: authentik\n    services:\n        app:\n            loadBalancer:\n                servers:\n                    - url: http://ip.internal\n        authentik:\n            loadBalancer:\n                servers:\n                    - url: http://outpost.company:9000/outpost.goauthentik.io\n```\n","publicPath":"/docs/add-secure-apps/providers/proxy/_traefik_standalone.md","publicDirectory":"/docs/add-secure-apps/providers/proxy"}