# Generated by Django 5.0.2 on 2024-02-20 08:26

import django.core.validators
from django.db import migrations, models

import authentik.lib.utils.time
from authentik.lib.config import CONFIG


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_tenants", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="tenant",
            name="default_token_duration",
            field=models.TextField(
                default=CONFIG.get("default_token_duration", "minutes=30"),
                help_text="Default token duration",
                validators=[authentik.lib.utils.time.timedelta_string_validator],
            ),
        ),
        migrations.AddField(
            model_name="tenant",
            name="default_token_length",
            field=models.PositiveIntegerField(
                default=CONFIG.get_int("default_token_length", 60),
                help_text="Default token length",
                validators=[django.core.validators.MinValueValidator(1)],
            ),
        ),
    ]
