# Generated by Django 3.1.2 on 2020-10-26 20:21

from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor

import authentik.lib.utils.time


def update_duration(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    UserLoginStage = apps.get_model("authentik_stages_user_login", "userloginstage")

    db_alias = schema_editor.connection.alias

    for stage in UserLoginStage.objects.using(db_alias).all():
        if stage.session_duration.isdigit():
            stage.session_duration = f"seconds={stage.session_duration}"
            stage.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_stages_user_login", "0002_userloginstage_session_duration"),
    ]

    operations = [
        migrations.AlterField(
            model_name="userloginstage",
            name="session_duration",
            field=models.TextField(
                default="seconds=0",
                help_text=(
                    "Determines how long a session lasts. Default of 0 means that the sessions"
                    " lasts until the browser is closed. (Format: hours=-1;minutes=-2;seconds=-3)"
                ),
                validators=[authentik.lib.utils.time.timedelta_string_validator],
            ),
        ),
        migrations.RunPython(update_duration),
    ]
