# Generated by Django 5.0.9 on 2024-09-23 11:27

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("authentik_core", "0039_source_group_matching_mode_alter_group_name_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="GroupKerberosSourceConnection",
            fields=[
                (
                    "groupsourceconnection_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.groupsourceconnection",
                    ),
                ),
            ],
            options={
                "verbose_name": "Group Kerberos Source Connection",
                "verbose_name_plural": "Group Kerberos Source Connections",
            },
            bases=("authentik_core.groupsourceconnection",),
        ),
        migrations.CreateModel(
            name="KerberosSource",
            fields=[
                (
                    "source_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.source",
                    ),
                ),
                ("realm", models.TextField(help_text="Kerberos realm", unique=True)),
                (
                    "krb5_conf",
                    models.TextField(
                        blank=True,
                        help_text="Custom krb5.conf to use. Uses the system one by default",
                    ),
                ),
                (
                    "sync_users",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="Sync users from Kerberos into authentik",
                    ),
                ),
                (
                    "sync_users_password",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="When a user changes their password, sync it back to Kerberos",
                    ),
                ),
                (
                    "sync_principal",
                    models.TextField(
                        blank=True, help_text="Principal to authenticate to kadmin for sync."
                    ),
                ),
                (
                    "sync_password",
                    models.TextField(
                        blank=True, help_text="Password to authenticate to kadmin for sync"
                    ),
                ),
                (
                    "sync_keytab",
                    models.TextField(
                        blank=True,
                        help_text="Keytab to authenticate to kadmin for sync. Must be base64-encoded or in the form TYPE:residual",
                    ),
                ),
                (
                    "sync_ccache",
                    models.TextField(
                        blank=True,
                        help_text="Credentials cache to authenticate to kadmin for sync. Must be in the form TYPE:residual",
                    ),
                ),
                (
                    "spnego_server_name",
                    models.TextField(
                        blank=True,
                        help_text="Force the use of a specific server name for SPNEGO. Must be in the form HTTP@hostname",
                    ),
                ),
                (
                    "spnego_keytab",
                    models.TextField(
                        blank=True,
                        help_text="SPNEGO keytab base64-encoded or path to keytab in the form FILE:path",
                    ),
                ),
                (
                    "spnego_ccache",
                    models.TextField(
                        blank=True,
                        help_text="Credential cache to use for SPNEGO in form type:residual",
                    ),
                ),
                (
                    "password_login_update_internal_password",
                    models.BooleanField(
                        default=False,
                        help_text="If enabled, the authentik-stored password will be updated upon login with the Kerberos password backend",
                    ),
                ),
            ],
            options={
                "verbose_name": "Kerberos Source",
                "verbose_name_plural": "Kerberos Sources",
            },
            bases=("authentik_core.source",),
        ),
        migrations.CreateModel(
            name="KerberosSourcePropertyMapping",
            fields=[
                (
                    "propertymapping_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.propertymapping",
                    ),
                ),
            ],
            options={
                "verbose_name": "Kerberos Source Property Mapping",
                "verbose_name_plural": "Kerberos Source Property Mappings",
            },
            bases=("authentik_core.propertymapping",),
        ),
        migrations.CreateModel(
            name="UserKerberosSourceConnection",
            fields=[
                (
                    "usersourceconnection_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.usersourceconnection",
                    ),
                ),
                ("identifier", models.TextField()),
            ],
            options={
                "verbose_name": "User Kerberos Source Connection",
                "verbose_name_plural": "User Kerberos Source Connections",
            },
            bases=("authentik_core.usersourceconnection",),
        ),
    ]
