# Generated by Django 5.0.1 on 2024-02-07 15:42

import uuid

import django.utils.timezone
from django.db import migrations, models

import authentik.core.models


class Migration(migrations.Migration):

    replaces = [
        ("authentik_events", "0004_systemtask"),
        ("authentik_events", "0005_remove_systemtask_finish_timestamp_and_more"),
    ]

    dependencies = [
        ("authentik_events", "0003_rename_tenant_event_brand"),
    ]

    operations = [
        migrations.CreateModel(
            name="SystemTask",
            fields=[
                (
                    "expires",
                    models.DateTimeField(default=authentik.core.models.default_token_duration),
                ),
                ("expiring", models.BooleanField(default=True)),
                (
                    "uuid",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.TextField()),
                ("uid", models.TextField(null=True)),
                (
                    "status",
                    models.TextField(
                        choices=[
                            ("unknown", "Unknown"),
                            ("successful", "Successful"),
                            ("warning", "Warning"),
                            ("error", "Error"),
                        ]
                    ),
                ),
                ("description", models.TextField(null=True)),
                ("messages", models.JSONField()),
                ("task_call_module", models.TextField()),
                ("task_call_func", models.TextField()),
                ("task_call_args", models.JSONField(default=list)),
                ("task_call_kwargs", models.JSONField(default=dict)),
                ("duration", models.FloatField(default=0)),
                ("finish_timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("start_timestamp", models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                "verbose_name": "System Task",
                "verbose_name_plural": "System Tasks",
                "permissions": [("run_task", "Run task")],
                "default_permissions": ["view"],
                "unique_together": {("name", "uid")},
            },
        ),
    ]
