/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * LDAP Source Serializer
 * @export
 * @interface PatchedLDAPSourceRequest
 */
export interface PatchedLDAPSourceRequest {
    /**
     * Source's display Name.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    name?: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    slug?: string;
    /**
     *
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    enrollmentFlow?: string | null;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof PatchedLDAPSourceRequest
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof PatchedLDAPSourceRequest
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     *
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    userPathTemplate?: string;
    /**
     *
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    serverUri?: string;
    /**
     * Optionally verify the LDAP Server's Certificate against the CA Chain in this keypair.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    peerCertificate?: string | null;
    /**
     * Client certificate to authenticate against the LDAP Server's Certificate.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    clientCertificate?: string | null;
    /**
     *
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    bindCn?: string;
    /**
     *
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    bindPassword?: string;
    /**
     *
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    startTls?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    sni?: boolean;
    /**
     *
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    baseDn?: string;
    /**
     * Prepended to Base DN for User-queries.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    additionalUserDn?: string;
    /**
     * Prepended to Base DN for Group-queries.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    additionalGroupDn?: string;
    /**
     * Consider Objects matching this filter to be Users.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    userObjectFilter?: string;
    /**
     * Consider Objects matching this filter to be Groups.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    groupObjectFilter?: string;
    /**
     * Field which contains members of a group.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    groupMembershipField?: string;
    /**
     * Field which contains a unique Identifier.
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    objectUniquenessField?: string;
    /**
     * Update internal authentik password when login succeeds with LDAP
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    passwordLoginUpdateInternalPassword?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    syncUsers?: boolean;
    /**
     * When a user changes their password, sync it back to LDAP. This can only be enabled on a single LDAP source.
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    syncUsersPassword?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof PatchedLDAPSourceRequest
     */
    syncGroups?: boolean;
    /**
     *
     * @type {string}
     * @memberof PatchedLDAPSourceRequest
     */
    syncParentGroup?: string | null;
    /**
     *
     * @type {Array<string>}
     * @memberof PatchedLDAPSourceRequest
     */
    propertyMappings?: Array<string>;
    /**
     * Property mappings used for group creation/updating.
     * @type {Array<string>}
     * @memberof PatchedLDAPSourceRequest
     */
    propertyMappingsGroup?: Array<string>;
}
/**
 * Check if a given object implements the PatchedLDAPSourceRequest interface.
 */
export declare function instanceOfPatchedLDAPSourceRequest(value: object): boolean;
export declare function PatchedLDAPSourceRequestFromJSON(json: any): PatchedLDAPSourceRequest;
export declare function PatchedLDAPSourceRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PatchedLDAPSourceRequest;
export declare function PatchedLDAPSourceRequestToJSON(value?: PatchedLDAPSourceRequest | null): any;
