## @goauthentik/api

This package provides a generated API Client for [authentik](https://goauthentik.io?utm_source=npm-api-package).

### Building

See https://goauthentik.io/developer-docs/making-schema-changes

### Consuming

```
npm install @goauthentik/api --save
```

Create a configuration:

```typescript
import { Configuration } from "@goauthentik/api";

export const DEFAULT_CONFIG = new Configuration({
    // Configure where the API is located
    // Can be a full host, ensure CORS is configured
    basePath: "",
    // Required for POST/PUT/DELETE requests
    // getCookie function must return the cookie's contents
    headers: {
        "X-authentik-CSRF": getCookie("authentik_csrf"),
    },
});
```

Then use the API:

```typescript
import { CoreApi } from "@goauthentik/api";

const user = await new CoreApi(DEFAULT_CONFIG).coreUsersMeRetrieve();
```
