{"content":"---\ntitle: Browser configuration for SPNEGO\n---\n\nYou might need to configure your web browser to allow SPNEGO. Following are the instructions for major browsers.\n\n## Firefox\n\n1.  In the address bar of Firefox, type `about:config` to display the list of current configuration options.\n2.  In the **Filter** field, type `negotiate` to restrict the list of options.\n3.  Double-click the `network.negotiate-auth.trusted-uris` entry to display the **Enter string value** dialog box.\n4.  Enter the name of the domain against which you want to authenticate. For example, `.example.com`.\n\nOn Windows environments, to automate the deployment of this configuration use a [Group policy](https://support.mozilla.org/en-US/kb/customizing-firefox-using-group-policy-windows). On Linux or macOS systems, use [policies.json](https://support.mozilla.org/en-US/kb/customizing-firefox-using-policiesjson).\n\n## Chrome\n\nThis section applies only for Chrome users on macOS and Linux machines. For Windows, see the instructions below.\n\n1. Make sure you have the necessary directory created by running: `mkdir -p /etc/opt/chrome/policies/managed/`\n2. Create a new `/etc/opt/chrome/policies/managed/mydomain.json` file with write privileges limited to the system administrator or root, and include the following line: `{ \"AuthServerWhitelist\": \"*.example.com\" }`.\n\n**Note**: if using Chromium, use `/etc/chromium/policies/managed/` instead of `/etc/opt/chrome/policies/managed/`.\n\nTo automate the deployment of this configuration use a [Group policy](https://support.google.com/chrome/a/answer/187202).\n\n## Windows / Internet Explorer\n\nLog in to the Windows machine using an account of your Kerberos realm (or administrative domain).\n\nOpen Internet Explorer, click **Tools** and then click **Internet Options**. You can also find **Internet Options** using the system search.\n\n1. Click the **Security** tab.\n2. Click **Local intranet**.\n3. Click **Sites**.\n4. Click **Advanced**.\n5. Add your domain to the list.\n6. Click the **Security tab**.\n7. Click **Local intranet**.\n8. Click **Custom Level**.\n9. Select **Automatic login only in Intranet zone**.\n\nTo automate the deployment of this configuration use a [Group policy](https://learn.microsoft.com/en-us/previous-versions/troubleshoot/browsers/administration/how-to-configure-group-policy-preference-settings).\n","publicPath":"/docs/users-sources/sources/protocols/kerberos/browser.md","publicDirectory":"/docs/users-sources/sources/protocols/kerberos"}