# Generated by Django 4.1.7 on 2023-03-24 17:32

from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def migrate_placeholder_expressions(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    from authentik.stages.prompt.models import CHOICE_FIELDS

    db_alias = schema_editor.connection.alias
    Prompt = apps.get_model("authentik_stages_prompt", "prompt")

    for prompt in Prompt.objects.using(db_alias).all():
        if not prompt.placeholder_expression or prompt.type in CHOICE_FIELDS:
            continue

        prompt.initial_value = prompt.placeholder
        prompt.initial_value_expression = True
        prompt.placeholder = ""
        prompt.placeholder_expression = False
        prompt.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_stages_prompt", "0010_alter_prompt_placeholder_alter_prompt_type"),
    ]

    operations = [
        migrations.AddField(
            model_name="prompt",
            name="initial_value",
            field=models.TextField(
                blank=True,
                help_text="Optionally pre-fill the input with an initial value. When creating a fixed choice field, enable interpreting as expression and return a list to return multiple default choices.",
            ),
        ),
        migrations.AddField(
            model_name="prompt",
            name="initial_value_expression",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="prompt",
            name="placeholder",
            field=models.TextField(
                blank=True,
                help_text="Optionally provide a short hint that describes the expected input value. When creating a fixed choice field, enable interpreting as expression and return a list to return multiple choices.",
            ),
        ),
        migrations.RunPython(code=migrate_placeholder_expressions),
    ]
