# Generated by Django 4.0.1 on 2022-01-05 22:09

from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def migrate_configuration_stage(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    db_alias = schema_editor.connection.alias
    AuthenticatorValidateStage = apps.get_model(
        "authentik_stages_authenticator_validate", "AuthenticatorValidateStage"
    )

    for stage in AuthenticatorValidateStage.objects.using(db_alias).all():
        if stage.configuration_stage:
            stage.configuration_stages.using(db_alias).set([stage.configuration_stage])
            stage.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_flows", "0021_auto_20211227_2103"),
        ("authentik_stages_authenticator_validate", "0009_default_stage"),
    ]

    operations = [
        migrations.AddField(
            model_name="authenticatorvalidatestage",
            name="configuration_stages",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text=(
                    "Stages used to configure Authenticator when user doesn't have any compatible"
                    " devices. After this configuration Stage passes, the user is not prompted"
                    " again."
                ),
                related_name="+",
                to="authentik_flows.Stage",
            ),
        ),
        migrations.RunPython(migrate_configuration_stage),
        migrations.RemoveField(
            model_name="authenticatorvalidatestage",
            name="configuration_stage",
        ),
    ]
