/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { OAuth2Provider } from './OAuth2Provider';
import {
    OAuth2ProviderFromJSON,
    OAuth2ProviderFromJSONTyped,
    OAuth2ProviderToJSON,
} from './OAuth2Provider';
import type { User } from './User';
import {
    UserFromJSON,
    UserFromJSONTyped,
    UserToJSON,
} from './User';

/**
 * Serializer for BaseGrantModel and RefreshToken
 * @export
 * @interface TokenModel
 */
export interface TokenModel {
    /**
     * 
     * @type {number}
     * @memberof TokenModel
     */
    readonly pk: number;
    /**
     * 
     * @type {OAuth2Provider}
     * @memberof TokenModel
     */
    provider: OAuth2Provider;
    /**
     * 
     * @type {User}
     * @memberof TokenModel
     */
    user: User;
    /**
     * Check if token is expired yet.
     * @type {boolean}
     * @memberof TokenModel
     */
    readonly isExpired: boolean;
    /**
     * 
     * @type {Date}
     * @memberof TokenModel
     */
    expires?: Date | null;
    /**
     * 
     * @type {Array<string>}
     * @memberof TokenModel
     */
    scope: Array<string>;
    /**
     * Get the token's id_token as JSON String
     * @type {string}
     * @memberof TokenModel
     */
    readonly idToken: string;
    /**
     * 
     * @type {boolean}
     * @memberof TokenModel
     */
    revoked?: boolean;
}

/**
 * Check if a given object implements the TokenModel interface.
 */
export function instanceOfTokenModel(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "provider" in value;
    isInstance = isInstance && "user" in value;
    isInstance = isInstance && "isExpired" in value;
    isInstance = isInstance && "scope" in value;
    isInstance = isInstance && "idToken" in value;

    return isInstance;
}

export function TokenModelFromJSON(json: any): TokenModel {
    return TokenModelFromJSONTyped(json, false);
}

export function TokenModelFromJSONTyped(json: any, ignoreDiscriminator: boolean): TokenModel {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'provider': OAuth2ProviderFromJSON(json['provider']),
        'user': UserFromJSON(json['user']),
        'isExpired': json['is_expired'],
        'expires': !exists(json, 'expires') ? undefined : (json['expires'] === null ? null : new Date(json['expires'])),
        'scope': json['scope'],
        'idToken': json['id_token'],
        'revoked': !exists(json, 'revoked') ? undefined : json['revoked'],
    };
}

export function TokenModelToJSON(value?: TokenModel | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'provider': OAuth2ProviderToJSON(value.provider),
        'user': UserToJSON(value.user),
        'expires': value.expires === undefined ? undefined : (value.expires === null ? null : value.expires.toISOString()),
        'scope': value.scope,
        'revoked': value.revoked,
    };
}

