/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * LDAP Source Serializer
 * @export
 * @interface LDAPSourceRequest
 */
export interface LDAPSourceRequest {
    /**
     * Source's display Name.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    slug: string;
    /**
     *
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    enrollmentFlow?: string | null;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof LDAPSourceRequest
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof LDAPSourceRequest
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     *
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    userPathTemplate?: string;
    /**
     *
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    serverUri: string;
    /**
     * Optionally verify the LDAP Server's Certificate against the CA Chain in this keypair.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    peerCertificate?: string | null;
    /**
     * Client certificate to authenticate against the LDAP Server's Certificate.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    clientCertificate?: string | null;
    /**
     *
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    bindCn?: string;
    /**
     *
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    bindPassword?: string;
    /**
     *
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    startTls?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    sni?: boolean;
    /**
     *
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    baseDn: string;
    /**
     * Prepended to Base DN for User-queries.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    additionalUserDn?: string;
    /**
     * Prepended to Base DN for Group-queries.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    additionalGroupDn?: string;
    /**
     * Consider Objects matching this filter to be Users.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    userObjectFilter?: string;
    /**
     * Consider Objects matching this filter to be Groups.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    groupObjectFilter?: string;
    /**
     * Field which contains members of a group.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    groupMembershipField?: string;
    /**
     * Field which contains a unique Identifier.
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    objectUniquenessField?: string;
    /**
     * Update internal authentik password when login succeeds with LDAP
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    passwordLoginUpdateInternalPassword?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    syncUsers?: boolean;
    /**
     * When a user changes their password, sync it back to LDAP. This can only be enabled on a single LDAP source.
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    syncUsersPassword?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof LDAPSourceRequest
     */
    syncGroups?: boolean;
    /**
     *
     * @type {string}
     * @memberof LDAPSourceRequest
     */
    syncParentGroup?: string | null;
    /**
     *
     * @type {Array<string>}
     * @memberof LDAPSourceRequest
     */
    propertyMappings?: Array<string>;
    /**
     * Property mappings used for group creation/updating.
     * @type {Array<string>}
     * @memberof LDAPSourceRequest
     */
    propertyMappingsGroup?: Array<string>;
}
/**
 * Check if a given object implements the LDAPSourceRequest interface.
 */
export declare function instanceOfLDAPSourceRequest(value: object): boolean;
export declare function LDAPSourceRequestFromJSON(json: any): LDAPSourceRequest;
export declare function LDAPSourceRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): LDAPSourceRequest;
export declare function LDAPSourceRequestToJSON(value?: LDAPSourceRequest | null): any;
