/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { LDAPAPIAccessMode } from './LDAPAPIAccessMode';
/**
 * LDAPProvider Serializer
 * @export
 * @interface LDAPProvider
 */
export interface LDAPProvider {
    /**
     *
     * @type {number}
     * @memberof LDAPProvider
     */
    readonly pk: number;
    /**
     *
     * @type {string}
     * @memberof LDAPProvider
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof LDAPProvider
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof LDAPProvider
     */
    authorizationFlow: string;
    /**
     *
     * @type {Array<string>}
     * @memberof LDAPProvider
     */
    propertyMappings?: Array<string>;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly component: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedApplicationName: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedBackchannelApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedBackchannelApplicationName: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly metaModelName: string;
    /**
     * DN under which objects are accessible.
     * @type {string}
     * @memberof LDAPProvider
     */
    baseDn?: string;
    /**
     * Users in this group can do search queries. If not set, every user can execute search queries.
     * @type {string}
     * @memberof LDAPProvider
     */
    searchGroup?: string | null;
    /**
     *
     * @type {string}
     * @memberof LDAPProvider
     */
    certificate?: string | null;
    /**
     *
     * @type {string}
     * @memberof LDAPProvider
     */
    tlsServerName?: string;
    /**
     * The start for uidNumbers, this number is added to the user.pk to make sure that the numbers aren't too low for POSIX users. Default is 2000 to ensure that we don't collide with local users uidNumber
     * @type {number}
     * @memberof LDAPProvider
     */
    uidStartNumber?: number;
    /**
     * The start for gidNumbers, this number is added to a number generated from the group.pk to make sure that the numbers aren't too low for POSIX groups. Default is 4000 to ensure that we don't collide with local groups or users primary groups gidNumber
     * @type {number}
     * @memberof LDAPProvider
     */
    gidStartNumber?: number;
    /**
     *
     * @type {Array<string>}
     * @memberof LDAPProvider
     */
    readonly outpostSet: Array<string>;
    /**
     *
     * @type {LDAPAPIAccessMode}
     * @memberof LDAPProvider
     */
    searchMode?: LDAPAPIAccessMode;
    /**
     *
     * @type {LDAPAPIAccessMode}
     * @memberof LDAPProvider
     */
    bindMode?: LDAPAPIAccessMode;
    /**
     * When enabled, code-based multi-factor authentication can be used by appending a semicolon and the TOTP code to the password. This should only be enabled if all users that will bind to this provider have a TOTP device configured, as otherwise a password may incorrectly be rejected if it contains a semicolon.
     * @type {boolean}
     * @memberof LDAPProvider
     */
    mfaSupport?: boolean;
}
/**
 * Check if a given object implements the LDAPProvider interface.
 */
export declare function instanceOfLDAPProvider(value: object): boolean;
export declare function LDAPProviderFromJSON(json: any): LDAPProvider;
export declare function LDAPProviderFromJSONTyped(json: any, ignoreDiscriminator: boolean): LDAPProvider;
export declare function LDAPProviderToJSON(value?: LDAPProvider | null): any;
