/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { BindingTypeEnum } from './BindingTypeEnum';
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import type { NameIdPolicyEnum } from './NameIdPolicyEnum';
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * SAMLSource Serializer
 * @export
 * @interface PatchedSAMLSourceRequest
 */
export interface PatchedSAMLSourceRequest {
    /**
     * Source's display Name.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    name?: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    slug?: string;
    /**
     *
     * @type {boolean}
     * @memberof PatchedSAMLSourceRequest
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    enrollmentFlow?: string | null;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof PatchedSAMLSourceRequest
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof PatchedSAMLSourceRequest
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     *
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    userPathTemplate?: string;
    /**
     * Flow used before authentication.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    preAuthenticationFlow?: string;
    /**
     * Also known as Entity ID. Defaults the Metadata URL.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    issuer?: string;
    /**
     * URL that the initial Login request is sent to.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    ssoUrl?: string;
    /**
     * Optional URL if your IDP supports Single-Logout.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    sloUrl?: string | null;
    /**
     * Allows authentication flows initiated by the IdP. This can be a security risk, as no validation of the request ID is done.
     * @type {boolean}
     * @memberof PatchedSAMLSourceRequest
     */
    allowIdpInitiated?: boolean;
    /**
     *
     * @type {NameIdPolicyEnum}
     * @memberof PatchedSAMLSourceRequest
     */
    nameIdPolicy?: NameIdPolicyEnum;
    /**
     *
     * @type {BindingTypeEnum}
     * @memberof PatchedSAMLSourceRequest
     */
    bindingType?: BindingTypeEnum;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    verificationKp?: string | null;
    /**
     * Keypair used to sign outgoing Responses going to the Identity Provider.
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    signingKp?: string | null;
    /**
     *
     * @type {DigestAlgorithmEnum}
     * @memberof PatchedSAMLSourceRequest
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     *
     * @type {SignatureAlgorithmEnum}
     * @memberof PatchedSAMLSourceRequest
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Time offset when temporary users should be deleted. This only applies if your IDP uses the NameID Format 'transient', and the user doesn't log out manually. (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof PatchedSAMLSourceRequest
     */
    temporaryUserDeleteAfter?: string;
}
/**
 * Check if a given object implements the PatchedSAMLSourceRequest interface.
 */
export declare function instanceOfPatchedSAMLSourceRequest(value: object): boolean;
export declare function PatchedSAMLSourceRequestFromJSON(json: any): PatchedSAMLSourceRequest;
export declare function PatchedSAMLSourceRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PatchedSAMLSourceRequest;
export declare function PatchedSAMLSourceRequestToJSON(value?: PatchedSAMLSourceRequest | null): any;
