{"content":"Use the following configuration:\n\n```apacheconf\napp.company {\n    # directive execution order is only as stated if enclosed with route.\n    route {\n        # always forward outpost path to actual outpost\n        reverse_proxy /outpost.goauthentik.io/* http://outpost.company:9000\n\n        # forward authentication to outpost\n        forward_auth http://outpost.company:9000 {\n            uri /outpost.goauthentik.io/auth/caddy\n\n            # capitalization of the headers is important, otherwise they will be empty\n            copy_headers X-Authentik-Username X-Authentik-Groups X-Authentik-Entitlements X-Authentik-Email X-Authentik-Name X-Authentik-Uid X-Authentik-Jwt X-Authentik-Meta-Jwks X-Authentik-Meta-Outpost X-Authentik-Meta-Provider X-Authentik-Meta-App X-Authentik-Meta-Version\n\n            # optional, in this config trust all private ranges, should probably be set to the outposts IP\n            trusted_proxies private_ranges\n        }\n\n        # actual site configuration below, for example\n        reverse_proxy localhost:1234\n    }\n}\n```\n\nIf you're trying to proxy to an upstream over HTTPS, you need to set the `Host` header to the value they expect for it to work correctly.\n\n```conf\nreverse_proxy /outpost.goauthentik.io/* https://outpost.company {\n    header_up Host {http.reverse_proxy.upstream.host}\n}\n```\n","publicPath":"/docs/add-secure-apps/providers/proxy/_caddy_standalone.md","publicDirectory":"/docs/add-secure-apps/providers/proxy"}