# Generated by Django 3.2.8 on 2021-10-14 09:41

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ("authentik_stages_authenticator_sms", "0001_initial"),
        ("authentik_stages_authenticator_sms", "0002_authenticatorsmsstage_from_number"),
        ("authentik_stages_authenticator_sms", "0003_auto_20211014_0813"),
        ("authentik_stages_authenticator_sms", "0004_auto_20211014_0936"),
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authentik_flows", "0024_alter_flow_compatibility_mode"),
    ]

    operations = [
        migrations.CreateModel(
            name="AuthenticatorSMSStage",
            fields=[
                (
                    "stage_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_flows.stage",
                    ),
                ),
                (
                    "provider",
                    models.TextField(choices=[("twilio", "Twilio"), ("generic", "Generic")]),
                ),
                ("account_sid", models.TextField()),
                ("auth", models.TextField()),
                (
                    "configure_flow",
                    models.ForeignKey(
                        blank=True,
                        help_text=(
                            "Flow used by an authenticated user to configure this Stage. If empty,"
                            " user will not be able to configure this stage."
                        ),
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="authentik_flows.flow",
                    ),
                ),
                ("from_number", models.TextField(default="")),
                ("auth_password", models.TextField(blank=True, default="")),
                (
                    "auth_type",
                    models.TextField(
                        choices=[("basic", "Basic"), ("bearer", "Bearer")], default="basic"
                    ),
                ),
            ],
            options={
                "verbose_name": "SMS Authenticator Setup Stage",
                "verbose_name_plural": "SMS Authenticator Setup Stages",
            },
            bases=("authentik_flows.stage", models.Model),
        ),
        migrations.CreateModel(
            name="SMSDevice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The human-readable name of this device.", max_length=64
                    ),
                ),
                (
                    "confirmed",
                    models.BooleanField(default=True, help_text="Is this device ready for use?"),
                ),
                ("token", models.CharField(blank=True, max_length=16, null=True)),
                (
                    "valid_until",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="The timestamp of the moment of expiry of the saved token.",
                    ),
                ),
                ("phone_number", models.TextField()),
                (
                    "stage",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_stages_authenticator_sms.authenticatorsmsstage",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "verbose_name": "SMS Device",
                "verbose_name_plural": "SMS Devices",
            },
        ),
    ]
