# Generated by Django 5.0.9 on 2024-10-10 15:45

from django.db import migrations, models
from django.apps.registry import Apps

from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def fix_X509SubjectName(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    db_alias = schema_editor.connection.alias

    SAMLSource = apps.get_model("authentik_sources_saml", "SAMLSource")
    SAMLSource.objects.using(db_alias).filter(
        name_id_policy="urn:oasis:names:tc:SAML:2.0:nameid-format:X509SubjectName"
    ).update(name_id_policy="urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_sources_saml", "0016_samlsource_encryption_kp"),
    ]

    operations = [
        migrations.RunPython(fix_X509SubjectName),
        migrations.AlterField(
            model_name="samlsource",
            name="name_id_policy",
            field=models.TextField(
                choices=[
                    ("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "Email"),
                    ("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "Persistent"),
                    ("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "X509"),
                    (
                        "urn:oasis:names:tc:SAML:2.0:nameid-format:WindowsDomainQualifiedName",
                        "Windows",
                    ),
                    ("urn:oasis:names:tc:SAML:2.0:nameid-format:transient", "Transient"),
                ],
                default="urn:oasis:names:tc:SAML:2.0:nameid-format:persistent",
                help_text="NameID Policy sent to the IdP. Can be unset, in which case no Policy is sent.",
            ),
        ),
    ]
