# Generated by Django 4.1.7 on 2023-03-07 13:07

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ("authentik_providers_scim", "0001_initial"),
        ("authentik_providers_scim", "0002_scimuser"),
        ("authentik_providers_scim", "0003_scimgroup"),
        ("authentik_providers_scim", "0004_scimprovider_property_mappings_group"),
        ("authentik_providers_scim", "0005_scimprovider_exclude_users_service_account_and_more"),
        ("authentik_providers_scim", "0006_rename_parent_group_scimprovider_filter_group"),
    ]

    initial = True

    dependencies = [
        ("authentik_core", "0024_source_icon"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authentik_core", "0025_alter_provider_authorization_flow"),
    ]

    operations = [
        migrations.CreateModel(
            name="SCIMMapping",
            fields=[
                (
                    "propertymapping_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.propertymapping",
                    ),
                ),
            ],
            options={
                "verbose_name": "SCIM Mapping",
                "verbose_name_plural": "SCIM Mappings",
            },
            bases=("authentik_core.propertymapping",),
        ),
        migrations.CreateModel(
            name="SCIMProvider",
            fields=[
                (
                    "provider_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.provider",
                    ),
                ),
                (
                    "url",
                    models.TextField(help_text="Base URL to SCIM requests, usually ends in /v2"),
                ),
                ("token", models.TextField(help_text="Authentication token")),
                (
                    "property_mappings_group",
                    models.ManyToManyField(
                        blank=True,
                        default=None,
                        help_text="Property mappings used for group creation/updating.",
                        to="authentik_core.propertymapping",
                    ),
                ),
                ("exclude_users_service_account", models.BooleanField(default=False)),
                (
                    "filter_group",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        to="authentik_core.group",
                    ),
                ),
            ],
            options={
                "verbose_name": "SCIM Provider",
                "verbose_name_plural": "SCIM Providers",
            },
            bases=("authentik_core.provider",),
        ),
        migrations.CreateModel(
            name="SCIMUser",
            fields=[
                ("id", models.TextField(primary_key=True, serialize=False)),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_providers_scim.scimprovider",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "unique_together": {("id", "user", "provider")},
            },
        ),
        migrations.CreateModel(
            name="SCIMGroup",
            fields=[
                ("id", models.TextField(primary_key=True, serialize=False)),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="authentik_core.group"
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_providers_scim.scimprovider",
                    ),
                ),
            ],
            options={
                "unique_together": {("id", "group", "provider")},
            },
        ),
    ]
