# Generated by Django 3.1.3 on 2020-11-12 10:36

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_crypto", "0002_create_self_signed_kp"),
        ("authentik_providers_saml", "0007_samlprovider_verification_kp"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="samlprovider",
            name="require_signing",
        ),
        migrations.AlterField(
            model_name="samlprovider",
            name="audience",
            field=models.TextField(
                default="",
                help_text="Value of the audience restriction field of the assertion.",
            ),
        ),
        migrations.AlterField(
            model_name="samlprovider",
            name="issuer",
            field=models.TextField(default="authentik", help_text="Also known as EntityID"),
        ),
        migrations.AlterField(
            model_name="samlprovider",
            name="signing_kp",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Keypair used to sign outgoing Responses going to the Service Provider.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="authentik_crypto.certificatekeypair",
                verbose_name="Signing Keypair",
            ),
        ),
        migrations.AlterField(
            model_name="samlprovider",
            name="sp_binding",
            field=models.TextField(
                choices=[("redirect", "Redirect"), ("post", "Post")],
                default="redirect",
                help_text=(
                    "This determines how authentik sends the response back to the Service Provider."
                ),
                verbose_name="Service Provider Binding",
            ),
        ),
        migrations.AlterField(
            model_name="samlprovider",
            name="verification_kp",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text=(
                    "When selected, incoming assertion's Signatures will be validated against this"
                    " certificate. To allow unsigned Requests, leave on default."
                ),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="authentik_crypto.certificatekeypair",
                verbose_name="Verification Certificate",
            ),
        ),
    ]
