# Generated by Django 3.2.8 on 2021-11-05 09:41

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ("authentik_providers_ldap", "0001_initial"),
        ("authentik_providers_ldap", "0002_ldapprovider_search_group"),
        ("authentik_providers_ldap", "0003_auto_20210713_1138"),
        ("authentik_providers_ldap", "0004_auto_20210713_2115"),
        ("authentik_providers_ldap", "0005_ldapprovider_search_mode"),
    ]

    initial = True

    dependencies = [
        ("authentik_core", "0019_source_managed"),
        ("authentik_crypto", "0002_create_self_signed_kp"),
    ]

    operations = [
        migrations.CreateModel(
            name="LDAPProvider",
            fields=[
                (
                    "provider_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.provider",
                    ),
                ),
                (
                    "base_dn",
                    models.TextField(
                        default="DC=ldap,DC=goauthentik,DC=io",
                        help_text="DN under which objects are accessible.",
                    ),
                ),
                (
                    "search_group",
                    models.ForeignKey(
                        default=None,
                        help_text=(
                            "Users in this group can do search queries. If not set, every user can"
                            " execute search queries."
                        ),
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        to="authentik_core.group",
                    ),
                ),
                (
                    "certificate",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="authentik_crypto.certificatekeypair",
                    ),
                ),
                ("tls_server_name", models.TextField(blank=True, default="")),
                (
                    "gid_start_number",
                    models.IntegerField(
                        default=4000,
                        help_text=(
                            "The start for gidNumbers, this number is added to a number generated"
                            " from the group.Pk to make sure that the numbers aren't too low for"
                            " POSIX groups. Default is 4000 to ensure that we don't collide with"
                            " local groups or users primary groups gidNumber"
                        ),
                    ),
                ),
                (
                    "uid_start_number",
                    models.IntegerField(
                        default=2000,
                        help_text=(
                            "The start for uidNumbers, this number is added to the user.Pk to make"
                            " sure that the numbers aren't too low for POSIX users. Default is 2000"
                            " to ensure that we don't collide with local users uidNumber"
                        ),
                    ),
                ),
                (
                    "search_mode",
                    models.TextField(
                        choices=[("direct", "Direct"), ("cached", "Cached")], default="direct"
                    ),
                ),
            ],
            options={
                "verbose_name": "LDAP Provider",
                "verbose_name_plural": "LDAP Providers",
            },
            bases=("authentik_core.provider", models.Model),
        ),
    ]
