/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  GenericError,
  PaginatedExtraRoleObjectPermissionList,
  PaginatedExtraUserObjectPermissionList,
  PaginatedPermissionList,
  PaginatedRoleAssignedObjectPermissionList,
  PaginatedRoleList,
  PaginatedUserAssignedObjectPermissionList,
  PatchedPermissionAssignRequest,
  PatchedRoleRequest,
  Permission,
  PermissionAssignRequest,
  Role,
  RoleRequest,
  UsedBy,
  ValidationError,
} from '../models';
import {
    GenericErrorFromJSON,
    GenericErrorToJSON,
    PaginatedExtraRoleObjectPermissionListFromJSON,
    PaginatedExtraRoleObjectPermissionListToJSON,
    PaginatedExtraUserObjectPermissionListFromJSON,
    PaginatedExtraUserObjectPermissionListToJSON,
    PaginatedPermissionListFromJSON,
    PaginatedPermissionListToJSON,
    PaginatedRoleAssignedObjectPermissionListFromJSON,
    PaginatedRoleAssignedObjectPermissionListToJSON,
    PaginatedRoleListFromJSON,
    PaginatedRoleListToJSON,
    PaginatedUserAssignedObjectPermissionListFromJSON,
    PaginatedUserAssignedObjectPermissionListToJSON,
    PatchedPermissionAssignRequestFromJSON,
    PatchedPermissionAssignRequestToJSON,
    PatchedRoleRequestFromJSON,
    PatchedRoleRequestToJSON,
    PermissionFromJSON,
    PermissionToJSON,
    PermissionAssignRequestFromJSON,
    PermissionAssignRequestToJSON,
    RoleFromJSON,
    RoleToJSON,
    RoleRequestFromJSON,
    RoleRequestToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface RbacPermissionsAssignedByRolesAssignCreateRequest {
    uuid: string;
    permissionAssignRequest: PermissionAssignRequest;
}

export interface RbacPermissionsAssignedByRolesListRequest {
    model: RbacPermissionsAssignedByRolesListModelEnum;
    objectPk?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface RbacPermissionsAssignedByRolesUnassignPartialUpdateRequest {
    uuid: string;
    patchedPermissionAssignRequest?: PatchedPermissionAssignRequest;
}

export interface RbacPermissionsAssignedByUsersAssignCreateRequest {
    id: number;
    permissionAssignRequest: PermissionAssignRequest;
}

export interface RbacPermissionsAssignedByUsersListRequest {
    model: RbacPermissionsAssignedByUsersListModelEnum;
    objectPk?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface RbacPermissionsAssignedByUsersUnassignPartialUpdateRequest {
    id: number;
    patchedPermissionAssignRequest?: PatchedPermissionAssignRequest;
}

export interface RbacPermissionsListRequest {
    codename?: string;
    contentTypeAppLabel?: string;
    contentTypeModel?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    role?: string;
    search?: string;
    user?: number;
}

export interface RbacPermissionsRetrieveRequest {
    id: number;
}

export interface RbacPermissionsRolesListRequest {
    uuid: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface RbacPermissionsUsersListRequest {
    userId: number;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface RbacRolesCreateRequest {
    roleRequest: RoleRequest;
}

export interface RbacRolesDestroyRequest {
    uuid: string;
}

export interface RbacRolesListRequest {
    groupName?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface RbacRolesPartialUpdateRequest {
    uuid: string;
    patchedRoleRequest?: PatchedRoleRequest;
}

export interface RbacRolesRetrieveRequest {
    uuid: string;
}

export interface RbacRolesUpdateRequest {
    uuid: string;
    roleRequest: RoleRequest;
}

export interface RbacRolesUsedByListRequest {
    uuid: string;
}

/**
 * 
 */
export class RbacApi extends runtime.BaseAPI {

    /**
     * Assign permission(s) to role. When `object_pk` is set, the permissions are only assigned to the specific object, otherwise they are assigned globally.
     */
    async rbacPermissionsAssignedByRolesAssignCreateRaw(requestParameters: RbacPermissionsAssignedByRolesAssignCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacPermissionsAssignedByRolesAssignCreate.');
        }

        if (requestParameters.permissionAssignRequest === null || requestParameters.permissionAssignRequest === undefined) {
            throw new runtime.RequiredError('permissionAssignRequest','Required parameter requestParameters.permissionAssignRequest was null or undefined when calling rbacPermissionsAssignedByRolesAssignCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/assigned_by_roles/{uuid}/assign/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PermissionAssignRequestToJSON(requestParameters.permissionAssignRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Assign permission(s) to role. When `object_pk` is set, the permissions are only assigned to the specific object, otherwise they are assigned globally.
     */
    async rbacPermissionsAssignedByRolesAssignCreate(requestParameters: RbacPermissionsAssignedByRolesAssignCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.rbacPermissionsAssignedByRolesAssignCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Get assigned object permissions for a single object
     */
    async rbacPermissionsAssignedByRolesListRaw(requestParameters: RbacPermissionsAssignedByRolesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedRoleAssignedObjectPermissionList>> {
        if (requestParameters.model === null || requestParameters.model === undefined) {
            throw new runtime.RequiredError('model','Required parameter requestParameters.model was null or undefined when calling rbacPermissionsAssignedByRolesList.');
        }

        const queryParameters: any = {};

        if (requestParameters.model !== undefined) {
            queryParameters['model'] = requestParameters.model;
        }

        if (requestParameters.objectPk !== undefined) {
            queryParameters['object_pk'] = requestParameters.objectPk;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/assigned_by_roles/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedRoleAssignedObjectPermissionListFromJSON(jsonValue));
    }

    /**
     * Get assigned object permissions for a single object
     */
    async rbacPermissionsAssignedByRolesList(requestParameters: RbacPermissionsAssignedByRolesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedRoleAssignedObjectPermissionList> {
        const response = await this.rbacPermissionsAssignedByRolesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Unassign permission(s) to role. When `object_pk` is set, the permissions are only assigned to the specific object, otherwise they are assigned globally.
     */
    async rbacPermissionsAssignedByRolesUnassignPartialUpdateRaw(requestParameters: RbacPermissionsAssignedByRolesUnassignPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacPermissionsAssignedByRolesUnassignPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/assigned_by_roles/{uuid}/unassign/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedPermissionAssignRequestToJSON(requestParameters.patchedPermissionAssignRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Unassign permission(s) to role. When `object_pk` is set, the permissions are only assigned to the specific object, otherwise they are assigned globally.
     */
    async rbacPermissionsAssignedByRolesUnassignPartialUpdate(requestParameters: RbacPermissionsAssignedByRolesUnassignPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.rbacPermissionsAssignedByRolesUnassignPartialUpdateRaw(requestParameters, initOverrides);
    }

    /**
     * Assign permission(s) to user
     */
    async rbacPermissionsAssignedByUsersAssignCreateRaw(requestParameters: RbacPermissionsAssignedByUsersAssignCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling rbacPermissionsAssignedByUsersAssignCreate.');
        }

        if (requestParameters.permissionAssignRequest === null || requestParameters.permissionAssignRequest === undefined) {
            throw new runtime.RequiredError('permissionAssignRequest','Required parameter requestParameters.permissionAssignRequest was null or undefined when calling rbacPermissionsAssignedByUsersAssignCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/assigned_by_users/{id}/assign/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PermissionAssignRequestToJSON(requestParameters.permissionAssignRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Assign permission(s) to user
     */
    async rbacPermissionsAssignedByUsersAssignCreate(requestParameters: RbacPermissionsAssignedByUsersAssignCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.rbacPermissionsAssignedByUsersAssignCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Get assigned object permissions for a single object
     */
    async rbacPermissionsAssignedByUsersListRaw(requestParameters: RbacPermissionsAssignedByUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserAssignedObjectPermissionList>> {
        if (requestParameters.model === null || requestParameters.model === undefined) {
            throw new runtime.RequiredError('model','Required parameter requestParameters.model was null or undefined when calling rbacPermissionsAssignedByUsersList.');
        }

        const queryParameters: any = {};

        if (requestParameters.model !== undefined) {
            queryParameters['model'] = requestParameters.model;
        }

        if (requestParameters.objectPk !== undefined) {
            queryParameters['object_pk'] = requestParameters.objectPk;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/assigned_by_users/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedUserAssignedObjectPermissionListFromJSON(jsonValue));
    }

    /**
     * Get assigned object permissions for a single object
     */
    async rbacPermissionsAssignedByUsersList(requestParameters: RbacPermissionsAssignedByUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserAssignedObjectPermissionList> {
        const response = await this.rbacPermissionsAssignedByUsersListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Unassign permission(s) to user. When `object_pk` is set, the permissions are only assigned to the specific object, otherwise they are assigned globally.
     */
    async rbacPermissionsAssignedByUsersUnassignPartialUpdateRaw(requestParameters: RbacPermissionsAssignedByUsersUnassignPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling rbacPermissionsAssignedByUsersUnassignPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/assigned_by_users/{id}/unassign/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedPermissionAssignRequestToJSON(requestParameters.patchedPermissionAssignRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Unassign permission(s) to user. When `object_pk` is set, the permissions are only assigned to the specific object, otherwise they are assigned globally.
     */
    async rbacPermissionsAssignedByUsersUnassignPartialUpdate(requestParameters: RbacPermissionsAssignedByUsersUnassignPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.rbacPermissionsAssignedByUsersUnassignPartialUpdateRaw(requestParameters, initOverrides);
    }

    /**
     * Read-only list of all permissions, filterable by model and app
     */
    async rbacPermissionsListRaw(requestParameters: RbacPermissionsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedPermissionList>> {
        const queryParameters: any = {};

        if (requestParameters.codename !== undefined) {
            queryParameters['codename'] = requestParameters.codename;
        }

        if (requestParameters.contentTypeAppLabel !== undefined) {
            queryParameters['content_type__app_label'] = requestParameters.contentTypeAppLabel;
        }

        if (requestParameters.contentTypeModel !== undefined) {
            queryParameters['content_type__model'] = requestParameters.contentTypeModel;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.role !== undefined) {
            queryParameters['role'] = requestParameters.role;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.user !== undefined) {
            queryParameters['user'] = requestParameters.user;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedPermissionListFromJSON(jsonValue));
    }

    /**
     * Read-only list of all permissions, filterable by model and app
     */
    async rbacPermissionsList(requestParameters: RbacPermissionsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedPermissionList> {
        const response = await this.rbacPermissionsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Read-only list of all permissions, filterable by model and app
     */
    async rbacPermissionsRetrieveRaw(requestParameters: RbacPermissionsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Permission>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling rbacPermissionsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PermissionFromJSON(jsonValue));
    }

    /**
     * Read-only list of all permissions, filterable by model and app
     */
    async rbacPermissionsRetrieve(requestParameters: RbacPermissionsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Permission> {
        const response = await this.rbacPermissionsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a role\'s assigned object permissions
     */
    async rbacPermissionsRolesListRaw(requestParameters: RbacPermissionsRolesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedExtraRoleObjectPermissionList>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacPermissionsRolesList.');
        }

        const queryParameters: any = {};

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.uuid !== undefined) {
            queryParameters['uuid'] = requestParameters.uuid;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/roles/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedExtraRoleObjectPermissionListFromJSON(jsonValue));
    }

    /**
     * Get a role\'s assigned object permissions
     */
    async rbacPermissionsRolesList(requestParameters: RbacPermissionsRolesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedExtraRoleObjectPermissionList> {
        const response = await this.rbacPermissionsRolesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a users\'s assigned object permissions
     */
    async rbacPermissionsUsersListRaw(requestParameters: RbacPermissionsUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedExtraUserObjectPermissionList>> {
        if (requestParameters.userId === null || requestParameters.userId === undefined) {
            throw new runtime.RequiredError('userId','Required parameter requestParameters.userId was null or undefined when calling rbacPermissionsUsersList.');
        }

        const queryParameters: any = {};

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.userId !== undefined) {
            queryParameters['user_id'] = requestParameters.userId;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/permissions/users/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedExtraUserObjectPermissionListFromJSON(jsonValue));
    }

    /**
     * Get a users\'s assigned object permissions
     */
    async rbacPermissionsUsersList(requestParameters: RbacPermissionsUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedExtraUserObjectPermissionList> {
        const response = await this.rbacPermissionsUsersListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Role viewset
     */
    async rbacRolesCreateRaw(requestParameters: RbacRolesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Role>> {
        if (requestParameters.roleRequest === null || requestParameters.roleRequest === undefined) {
            throw new runtime.RequiredError('roleRequest','Required parameter requestParameters.roleRequest was null or undefined when calling rbacRolesCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: RoleRequestToJSON(requestParameters.roleRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RoleFromJSON(jsonValue));
    }

    /**
     * Role viewset
     */
    async rbacRolesCreate(requestParameters: RbacRolesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Role> {
        const response = await this.rbacRolesCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Role viewset
     */
    async rbacRolesDestroyRaw(requestParameters: RbacRolesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacRolesDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Role viewset
     */
    async rbacRolesDestroy(requestParameters: RbacRolesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.rbacRolesDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Role viewset
     */
    async rbacRolesListRaw(requestParameters: RbacRolesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedRoleList>> {
        const queryParameters: any = {};

        if (requestParameters.groupName !== undefined) {
            queryParameters['group__name'] = requestParameters.groupName;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedRoleListFromJSON(jsonValue));
    }

    /**
     * Role viewset
     */
    async rbacRolesList(requestParameters: RbacRolesListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedRoleList> {
        const response = await this.rbacRolesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Role viewset
     */
    async rbacRolesPartialUpdateRaw(requestParameters: RbacRolesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Role>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacRolesPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedRoleRequestToJSON(requestParameters.patchedRoleRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RoleFromJSON(jsonValue));
    }

    /**
     * Role viewset
     */
    async rbacRolesPartialUpdate(requestParameters: RbacRolesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Role> {
        const response = await this.rbacRolesPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Role viewset
     */
    async rbacRolesRetrieveRaw(requestParameters: RbacRolesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Role>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacRolesRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RoleFromJSON(jsonValue));
    }

    /**
     * Role viewset
     */
    async rbacRolesRetrieve(requestParameters: RbacRolesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Role> {
        const response = await this.rbacRolesRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Role viewset
     */
    async rbacRolesUpdateRaw(requestParameters: RbacRolesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Role>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacRolesUpdate.');
        }

        if (requestParameters.roleRequest === null || requestParameters.roleRequest === undefined) {
            throw new runtime.RequiredError('roleRequest','Required parameter requestParameters.roleRequest was null or undefined when calling rbacRolesUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: RoleRequestToJSON(requestParameters.roleRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RoleFromJSON(jsonValue));
    }

    /**
     * Role viewset
     */
    async rbacRolesUpdate(requestParameters: RbacRolesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Role> {
        const response = await this.rbacRolesUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async rbacRolesUsedByListRaw(requestParameters: RbacRolesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling rbacRolesUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/rbac/roles/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async rbacRolesUsedByList(requestParameters: RbacRolesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.rbacRolesUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const RbacPermissionsAssignedByRolesListModelEnum = {
    BlueprintsBlueprintinstance: 'authentik_blueprints.blueprintinstance',
    BrandsBrand: 'authentik_brands.brand',
    CoreApplication: 'authentik_core.application',
    CoreGroup: 'authentik_core.group',
    CoreToken: 'authentik_core.token',
    CoreUser: 'authentik_core.user',
    CryptoCertificatekeypair: 'authentik_crypto.certificatekeypair',
    EnterpriseLicense: 'authentik_enterprise.license',
    EventsEvent: 'authentik_events.event',
    EventsNotification: 'authentik_events.notification',
    EventsNotificationrule: 'authentik_events.notificationrule',
    EventsNotificationtransport: 'authentik_events.notificationtransport',
    EventsNotificationwebhookmapping: 'authentik_events.notificationwebhookmapping',
    FlowsFlow: 'authentik_flows.flow',
    FlowsFlowstagebinding: 'authentik_flows.flowstagebinding',
    OutpostsDockerserviceconnection: 'authentik_outposts.dockerserviceconnection',
    OutpostsKubernetesserviceconnection: 'authentik_outposts.kubernetesserviceconnection',
    OutpostsOutpost: 'authentik_outposts.outpost',
    PoliciesPolicybinding: 'authentik_policies.policybinding',
    PoliciesDummyDummypolicy: 'authentik_policies_dummy.dummypolicy',
    PoliciesEventMatcherEventmatcherpolicy: 'authentik_policies_event_matcher.eventmatcherpolicy',
    PoliciesExpiryPasswordexpirypolicy: 'authentik_policies_expiry.passwordexpirypolicy',
    PoliciesExpressionExpressionpolicy: 'authentik_policies_expression.expressionpolicy',
    PoliciesPasswordPasswordpolicy: 'authentik_policies_password.passwordpolicy',
    PoliciesReputationReputationpolicy: 'authentik_policies_reputation.reputationpolicy',
    ProvidersGoogleWorkspaceGoogleworkspaceprovider: 'authentik_providers_google_workspace.googleworkspaceprovider',
    ProvidersGoogleWorkspaceGoogleworkspaceprovidermapping: 'authentik_providers_google_workspace.googleworkspaceprovidermapping',
    ProvidersLdapLdapprovider: 'authentik_providers_ldap.ldapprovider',
    ProvidersMicrosoftEntraMicrosoftentraprovider: 'authentik_providers_microsoft_entra.microsoftentraprovider',
    ProvidersMicrosoftEntraMicrosoftentraprovidermapping: 'authentik_providers_microsoft_entra.microsoftentraprovidermapping',
    ProvidersOauth2Oauth2provider: 'authentik_providers_oauth2.oauth2provider',
    ProvidersOauth2Scopemapping: 'authentik_providers_oauth2.scopemapping',
    ProvidersProxyProxyprovider: 'authentik_providers_proxy.proxyprovider',
    ProvidersRacEndpoint: 'authentik_providers_rac.endpoint',
    ProvidersRacRacpropertymapping: 'authentik_providers_rac.racpropertymapping',
    ProvidersRacRacprovider: 'authentik_providers_rac.racprovider',
    ProvidersRadiusRadiusprovider: 'authentik_providers_radius.radiusprovider',
    ProvidersSamlSamlpropertymapping: 'authentik_providers_saml.samlpropertymapping',
    ProvidersSamlSamlprovider: 'authentik_providers_saml.samlprovider',
    ProvidersScimScimmapping: 'authentik_providers_scim.scimmapping',
    ProvidersScimScimprovider: 'authentik_providers_scim.scimprovider',
    RbacRole: 'authentik_rbac.role',
    SourcesLdapLdappropertymapping: 'authentik_sources_ldap.ldappropertymapping',
    SourcesLdapLdapsource: 'authentik_sources_ldap.ldapsource',
    SourcesOauthOauthsource: 'authentik_sources_oauth.oauthsource',
    SourcesOauthUseroauthsourceconnection: 'authentik_sources_oauth.useroauthsourceconnection',
    SourcesPlexPlexsource: 'authentik_sources_plex.plexsource',
    SourcesPlexPlexsourceconnection: 'authentik_sources_plex.plexsourceconnection',
    SourcesSamlSamlsource: 'authentik_sources_saml.samlsource',
    SourcesSamlUsersamlsourceconnection: 'authentik_sources_saml.usersamlsourceconnection',
    SourcesScimScimsource: 'authentik_sources_scim.scimsource',
    StagesAuthenticatorDuoAuthenticatorduostage: 'authentik_stages_authenticator_duo.authenticatorduostage',
    StagesAuthenticatorDuoDuodevice: 'authentik_stages_authenticator_duo.duodevice',
    StagesAuthenticatorSmsAuthenticatorsmsstage: 'authentik_stages_authenticator_sms.authenticatorsmsstage',
    StagesAuthenticatorSmsSmsdevice: 'authentik_stages_authenticator_sms.smsdevice',
    StagesAuthenticatorStaticAuthenticatorstaticstage: 'authentik_stages_authenticator_static.authenticatorstaticstage',
    StagesAuthenticatorStaticStaticdevice: 'authentik_stages_authenticator_static.staticdevice',
    StagesAuthenticatorTotpAuthenticatortotpstage: 'authentik_stages_authenticator_totp.authenticatortotpstage',
    StagesAuthenticatorTotpTotpdevice: 'authentik_stages_authenticator_totp.totpdevice',
    StagesAuthenticatorValidateAuthenticatorvalidatestage: 'authentik_stages_authenticator_validate.authenticatorvalidatestage',
    StagesAuthenticatorWebauthnAuthenticatorwebauthnstage: 'authentik_stages_authenticator_webauthn.authenticatorwebauthnstage',
    StagesAuthenticatorWebauthnWebauthndevice: 'authentik_stages_authenticator_webauthn.webauthndevice',
    StagesCaptchaCaptchastage: 'authentik_stages_captcha.captchastage',
    StagesConsentConsentstage: 'authentik_stages_consent.consentstage',
    StagesConsentUserconsent: 'authentik_stages_consent.userconsent',
    StagesDenyDenystage: 'authentik_stages_deny.denystage',
    StagesDummyDummystage: 'authentik_stages_dummy.dummystage',
    StagesEmailEmailstage: 'authentik_stages_email.emailstage',
    StagesIdentificationIdentificationstage: 'authentik_stages_identification.identificationstage',
    StagesInvitationInvitation: 'authentik_stages_invitation.invitation',
    StagesInvitationInvitationstage: 'authentik_stages_invitation.invitationstage',
    StagesPasswordPasswordstage: 'authentik_stages_password.passwordstage',
    StagesPromptPrompt: 'authentik_stages_prompt.prompt',
    StagesPromptPromptstage: 'authentik_stages_prompt.promptstage',
    StagesSourceSourcestage: 'authentik_stages_source.sourcestage',
    StagesUserDeleteUserdeletestage: 'authentik_stages_user_delete.userdeletestage',
    StagesUserLoginUserloginstage: 'authentik_stages_user_login.userloginstage',
    StagesUserLogoutUserlogoutstage: 'authentik_stages_user_logout.userlogoutstage',
    StagesUserWriteUserwritestage: 'authentik_stages_user_write.userwritestage',
    TenantsDomain: 'authentik_tenants.domain',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type RbacPermissionsAssignedByRolesListModelEnum = typeof RbacPermissionsAssignedByRolesListModelEnum[keyof typeof RbacPermissionsAssignedByRolesListModelEnum];
/**
 * @export
 */
export const RbacPermissionsAssignedByUsersListModelEnum = {
    BlueprintsBlueprintinstance: 'authentik_blueprints.blueprintinstance',
    BrandsBrand: 'authentik_brands.brand',
    CoreApplication: 'authentik_core.application',
    CoreGroup: 'authentik_core.group',
    CoreToken: 'authentik_core.token',
    CoreUser: 'authentik_core.user',
    CryptoCertificatekeypair: 'authentik_crypto.certificatekeypair',
    EnterpriseLicense: 'authentik_enterprise.license',
    EventsEvent: 'authentik_events.event',
    EventsNotification: 'authentik_events.notification',
    EventsNotificationrule: 'authentik_events.notificationrule',
    EventsNotificationtransport: 'authentik_events.notificationtransport',
    EventsNotificationwebhookmapping: 'authentik_events.notificationwebhookmapping',
    FlowsFlow: 'authentik_flows.flow',
    FlowsFlowstagebinding: 'authentik_flows.flowstagebinding',
    OutpostsDockerserviceconnection: 'authentik_outposts.dockerserviceconnection',
    OutpostsKubernetesserviceconnection: 'authentik_outposts.kubernetesserviceconnection',
    OutpostsOutpost: 'authentik_outposts.outpost',
    PoliciesPolicybinding: 'authentik_policies.policybinding',
    PoliciesDummyDummypolicy: 'authentik_policies_dummy.dummypolicy',
    PoliciesEventMatcherEventmatcherpolicy: 'authentik_policies_event_matcher.eventmatcherpolicy',
    PoliciesExpiryPasswordexpirypolicy: 'authentik_policies_expiry.passwordexpirypolicy',
    PoliciesExpressionExpressionpolicy: 'authentik_policies_expression.expressionpolicy',
    PoliciesPasswordPasswordpolicy: 'authentik_policies_password.passwordpolicy',
    PoliciesReputationReputationpolicy: 'authentik_policies_reputation.reputationpolicy',
    ProvidersGoogleWorkspaceGoogleworkspaceprovider: 'authentik_providers_google_workspace.googleworkspaceprovider',
    ProvidersGoogleWorkspaceGoogleworkspaceprovidermapping: 'authentik_providers_google_workspace.googleworkspaceprovidermapping',
    ProvidersLdapLdapprovider: 'authentik_providers_ldap.ldapprovider',
    ProvidersMicrosoftEntraMicrosoftentraprovider: 'authentik_providers_microsoft_entra.microsoftentraprovider',
    ProvidersMicrosoftEntraMicrosoftentraprovidermapping: 'authentik_providers_microsoft_entra.microsoftentraprovidermapping',
    ProvidersOauth2Oauth2provider: 'authentik_providers_oauth2.oauth2provider',
    ProvidersOauth2Scopemapping: 'authentik_providers_oauth2.scopemapping',
    ProvidersProxyProxyprovider: 'authentik_providers_proxy.proxyprovider',
    ProvidersRacEndpoint: 'authentik_providers_rac.endpoint',
    ProvidersRacRacpropertymapping: 'authentik_providers_rac.racpropertymapping',
    ProvidersRacRacprovider: 'authentik_providers_rac.racprovider',
    ProvidersRadiusRadiusprovider: 'authentik_providers_radius.radiusprovider',
    ProvidersSamlSamlpropertymapping: 'authentik_providers_saml.samlpropertymapping',
    ProvidersSamlSamlprovider: 'authentik_providers_saml.samlprovider',
    ProvidersScimScimmapping: 'authentik_providers_scim.scimmapping',
    ProvidersScimScimprovider: 'authentik_providers_scim.scimprovider',
    RbacRole: 'authentik_rbac.role',
    SourcesLdapLdappropertymapping: 'authentik_sources_ldap.ldappropertymapping',
    SourcesLdapLdapsource: 'authentik_sources_ldap.ldapsource',
    SourcesOauthOauthsource: 'authentik_sources_oauth.oauthsource',
    SourcesOauthUseroauthsourceconnection: 'authentik_sources_oauth.useroauthsourceconnection',
    SourcesPlexPlexsource: 'authentik_sources_plex.plexsource',
    SourcesPlexPlexsourceconnection: 'authentik_sources_plex.plexsourceconnection',
    SourcesSamlSamlsource: 'authentik_sources_saml.samlsource',
    SourcesSamlUsersamlsourceconnection: 'authentik_sources_saml.usersamlsourceconnection',
    SourcesScimScimsource: 'authentik_sources_scim.scimsource',
    StagesAuthenticatorDuoAuthenticatorduostage: 'authentik_stages_authenticator_duo.authenticatorduostage',
    StagesAuthenticatorDuoDuodevice: 'authentik_stages_authenticator_duo.duodevice',
    StagesAuthenticatorSmsAuthenticatorsmsstage: 'authentik_stages_authenticator_sms.authenticatorsmsstage',
    StagesAuthenticatorSmsSmsdevice: 'authentik_stages_authenticator_sms.smsdevice',
    StagesAuthenticatorStaticAuthenticatorstaticstage: 'authentik_stages_authenticator_static.authenticatorstaticstage',
    StagesAuthenticatorStaticStaticdevice: 'authentik_stages_authenticator_static.staticdevice',
    StagesAuthenticatorTotpAuthenticatortotpstage: 'authentik_stages_authenticator_totp.authenticatortotpstage',
    StagesAuthenticatorTotpTotpdevice: 'authentik_stages_authenticator_totp.totpdevice',
    StagesAuthenticatorValidateAuthenticatorvalidatestage: 'authentik_stages_authenticator_validate.authenticatorvalidatestage',
    StagesAuthenticatorWebauthnAuthenticatorwebauthnstage: 'authentik_stages_authenticator_webauthn.authenticatorwebauthnstage',
    StagesAuthenticatorWebauthnWebauthndevice: 'authentik_stages_authenticator_webauthn.webauthndevice',
    StagesCaptchaCaptchastage: 'authentik_stages_captcha.captchastage',
    StagesConsentConsentstage: 'authentik_stages_consent.consentstage',
    StagesConsentUserconsent: 'authentik_stages_consent.userconsent',
    StagesDenyDenystage: 'authentik_stages_deny.denystage',
    StagesDummyDummystage: 'authentik_stages_dummy.dummystage',
    StagesEmailEmailstage: 'authentik_stages_email.emailstage',
    StagesIdentificationIdentificationstage: 'authentik_stages_identification.identificationstage',
    StagesInvitationInvitation: 'authentik_stages_invitation.invitation',
    StagesInvitationInvitationstage: 'authentik_stages_invitation.invitationstage',
    StagesPasswordPasswordstage: 'authentik_stages_password.passwordstage',
    StagesPromptPrompt: 'authentik_stages_prompt.prompt',
    StagesPromptPromptstage: 'authentik_stages_prompt.promptstage',
    StagesSourceSourcestage: 'authentik_stages_source.sourcestage',
    StagesUserDeleteUserdeletestage: 'authentik_stages_user_delete.userdeletestage',
    StagesUserLoginUserloginstage: 'authentik_stages_user_login.userloginstage',
    StagesUserLogoutUserlogoutstage: 'authentik_stages_user_logout.userlogoutstage',
    StagesUserWriteUserwritestage: 'authentik_stages_user_write.userwritestage',
    TenantsDomain: 'authentik_tenants.domain',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type RbacPermissionsAssignedByUsersListModelEnum = typeof RbacPermissionsAssignedByUsersListModelEnum[keyof typeof RbacPermissionsAssignedByUsersListModelEnum];
