"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnterpriseApi = void 0;
const runtime = require("../runtime");
const models_1 = require("../models");
/**
 *
 */
class EnterpriseApi extends runtime.BaseAPI {
    /**
     * License Viewset
     */
    enterpriseLicenseCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.licenseRequest === null || requestParameters.licenseRequest === undefined) {
                throw new runtime.RequiredError('licenseRequest', 'Required parameter requestParameters.licenseRequest was null or undefined when calling enterpriseLicenseCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.LicenseRequestToJSON)(requestParameters.licenseRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LicenseFromJSON)(jsonValue));
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
                throw new runtime.RequiredError('licenseUuid', 'Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.enterpriseLicenseDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Forecast how many users will be required in a year
     */
    enterpriseLicenseForecastRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/forecast/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LicenseForecastFromJSON)(jsonValue));
        });
    }
    /**
     * Forecast how many users will be required in a year
     */
    enterpriseLicenseForecastRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseForecastRetrieveRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get install_id
     */
    enterpriseLicenseGetInstallIdRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/get_install_id/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InstallIDFromJSON)(jsonValue));
        });
    }
    /**
     * Get install_id
     */
    enterpriseLicenseGetInstallIdRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseGetInstallIdRetrieveRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedLicenseListFromJSON)(jsonValue));
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicensePartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
                throw new runtime.RequiredError('licenseUuid', 'Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicensePartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedLicenseRequestToJSON)(requestParameters.patchedLicenseRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LicenseFromJSON)(jsonValue));
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicensePartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicensePartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
                throw new runtime.RequiredError('licenseUuid', 'Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LicenseFromJSON)(jsonValue));
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get the total license status
     */
    enterpriseLicenseSummaryRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/summary/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LicenseSummaryFromJSON)(jsonValue));
        });
    }
    /**
     * Get the total license status
     */
    enterpriseLicenseSummaryRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseSummaryRetrieveRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
                throw new runtime.RequiredError('licenseUuid', 'Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseUpdate.');
            }
            if (requestParameters.licenseRequest === null || requestParameters.licenseRequest === undefined) {
                throw new runtime.RequiredError('licenseRequest', 'Required parameter requestParameters.licenseRequest was null or undefined when calling enterpriseLicenseUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/{license_uuid}/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.LicenseRequestToJSON)(requestParameters.licenseRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.LicenseFromJSON)(jsonValue));
        });
    }
    /**
     * License Viewset
     */
    enterpriseLicenseUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    enterpriseLicenseUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.licenseUuid === null || requestParameters.licenseUuid === undefined) {
                throw new runtime.RequiredError('licenseUuid', 'Required parameter requestParameters.licenseUuid was null or undefined when calling enterpriseLicenseUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/enterprise/license/{license_uuid}/used_by/`.replace(`{${"license_uuid"}}`, encodeURIComponent(String(requestParameters.licenseUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    enterpriseLicenseUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.enterpriseLicenseUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
}
exports.EnterpriseApi = EnterpriseApi;
