"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticatorsApi = void 0;
const runtime = require("../runtime");
const models_1 = require("../models");
/**
 *
 */
class AuthenticatorsApi extends runtime.BaseAPI {
    /**
     * Get all devices for current user
     */
    authenticatorsAdminAllListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.user !== undefined) {
                queryParameters['user'] = requestParameters.user;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/all/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.DeviceFromJSON));
        });
    }
    /**
     * Get all devices for current user
     */
    authenticatorsAdminAllList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminAllListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.duoDeviceRequest === null || requestParameters.duoDeviceRequest === undefined) {
                throw new runtime.RequiredError('duoDeviceRequest', 'Required parameter requestParameters.duoDeviceRequest was null or undefined when calling authenticatorsAdminDuoCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/duo/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DuoDeviceRequestToJSON)(requestParameters.duoDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminDuoCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsAdminDuoDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/duo/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedDuoDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminDuoListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedDuoDeviceRequestToJSON)(requestParameters.patchedDuoDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminDuoPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminDuoRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminDuoUpdate.');
            }
            if (requestParameters.duoDeviceRequest === null || requestParameters.duoDeviceRequest === undefined) {
                throw new runtime.RequiredError('duoDeviceRequest', 'Required parameter requestParameters.duoDeviceRequest was null or undefined when calling authenticatorsAdminDuoUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DuoDeviceRequestToJSON)(requestParameters.duoDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices (for admins)
     */
    authenticatorsAdminDuoUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminDuoUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.sMSDeviceRequest === null || requestParameters.sMSDeviceRequest === undefined) {
                throw new runtime.RequiredError('sMSDeviceRequest', 'Required parameter requestParameters.sMSDeviceRequest was null or undefined when calling authenticatorsAdminSmsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/sms/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SMSDeviceRequestToJSON)(requestParameters.sMSDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminSmsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsAdminSmsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/sms/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSMSDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminSmsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSMSDeviceRequestToJSON)(requestParameters.patchedSMSDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminSmsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminSmsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminSmsUpdate.');
            }
            if (requestParameters.sMSDeviceRequest === null || requestParameters.sMSDeviceRequest === undefined) {
                throw new runtime.RequiredError('sMSDeviceRequest', 'Required parameter requestParameters.sMSDeviceRequest was null or undefined when calling authenticatorsAdminSmsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SMSDeviceRequestToJSON)(requestParameters.sMSDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices (for admins)
     */
    authenticatorsAdminSmsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminSmsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.staticDeviceRequest === null || requestParameters.staticDeviceRequest === undefined) {
                throw new runtime.RequiredError('staticDeviceRequest', 'Required parameter requestParameters.staticDeviceRequest was null or undefined when calling authenticatorsAdminStaticCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/static/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.StaticDeviceRequestToJSON)(requestParameters.staticDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminStaticCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsAdminStaticDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/static/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedStaticDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminStaticListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedStaticDeviceRequestToJSON)(requestParameters.patchedStaticDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminStaticPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminStaticRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminStaticUpdate.');
            }
            if (requestParameters.staticDeviceRequest === null || requestParameters.staticDeviceRequest === undefined) {
                throw new runtime.RequiredError('staticDeviceRequest', 'Required parameter requestParameters.staticDeviceRequest was null or undefined when calling authenticatorsAdminStaticUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.StaticDeviceRequestToJSON)(requestParameters.staticDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices (for admins)
     */
    authenticatorsAdminStaticUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminStaticUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.tOTPDeviceRequest === null || requestParameters.tOTPDeviceRequest === undefined) {
                throw new runtime.RequiredError('tOTPDeviceRequest', 'Required parameter requestParameters.tOTPDeviceRequest was null or undefined when calling authenticatorsAdminTotpCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/totp/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TOTPDeviceRequestToJSON)(requestParameters.tOTPDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminTotpCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsAdminTotpDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/totp/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedTOTPDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminTotpListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedTOTPDeviceRequestToJSON)(requestParameters.patchedTOTPDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminTotpPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminTotpRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminTotpUpdate.');
            }
            if (requestParameters.tOTPDeviceRequest === null || requestParameters.tOTPDeviceRequest === undefined) {
                throw new runtime.RequiredError('tOTPDeviceRequest', 'Required parameter requestParameters.tOTPDeviceRequest was null or undefined when calling authenticatorsAdminTotpUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TOTPDeviceRequestToJSON)(requestParameters.tOTPDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices (for admins)
     */
    authenticatorsAdminTotpUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminTotpUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.webAuthnDeviceRequest === null || requestParameters.webAuthnDeviceRequest === undefined) {
                throw new runtime.RequiredError('webAuthnDeviceRequest', 'Required parameter requestParameters.webAuthnDeviceRequest was null or undefined when calling authenticatorsAdminWebauthnCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/webauthn/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.WebAuthnDeviceRequestToJSON)(requestParameters.webAuthnDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminWebauthnCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsAdminWebauthnDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/webauthn/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedWebAuthnDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminWebauthnListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedWebAuthnDeviceRequestToJSON)(requestParameters.patchedWebAuthnDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminWebauthnPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminWebauthnRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsAdminWebauthnUpdate.');
            }
            if (requestParameters.webAuthnDeviceRequest === null || requestParameters.webAuthnDeviceRequest === undefined) {
                throw new runtime.RequiredError('webAuthnDeviceRequest', 'Required parameter requestParameters.webAuthnDeviceRequest was null or undefined when calling authenticatorsAdminWebauthnUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/admin/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.WebAuthnDeviceRequestToJSON)(requestParameters.webAuthnDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices (for admins)
     */
    authenticatorsAdminWebauthnUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAdminWebauthnUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all devices for current user
     */
    authenticatorsAllListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/all/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.DeviceFromJSON));
        });
    }
    /**
     * Get all devices for current user
     */
    authenticatorsAllList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsAllListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsDuoDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/duo/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedDuoDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsDuoListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedDuoDeviceRequestToJSON)(requestParameters.patchedDuoDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsDuoPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsDuoRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoUpdate.');
            }
            if (requestParameters.duoDeviceRequest === null || requestParameters.duoDeviceRequest === undefined) {
                throw new runtime.RequiredError('duoDeviceRequest', 'Required parameter requestParameters.duoDeviceRequest was null or undefined when calling authenticatorsDuoUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/duo/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DuoDeviceRequestToJSON)(requestParameters.duoDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for Duo authenticator devices
     */
    authenticatorsDuoUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsDuoUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsDuoUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsDuoUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/duo/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsDuoUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsDuoUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsSmsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/sms/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSMSDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsSmsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSMSDeviceRequestToJSON)(requestParameters.patchedSMSDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsSmsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsSmsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsUpdate.');
            }
            if (requestParameters.sMSDeviceRequest === null || requestParameters.sMSDeviceRequest === undefined) {
                throw new runtime.RequiredError('sMSDeviceRequest', 'Required parameter requestParameters.sMSDeviceRequest was null or undefined when calling authenticatorsSmsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/sms/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SMSDeviceRequestToJSON)(requestParameters.sMSDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SMSDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for sms authenticator devices
     */
    authenticatorsSmsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsSmsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsSmsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsSmsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/sms/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsSmsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsSmsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsStaticDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/static/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedStaticDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsStaticListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedStaticDeviceRequestToJSON)(requestParameters.patchedStaticDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsStaticPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsStaticRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticUpdate.');
            }
            if (requestParameters.staticDeviceRequest === null || requestParameters.staticDeviceRequest === undefined) {
                throw new runtime.RequiredError('staticDeviceRequest', 'Required parameter requestParameters.staticDeviceRequest was null or undefined when calling authenticatorsStaticUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/static/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.StaticDeviceRequestToJSON)(requestParameters.staticDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StaticDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for static authenticator devices
     */
    authenticatorsStaticUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsStaticUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsStaticUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsStaticUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/static/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsStaticUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsStaticUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsTotpDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/totp/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedTOTPDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsTotpListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedTOTPDeviceRequestToJSON)(requestParameters.patchedTOTPDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsTotpPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsTotpRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpUpdate.');
            }
            if (requestParameters.tOTPDeviceRequest === null || requestParameters.tOTPDeviceRequest === undefined) {
                throw new runtime.RequiredError('tOTPDeviceRequest', 'Required parameter requestParameters.tOTPDeviceRequest was null or undefined when calling authenticatorsTotpUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/totp/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.TOTPDeviceRequestToJSON)(requestParameters.tOTPDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.TOTPDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for totp authenticator devices
     */
    authenticatorsTotpUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsTotpUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsTotpUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsTotpUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/totp/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsTotpUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsTotpUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.authenticatorsWebauthnDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/webauthn/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedWebAuthnDeviceListFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsWebauthnListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedWebAuthnDeviceRequestToJSON)(requestParameters.patchedWebAuthnDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsWebauthnPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsWebauthnRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnUpdate.');
            }
            if (requestParameters.webAuthnDeviceRequest === null || requestParameters.webAuthnDeviceRequest === undefined) {
                throw new runtime.RequiredError('webAuthnDeviceRequest', 'Required parameter requestParameters.webAuthnDeviceRequest was null or undefined when calling authenticatorsWebauthnUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/webauthn/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.WebAuthnDeviceRequestToJSON)(requestParameters.webAuthnDeviceRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceFromJSON)(jsonValue));
        });
    }
    /**
     * Viewset for WebAuthn authenticator devices
     */
    authenticatorsWebauthnUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsWebauthnUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsWebauthnUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.id === null || requestParameters.id === undefined) {
                throw new runtime.RequiredError('id', 'Required parameter requestParameters.id was null or undefined when calling authenticatorsWebauthnUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/authenticators/webauthn/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    authenticatorsWebauthnUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.authenticatorsWebauthnUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
}
exports.AuthenticatorsApi = AuthenticatorsApi;
