{"content":"Create a middleware:\n\n```yaml\napiVersion: traefik.io/v1alpha1\nkind: Middleware\nmetadata:\n    name: authentik\nspec:\n    forwardAuth:\n        # This address should point to the cluster endpoint provided by the kubernetes service, not the Ingress.\n        address: http://outpost.company:9000/outpost.goauthentik.io/auth/traefik\n        trustForwardHeader: true\n        authResponseHeaders:\n            - X-authentik-username\n            - X-authentik-groups\n            - X-authentik-entitlements\n            - X-authentik-email\n            - X-authentik-name\n            - X-authentik-uid\n            - X-authentik-jwt\n            - X-authentik-meta-jwks\n            - X-authentik-meta-outpost\n            - X-authentik-meta-provider\n            - X-authentik-meta-app\n            - X-authentik-meta-version\n```\n\n:::info\nTraefik changed the apiVersion of the middleware CRD in version 3.0, for older versions please subsititue \"apiVersion: traefik.containo.us/v1alpha1\"\n:::\n\nAdd the following settings to your IngressRoute\n\nBy default traefik does not allow cross-namespace references for middlewares:\n\nSee [here](https://doc.traefik.io/traefik/v2.4/providers/kubernetes-crd/#allowcrossnamespace) to enable it.\n\n```yaml\nspec:\n    routes:\n        - kind: Rule\n          match: \"Host(`app.company`)\"\n          middlewares:\n              - name: authentik\n                namespace: authentik\n          priority: 10\n          services: # Unchanged\n        # This part is only required for single-app setups\n        - kind: Rule\n          match: \"Host(`app.company`) && PathPrefix(`/outpost.goauthentik.io/`)\"\n          priority: 15\n          services:\n              - kind: Service\n                # Or, to use an external Outpost, create an ExternalName service and reference that here.\n                # See https://kubernetes.io/docs/concepts/services-networking/service/#externalname\n                name: ak-outpost-example-outpost\n                port: 9000\n```\n","publicPath":"/docs/add-secure-apps/providers/proxy/_traefik_ingress.md","publicDirectory":"/docs/add-secure-apps/providers/proxy"}