/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import {
    DigestAlgorithmEnumFromJSON,
    DigestAlgorithmEnumFromJSONTyped,
    DigestAlgorithmEnumToJSON,
} from './DigestAlgorithmEnum';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import {
    SignatureAlgorithmEnumFromJSON,
    SignatureAlgorithmEnumFromJSONTyped,
    SignatureAlgorithmEnumToJSON,
} from './SignatureAlgorithmEnum';
import type { SpBindingEnum } from './SpBindingEnum';
import {
    SpBindingEnumFromJSON,
    SpBindingEnumFromJSONTyped,
    SpBindingEnumToJSON,
} from './SpBindingEnum';

/**
 * SAMLProvider Serializer
 * @export
 * @interface SAMLProviderRequest
 */
export interface SAMLProviderRequest {
    /**
     * 
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    authorizationFlow: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof SAMLProviderRequest
     */
    propertyMappings?: Array<string>;
    /**
     * 
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    acsUrl: string;
    /**
     * Value of the audience restriction field of the assertion. When left empty, no audience restriction will be added.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    audience?: string;
    /**
     * Also known as EntityID
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    issuer?: string;
    /**
     * Assertion valid not before current time + this value (Format: hours=-1;minutes=-2;seconds=-3).
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    assertionValidNotBefore?: string;
    /**
     * Assertion not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    assertionValidNotOnOrAfter?: string;
    /**
     * Session not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    sessionValidNotOnOrAfter?: string;
    /**
     * Configure how the NameID value will be created. When left empty, the NameIDPolicy of the incoming request will be considered
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    nameIdMapping?: string | null;
    /**
     * 
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLProviderRequest
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     * 
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLProviderRequest
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Keypair used to sign outgoing Responses going to the Service Provider.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    signingKp?: string | null;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    verificationKp?: string | null;
    /**
     * 
     * @type {SpBindingEnum}
     * @memberof SAMLProviderRequest
     */
    spBinding?: SpBindingEnum;
    /**
     * Default relay_state value for IDP-initiated logins
     * @type {string}
     * @memberof SAMLProviderRequest
     */
    defaultRelayState?: string;
}

/**
 * Check if a given object implements the SAMLProviderRequest interface.
 */
export function instanceOfSAMLProviderRequest(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "authorizationFlow" in value;
    isInstance = isInstance && "acsUrl" in value;

    return isInstance;
}

export function SAMLProviderRequestFromJSON(json: any): SAMLProviderRequest {
    return SAMLProviderRequestFromJSONTyped(json, false);
}

export function SAMLProviderRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLProviderRequest {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'name': json['name'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'authorizationFlow': json['authorization_flow'],
        'propertyMappings': !exists(json, 'property_mappings') ? undefined : json['property_mappings'],
        'acsUrl': json['acs_url'],
        'audience': !exists(json, 'audience') ? undefined : json['audience'],
        'issuer': !exists(json, 'issuer') ? undefined : json['issuer'],
        'assertionValidNotBefore': !exists(json, 'assertion_valid_not_before') ? undefined : json['assertion_valid_not_before'],
        'assertionValidNotOnOrAfter': !exists(json, 'assertion_valid_not_on_or_after') ? undefined : json['assertion_valid_not_on_or_after'],
        'sessionValidNotOnOrAfter': !exists(json, 'session_valid_not_on_or_after') ? undefined : json['session_valid_not_on_or_after'],
        'nameIdMapping': !exists(json, 'name_id_mapping') ? undefined : json['name_id_mapping'],
        'digestAlgorithm': !exists(json, 'digest_algorithm') ? undefined : DigestAlgorithmEnumFromJSON(json['digest_algorithm']),
        'signatureAlgorithm': !exists(json, 'signature_algorithm') ? undefined : SignatureAlgorithmEnumFromJSON(json['signature_algorithm']),
        'signingKp': !exists(json, 'signing_kp') ? undefined : json['signing_kp'],
        'verificationKp': !exists(json, 'verification_kp') ? undefined : json['verification_kp'],
        'spBinding': !exists(json, 'sp_binding') ? undefined : SpBindingEnumFromJSON(json['sp_binding']),
        'defaultRelayState': !exists(json, 'default_relay_state') ? undefined : json['default_relay_state'],
    };
}

export function SAMLProviderRequestToJSON(value?: SAMLProviderRequest | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'authentication_flow': value.authenticationFlow,
        'authorization_flow': value.authorizationFlow,
        'property_mappings': value.propertyMappings,
        'acs_url': value.acsUrl,
        'audience': value.audience,
        'issuer': value.issuer,
        'assertion_valid_not_before': value.assertionValidNotBefore,
        'assertion_valid_not_on_or_after': value.assertionValidNotOnOrAfter,
        'session_valid_not_on_or_after': value.sessionValidNotOnOrAfter,
        'name_id_mapping': value.nameIdMapping,
        'digest_algorithm': DigestAlgorithmEnumToJSON(value.digestAlgorithm),
        'signature_algorithm': SignatureAlgorithmEnumToJSON(value.signatureAlgorithm),
        'signing_kp': value.signingKp,
        'verification_kp': value.verificationKp,
        'sp_binding': SpBindingEnumToJSON(value.spBinding),
        'default_relay_state': value.defaultRelayState,
    };
}

