/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { ProxyMode } from './ProxyMode';
import {
    ProxyModeFromJSON,
    ProxyModeFromJSONTyped,
    ProxyModeToJSON,
} from './ProxyMode';

/**
 * ProxyProvider Serializer
 * @export
 * @interface ProxyProviderRequest
 */
export interface ProxyProviderRequest {
    /**
     * 
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    authorizationFlow: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof ProxyProviderRequest
     */
    propertyMappings?: Array<string>;
    /**
     * 
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    internalHost?: string;
    /**
     * 
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    externalHost: string;
    /**
     * Validate SSL Certificates of upstream servers
     * @type {boolean}
     * @memberof ProxyProviderRequest
     */
    internalHostSslValidation?: boolean;
    /**
     * 
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    certificate?: string | null;
    /**
     * Regular expressions for which authentication is not required. Each new line is interpreted as a new Regular Expression.
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    skipPathRegex?: string;
    /**
     * Set a custom HTTP-Basic Authentication header based on values from authentik.
     * @type {boolean}
     * @memberof ProxyProviderRequest
     */
    basicAuthEnabled?: boolean;
    /**
     * User/Group Attribute used for the password part of the HTTP-Basic Header.
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    basicAuthPasswordAttribute?: string;
    /**
     * User/Group Attribute used for the user part of the HTTP-Basic Header. If not set, the user's Email address is used.
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    basicAuthUserAttribute?: string;
    /**
     * 
     * @type {ProxyMode}
     * @memberof ProxyProviderRequest
     */
    mode?: ProxyMode;
    /**
     * When enabled, this provider will intercept the authorization header and authenticate requests based on its value.
     * @type {boolean}
     * @memberof ProxyProviderRequest
     */
    interceptHeaderAuth?: boolean;
    /**
     * 
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    cookieDomain?: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof ProxyProviderRequest
     */
    jwksSources?: Array<string>;
    /**
     * Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    accessTokenValidity?: string;
    /**
     * Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof ProxyProviderRequest
     */
    refreshTokenValidity?: string;
}

/**
 * Check if a given object implements the ProxyProviderRequest interface.
 */
export function instanceOfProxyProviderRequest(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "authorizationFlow" in value;
    isInstance = isInstance && "externalHost" in value;

    return isInstance;
}

export function ProxyProviderRequestFromJSON(json: any): ProxyProviderRequest {
    return ProxyProviderRequestFromJSONTyped(json, false);
}

export function ProxyProviderRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): ProxyProviderRequest {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'name': json['name'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'authorizationFlow': json['authorization_flow'],
        'propertyMappings': !exists(json, 'property_mappings') ? undefined : json['property_mappings'],
        'internalHost': !exists(json, 'internal_host') ? undefined : json['internal_host'],
        'externalHost': json['external_host'],
        'internalHostSslValidation': !exists(json, 'internal_host_ssl_validation') ? undefined : json['internal_host_ssl_validation'],
        'certificate': !exists(json, 'certificate') ? undefined : json['certificate'],
        'skipPathRegex': !exists(json, 'skip_path_regex') ? undefined : json['skip_path_regex'],
        'basicAuthEnabled': !exists(json, 'basic_auth_enabled') ? undefined : json['basic_auth_enabled'],
        'basicAuthPasswordAttribute': !exists(json, 'basic_auth_password_attribute') ? undefined : json['basic_auth_password_attribute'],
        'basicAuthUserAttribute': !exists(json, 'basic_auth_user_attribute') ? undefined : json['basic_auth_user_attribute'],
        'mode': !exists(json, 'mode') ? undefined : ProxyModeFromJSON(json['mode']),
        'interceptHeaderAuth': !exists(json, 'intercept_header_auth') ? undefined : json['intercept_header_auth'],
        'cookieDomain': !exists(json, 'cookie_domain') ? undefined : json['cookie_domain'],
        'jwksSources': !exists(json, 'jwks_sources') ? undefined : json['jwks_sources'],
        'accessTokenValidity': !exists(json, 'access_token_validity') ? undefined : json['access_token_validity'],
        'refreshTokenValidity': !exists(json, 'refresh_token_validity') ? undefined : json['refresh_token_validity'],
    };
}

export function ProxyProviderRequestToJSON(value?: ProxyProviderRequest | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'authentication_flow': value.authenticationFlow,
        'authorization_flow': value.authorizationFlow,
        'property_mappings': value.propertyMappings,
        'internal_host': value.internalHost,
        'external_host': value.externalHost,
        'internal_host_ssl_validation': value.internalHostSslValidation,
        'certificate': value.certificate,
        'skip_path_regex': value.skipPathRegex,
        'basic_auth_enabled': value.basicAuthEnabled,
        'basic_auth_password_attribute': value.basicAuthPasswordAttribute,
        'basic_auth_user_attribute': value.basicAuthUserAttribute,
        'mode': ProxyModeToJSON(value.mode),
        'intercept_header_auth': value.interceptHeaderAuth,
        'cookie_domain': value.cookieDomain,
        'jwks_sources': value.jwksSources,
        'access_token_validity': value.accessTokenValidity,
        'refresh_token_validity': value.refreshTokenValidity,
    };
}

