/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { OutpostTypeEnum } from './OutpostTypeEnum';
import {
    OutpostTypeEnumFromJSON,
    OutpostTypeEnumFromJSONTyped,
    OutpostTypeEnumToJSON,
} from './OutpostTypeEnum';
import type { Provider } from './Provider';
import {
    ProviderFromJSON,
    ProviderFromJSONTyped,
    ProviderToJSON,
} from './Provider';
import type { ServiceConnection } from './ServiceConnection';
import {
    ServiceConnectionFromJSON,
    ServiceConnectionFromJSONTyped,
    ServiceConnectionToJSON,
} from './ServiceConnection';

/**
 * Outpost Serializer
 * @export
 * @interface Outpost
 */
export interface Outpost {
    /**
     * 
     * @type {string}
     * @memberof Outpost
     */
    readonly pk: string;
    /**
     * 
     * @type {string}
     * @memberof Outpost
     */
    name: string;
    /**
     * 
     * @type {OutpostTypeEnum}
     * @memberof Outpost
     */
    type: OutpostTypeEnum;
    /**
     * 
     * @type {Array<number>}
     * @memberof Outpost
     */
    providers: Array<number>;
    /**
     * 
     * @type {Array<Provider>}
     * @memberof Outpost
     */
    readonly providersObj: Array<Provider>;
    /**
     * Select Service-Connection authentik should use to manage this outpost. Leave empty if authentik should not handle the deployment.
     * @type {string}
     * @memberof Outpost
     */
    serviceConnection?: string | null;
    /**
     * 
     * @type {ServiceConnection}
     * @memberof Outpost
     */
    readonly serviceConnectionObj: ServiceConnection;
    /**
     * 
     * @type {number}
     * @memberof Outpost
     */
    readonly refreshIntervalS: number;
    /**
     * Get Token identifier
     * @type {string}
     * @memberof Outpost
     */
    readonly tokenIdentifier: string;
    /**
     * 
     * @type {{ [key: string]: any; }}
     * @memberof Outpost
     */
    config: { [key: string]: any; };
    /**
     * Objects that are managed by authentik. These objects are created and updated automatically. This flag only indicates that an object can be overwritten by migrations. You can still modify the objects via the API, but expect changes to be overwritten in a later update.
     * @type {string}
     * @memberof Outpost
     */
    managed?: string | null;
}

/**
 * Check if a given object implements the Outpost interface.
 */
export function instanceOfOutpost(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "type" in value;
    isInstance = isInstance && "providers" in value;
    isInstance = isInstance && "providersObj" in value;
    isInstance = isInstance && "serviceConnectionObj" in value;
    isInstance = isInstance && "refreshIntervalS" in value;
    isInstance = isInstance && "tokenIdentifier" in value;
    isInstance = isInstance && "config" in value;

    return isInstance;
}

export function OutpostFromJSON(json: any): Outpost {
    return OutpostFromJSONTyped(json, false);
}

export function OutpostFromJSONTyped(json: any, ignoreDiscriminator: boolean): Outpost {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'name': json['name'],
        'type': OutpostTypeEnumFromJSON(json['type']),
        'providers': json['providers'],
        'providersObj': ((json['providers_obj'] as Array<any>).map(ProviderFromJSON)),
        'serviceConnection': !exists(json, 'service_connection') ? undefined : json['service_connection'],
        'serviceConnectionObj': ServiceConnectionFromJSON(json['service_connection_obj']),
        'refreshIntervalS': json['refresh_interval_s'],
        'tokenIdentifier': json['token_identifier'],
        'config': json['config'],
        'managed': !exists(json, 'managed') ? undefined : json['managed'],
    };
}

export function OutpostToJSON(value?: Outpost | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'type': OutpostTypeEnumToJSON(value.type),
        'providers': value.providers,
        'service_connection': value.serviceConnection,
        'config': value.config,
        'managed': value.managed,
    };
}

