/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { LDAPAPIAccessMode } from './LDAPAPIAccessMode';
import {
    LDAPAPIAccessModeFromJSON,
    LDAPAPIAccessModeFromJSONTyped,
    LDAPAPIAccessModeToJSON,
} from './LDAPAPIAccessMode';

/**
 * LDAPProvider Serializer
 * @export
 * @interface LDAPProvider
 */
export interface LDAPProvider {
    /**
     * 
     * @type {number}
     * @memberof LDAPProvider
     */
    readonly pk: number;
    /**
     * 
     * @type {string}
     * @memberof LDAPProvider
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof LDAPProvider
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof LDAPProvider
     */
    authorizationFlow: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof LDAPProvider
     */
    propertyMappings?: Array<string>;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly component: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedApplicationName: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedBackchannelApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly assignedBackchannelApplicationName: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof LDAPProvider
     */
    readonly metaModelName: string;
    /**
     * DN under which objects are accessible.
     * @type {string}
     * @memberof LDAPProvider
     */
    baseDn?: string;
    /**
     * Users in this group can do search queries. If not set, every user can execute search queries.
     * @type {string}
     * @memberof LDAPProvider
     */
    searchGroup?: string | null;
    /**
     * 
     * @type {string}
     * @memberof LDAPProvider
     */
    certificate?: string | null;
    /**
     * 
     * @type {string}
     * @memberof LDAPProvider
     */
    tlsServerName?: string;
    /**
     * The start for uidNumbers, this number is added to the user.pk to make sure that the numbers aren't too low for POSIX users. Default is 2000 to ensure that we don't collide with local users uidNumber
     * @type {number}
     * @memberof LDAPProvider
     */
    uidStartNumber?: number;
    /**
     * The start for gidNumbers, this number is added to a number generated from the group.pk to make sure that the numbers aren't too low for POSIX groups. Default is 4000 to ensure that we don't collide with local groups or users primary groups gidNumber
     * @type {number}
     * @memberof LDAPProvider
     */
    gidStartNumber?: number;
    /**
     * 
     * @type {Array<string>}
     * @memberof LDAPProvider
     */
    readonly outpostSet: Array<string>;
    /**
     * 
     * @type {LDAPAPIAccessMode}
     * @memberof LDAPProvider
     */
    searchMode?: LDAPAPIAccessMode;
    /**
     * 
     * @type {LDAPAPIAccessMode}
     * @memberof LDAPProvider
     */
    bindMode?: LDAPAPIAccessMode;
    /**
     * When enabled, code-based multi-factor authentication can be used by appending a semicolon and the TOTP code to the password. This should only be enabled if all users that will bind to this provider have a TOTP device configured, as otherwise a password may incorrectly be rejected if it contains a semicolon.
     * @type {boolean}
     * @memberof LDAPProvider
     */
    mfaSupport?: boolean;
}

/**
 * Check if a given object implements the LDAPProvider interface.
 */
export function instanceOfLDAPProvider(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "authorizationFlow" in value;
    isInstance = isInstance && "component" in value;
    isInstance = isInstance && "assignedApplicationSlug" in value;
    isInstance = isInstance && "assignedApplicationName" in value;
    isInstance = isInstance && "assignedBackchannelApplicationSlug" in value;
    isInstance = isInstance && "assignedBackchannelApplicationName" in value;
    isInstance = isInstance && "verboseName" in value;
    isInstance = isInstance && "verboseNamePlural" in value;
    isInstance = isInstance && "metaModelName" in value;
    isInstance = isInstance && "outpostSet" in value;

    return isInstance;
}

export function LDAPProviderFromJSON(json: any): LDAPProvider {
    return LDAPProviderFromJSONTyped(json, false);
}

export function LDAPProviderFromJSONTyped(json: any, ignoreDiscriminator: boolean): LDAPProvider {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'name': json['name'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'authorizationFlow': json['authorization_flow'],
        'propertyMappings': !exists(json, 'property_mappings') ? undefined : json['property_mappings'],
        'component': json['component'],
        'assignedApplicationSlug': json['assigned_application_slug'],
        'assignedApplicationName': json['assigned_application_name'],
        'assignedBackchannelApplicationSlug': json['assigned_backchannel_application_slug'],
        'assignedBackchannelApplicationName': json['assigned_backchannel_application_name'],
        'verboseName': json['verbose_name'],
        'verboseNamePlural': json['verbose_name_plural'],
        'metaModelName': json['meta_model_name'],
        'baseDn': !exists(json, 'base_dn') ? undefined : json['base_dn'],
        'searchGroup': !exists(json, 'search_group') ? undefined : json['search_group'],
        'certificate': !exists(json, 'certificate') ? undefined : json['certificate'],
        'tlsServerName': !exists(json, 'tls_server_name') ? undefined : json['tls_server_name'],
        'uidStartNumber': !exists(json, 'uid_start_number') ? undefined : json['uid_start_number'],
        'gidStartNumber': !exists(json, 'gid_start_number') ? undefined : json['gid_start_number'],
        'outpostSet': json['outpost_set'],
        'searchMode': !exists(json, 'search_mode') ? undefined : LDAPAPIAccessModeFromJSON(json['search_mode']),
        'bindMode': !exists(json, 'bind_mode') ? undefined : LDAPAPIAccessModeFromJSON(json['bind_mode']),
        'mfaSupport': !exists(json, 'mfa_support') ? undefined : json['mfa_support'],
    };
}

export function LDAPProviderToJSON(value?: LDAPProvider | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'authentication_flow': value.authenticationFlow,
        'authorization_flow': value.authorizationFlow,
        'property_mappings': value.propertyMappings,
        'base_dn': value.baseDn,
        'search_group': value.searchGroup,
        'certificate': value.certificate,
        'tls_server_name': value.tlsServerName,
        'uid_start_number': value.uidStartNumber,
        'gid_start_number': value.gidStartNumber,
        'search_mode': LDAPAPIAccessModeToJSON(value.searchMode),
        'bind_mode': LDAPAPIAccessModeToJSON(value.bindMode),
        'mfa_support': value.mfaSupport,
    };
}

