/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { ProviderTypeEnum } from './ProviderTypeEnum';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * OAuth Source Serializer
 * @export
 * @interface OAuthSourceRequest
 */
export interface OAuthSourceRequest {
    /**
     * Source's display Name.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    slug: string;
    /**
     *
     * @type {boolean}
     * @memberof OAuthSourceRequest
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    enrollmentFlow?: string | null;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof OAuthSourceRequest
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof OAuthSourceRequest
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     *
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    userPathTemplate?: string;
    /**
     *
     * @type {ProviderTypeEnum}
     * @memberof OAuthSourceRequest
     */
    providerType: ProviderTypeEnum;
    /**
     * URL used to request the initial token. This URL is only required for OAuth 1.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    requestTokenUrl?: string | null;
    /**
     * URL the user is redirect to to conest the flow.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    authorizationUrl?: string | null;
    /**
     * URL used by authentik to retrieve tokens.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    accessTokenUrl?: string | null;
    /**
     * URL used by authentik to get user information.
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    profileUrl?: string | null;
    /**
     *
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    consumerKey: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    consumerSecret: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    additionalScopes?: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    oidcWellKnownUrl?: string;
    /**
     *
     * @type {string}
     * @memberof OAuthSourceRequest
     */
    oidcJwksUrl?: string;
    /**
     *
     * @type {any}
     * @memberof OAuthSourceRequest
     */
    oidcJwks?: any | null;
}
/**
 * Check if a given object implements the OAuthSourceRequest interface.
 */
export declare function instanceOfOAuthSourceRequest(value: object): boolean;
export declare function OAuthSourceRequestFromJSON(json: any): OAuthSourceRequest;
export declare function OAuthSourceRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): OAuthSourceRequest;
export declare function OAuthSourceRequestToJSON(value?: OAuthSourceRequest | null): any;
