"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StagesUserWriteListUserTypeEnum = exports.StagesUserWriteListUserCreationModeEnum = exports.StagesUserLoginListNetworkBindingEnum = exports.StagesUserLoginListGeoipBindingEnum = exports.StagesPromptPromptsListTypeEnum = exports.StagesConsentListModeEnum = exports.StagesAuthenticatorWebauthnListUserVerificationEnum = exports.StagesAuthenticatorWebauthnListResidentKeyRequirementEnum = exports.StagesAuthenticatorWebauthnListAuthenticatorAttachmentEnum = exports.StagesAuthenticatorValidateListNotConfiguredActionEnum = exports.StagesAuthenticatorTotpListDigitsEnum = exports.StagesAuthenticatorSmsListProviderEnum = exports.StagesAuthenticatorSmsListAuthTypeEnum = exports.StagesApi = void 0;
const runtime = require("../runtime");
const models_1 = require("../models");
/**
 *
 */
class StagesApi extends runtime.BaseAPI {
    /**
     * Stage Viewset
     */
    stagesAllDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAllDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/all/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Stage Viewset
     */
    stagesAllDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAllDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Stage Viewset
     */
    stagesAllListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/all/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedStageListFromJSON)(jsonValue));
        });
    }
    /**
     * Stage Viewset
     */
    stagesAllList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAllListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Stage Viewset
     */
    stagesAllRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAllRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/all/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.StageFromJSON)(jsonValue));
        });
    }
    /**
     * Stage Viewset
     */
    stagesAllRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAllRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all creatable types
     */
    stagesAllTypesListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/all/types/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.TypeCreateFromJSON));
        });
    }
    /**
     * Get all creatable types
     */
    stagesAllTypesList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAllTypesListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAllUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAllUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/all/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAllUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAllUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all stages the user can configure
     */
    stagesAllUserSettingsListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/all/user_settings/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UserSettingFromJSON));
        });
    }
    /**
     * Get all stages the user can configure
     */
    stagesAllUserSettingsList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAllUserSettingsListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.authenticatorDuoStageRequest === null || requestParameters.authenticatorDuoStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorDuoStageRequest', 'Required parameter requestParameters.authenticatorDuoStageRequest was null or undefined when calling stagesAuthenticatorDuoCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorDuoStageRequestToJSON)(requestParameters.authenticatorDuoStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorDuoStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorDuoDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Check enrollment status of user details in current session
     */
    stagesAuthenticatorDuoEnrollmentStatusCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoEnrollmentStatusCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/enrollment_status/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DuoDeviceEnrollmentStatusFromJSON)(jsonValue));
        });
    }
    /**
     * Check enrollment status of user details in current session
     */
    stagesAuthenticatorDuoEnrollmentStatusCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoEnrollmentStatusCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Import duo devices into authentik
     */
    stagesAuthenticatorDuoImportDeviceManualCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoImportDeviceManualCreate.');
            }
            if (requestParameters.authenticatorDuoStageManualDeviceImportRequest === null || requestParameters.authenticatorDuoStageManualDeviceImportRequest === undefined) {
                throw new runtime.RequiredError('authenticatorDuoStageManualDeviceImportRequest', 'Required parameter requestParameters.authenticatorDuoStageManualDeviceImportRequest was null or undefined when calling stagesAuthenticatorDuoImportDeviceManualCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/import_device_manual/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorDuoStageManualDeviceImportRequestToJSON)(requestParameters.authenticatorDuoStageManualDeviceImportRequest),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Import duo devices into authentik
     */
    stagesAuthenticatorDuoImportDeviceManualCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorDuoImportDeviceManualCreateRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Import duo devices into authentik
     */
    stagesAuthenticatorDuoImportDevicesAutomaticCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoImportDevicesAutomaticCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/import_devices_automatic/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorDuoStageDeviceImportResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Import duo devices into authentik
     */
    stagesAuthenticatorDuoImportDevicesAutomaticCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoImportDevicesAutomaticCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.apiHostname !== undefined) {
                queryParameters['api_hostname'] = requestParameters.apiHostname;
            }
            if (requestParameters.clientId !== undefined) {
                queryParameters['client_id'] = requestParameters.clientId;
            }
            if (requestParameters.configureFlow !== undefined) {
                queryParameters['configure_flow'] = requestParameters.configureFlow;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatorDuoStageListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedAuthenticatorDuoStageRequestToJSON)(requestParameters.patchedAuthenticatorDuoStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorDuoStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorDuoStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoUpdate.');
            }
            if (requestParameters.authenticatorDuoStageRequest === null || requestParameters.authenticatorDuoStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorDuoStageRequest', 'Required parameter requestParameters.authenticatorDuoStageRequest was null or undefined when calling stagesAuthenticatorDuoUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorDuoStageRequestToJSON)(requestParameters.authenticatorDuoStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorDuoStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorDuoStage Viewset
     */
    stagesAuthenticatorDuoUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorDuoUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorDuoUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/duo/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorDuoUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorDuoUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.authenticatorSMSStageRequest === null || requestParameters.authenticatorSMSStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorSMSStageRequest', 'Required parameter requestParameters.authenticatorSMSStageRequest was null or undefined when calling stagesAuthenticatorSmsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorSMSStageRequestToJSON)(requestParameters.authenticatorSMSStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorSMSStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorSmsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorSmsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorSmsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.accountSid !== undefined) {
                queryParameters['account_sid'] = requestParameters.accountSid;
            }
            if (requestParameters.auth !== undefined) {
                queryParameters['auth'] = requestParameters.auth;
            }
            if (requestParameters.authPassword !== undefined) {
                queryParameters['auth_password'] = requestParameters.authPassword;
            }
            if (requestParameters.authType !== undefined) {
                queryParameters['auth_type'] = requestParameters.authType;
            }
            if (requestParameters.configureFlow !== undefined) {
                queryParameters['configure_flow'] = requestParameters.configureFlow;
            }
            if (requestParameters.friendlyName !== undefined) {
                queryParameters['friendly_name'] = requestParameters.friendlyName;
            }
            if (requestParameters.fromNumber !== undefined) {
                queryParameters['from_number'] = requestParameters.fromNumber;
            }
            if (requestParameters.mapping !== undefined) {
                queryParameters['mapping'] = requestParameters.mapping;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.provider !== undefined) {
                queryParameters['provider'] = requestParameters.provider;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.verifyOnly !== undefined) {
                queryParameters['verify_only'] = requestParameters.verifyOnly;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatorSMSStageListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorSmsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorSmsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedAuthenticatorSMSStageRequestToJSON)(requestParameters.patchedAuthenticatorSMSStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorSMSStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorSmsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorSmsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorSMSStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorSmsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorSmsUpdate.');
            }
            if (requestParameters.authenticatorSMSStageRequest === null || requestParameters.authenticatorSMSStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorSMSStageRequest', 'Required parameter requestParameters.authenticatorSMSStageRequest was null or undefined when calling stagesAuthenticatorSmsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorSMSStageRequestToJSON)(requestParameters.authenticatorSMSStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorSMSStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorSMSStage Viewset
     */
    stagesAuthenticatorSmsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorSmsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorSmsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorSmsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/sms/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorSmsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorSmsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.authenticatorStaticStageRequest === null || requestParameters.authenticatorStaticStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorStaticStageRequest', 'Required parameter requestParameters.authenticatorStaticStageRequest was null or undefined when calling stagesAuthenticatorStaticCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorStaticStageRequestToJSON)(requestParameters.authenticatorStaticStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorStaticStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorStaticCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorStaticDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorStaticDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.configureFlow !== undefined) {
                queryParameters['configure_flow'] = requestParameters.configureFlow;
            }
            if (requestParameters.friendlyName !== undefined) {
                queryParameters['friendly_name'] = requestParameters.friendlyName;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.tokenCount !== undefined) {
                queryParameters['token_count'] = requestParameters.tokenCount;
            }
            if (requestParameters.tokenLength !== undefined) {
                queryParameters['token_length'] = requestParameters.tokenLength;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatorStaticStageListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorStaticListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorStaticPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedAuthenticatorStaticStageRequestToJSON)(requestParameters.patchedAuthenticatorStaticStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorStaticStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorStaticPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorStaticRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorStaticStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorStaticRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorStaticUpdate.');
            }
            if (requestParameters.authenticatorStaticStageRequest === null || requestParameters.authenticatorStaticStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorStaticStageRequest', 'Required parameter requestParameters.authenticatorStaticStageRequest was null or undefined when calling stagesAuthenticatorStaticUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorStaticStageRequestToJSON)(requestParameters.authenticatorStaticStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorStaticStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorStaticStage Viewset
     */
    stagesAuthenticatorStaticUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorStaticUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorStaticUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorStaticUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/static/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorStaticUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorStaticUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.authenticatorTOTPStageRequest === null || requestParameters.authenticatorTOTPStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorTOTPStageRequest', 'Required parameter requestParameters.authenticatorTOTPStageRequest was null or undefined when calling stagesAuthenticatorTotpCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorTOTPStageRequestToJSON)(requestParameters.authenticatorTOTPStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorTOTPStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorTotpCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorTotpDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorTotpDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.configureFlow !== undefined) {
                queryParameters['configure_flow'] = requestParameters.configureFlow;
            }
            if (requestParameters.digits !== undefined) {
                queryParameters['digits'] = requestParameters.digits;
            }
            if (requestParameters.friendlyName !== undefined) {
                queryParameters['friendly_name'] = requestParameters.friendlyName;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatorTOTPStageListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorTotpListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorTotpPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedAuthenticatorTOTPStageRequestToJSON)(requestParameters.patchedAuthenticatorTOTPStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorTOTPStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorTotpPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorTotpRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorTOTPStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorTotpRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorTotpUpdate.');
            }
            if (requestParameters.authenticatorTOTPStageRequest === null || requestParameters.authenticatorTOTPStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorTOTPStageRequest', 'Required parameter requestParameters.authenticatorTOTPStageRequest was null or undefined when calling stagesAuthenticatorTotpUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorTOTPStageRequestToJSON)(requestParameters.authenticatorTOTPStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorTOTPStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorTOTPStage Viewset
     */
    stagesAuthenticatorTotpUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorTotpUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorTotpUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorTotpUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/totp/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorTotpUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorTotpUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.authenticatorValidateStageRequest === null || requestParameters.authenticatorValidateStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorValidateStageRequest', 'Required parameter requestParameters.authenticatorValidateStageRequest was null or undefined when calling stagesAuthenticatorValidateCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorValidateStageRequestToJSON)(requestParameters.authenticatorValidateStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorValidateStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorValidateCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorValidateDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorValidateDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.configurationStages) {
                queryParameters['configuration_stages'] = requestParameters.configurationStages;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.notConfiguredAction !== undefined) {
                queryParameters['not_configured_action'] = requestParameters.notConfiguredAction;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatorValidateStageListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorValidateListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidatePartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorValidatePartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedAuthenticatorValidateStageRequestToJSON)(requestParameters.patchedAuthenticatorValidateStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorValidateStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidatePartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorValidatePartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorValidateRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorValidateStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorValidateRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorValidateUpdate.');
            }
            if (requestParameters.authenticatorValidateStageRequest === null || requestParameters.authenticatorValidateStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorValidateStageRequest', 'Required parameter requestParameters.authenticatorValidateStageRequest was null or undefined when calling stagesAuthenticatorValidateUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorValidateStageRequestToJSON)(requestParameters.authenticatorValidateStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorValidateStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorValidateStage Viewset
     */
    stagesAuthenticatorValidateUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorValidateUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorValidateUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorValidateUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/validate/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorValidateUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorValidateUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.authenticatorWebAuthnStageRequest === null || requestParameters.authenticatorWebAuthnStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorWebAuthnStageRequest', 'Required parameter requestParameters.authenticatorWebAuthnStageRequest was null or undefined when calling stagesAuthenticatorWebauthnCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorWebAuthnStageRequestToJSON)(requestParameters.authenticatorWebAuthnStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorWebAuthnStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorWebauthnDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesAuthenticatorWebauthnDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * WebAuthnDeviceType Viewset
     */
    stagesAuthenticatorWebauthnDeviceTypesListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.aaguid !== undefined) {
                queryParameters['aaguid'] = requestParameters.aaguid;
            }
            if (requestParameters.description !== undefined) {
                queryParameters['description'] = requestParameters.description;
            }
            if (requestParameters.icon !== undefined) {
                queryParameters['icon'] = requestParameters.icon;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn_device_types/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedWebAuthnDeviceTypeListFromJSON)(jsonValue));
        });
    }
    /**
     * WebAuthnDeviceType Viewset
     */
    stagesAuthenticatorWebauthnDeviceTypesList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnDeviceTypesListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * WebAuthnDeviceType Viewset
     */
    stagesAuthenticatorWebauthnDeviceTypesRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.aaguid === null || requestParameters.aaguid === undefined) {
                throw new runtime.RequiredError('aaguid', 'Required parameter requestParameters.aaguid was null or undefined when calling stagesAuthenticatorWebauthnDeviceTypesRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn_device_types/{aaguid}/`.replace(`{${"aaguid"}}`, encodeURIComponent(String(requestParameters.aaguid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.WebAuthnDeviceTypeFromJSON)(jsonValue));
        });
    }
    /**
     * WebAuthnDeviceType Viewset
     */
    stagesAuthenticatorWebauthnDeviceTypesRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnDeviceTypesRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.authenticatorAttachment !== undefined) {
                queryParameters['authenticator_attachment'] = requestParameters.authenticatorAttachment;
            }
            if (requestParameters.configureFlow !== undefined) {
                queryParameters['configure_flow'] = requestParameters.configureFlow;
            }
            if (requestParameters.deviceTypeRestrictions) {
                queryParameters['device_type_restrictions'] = requestParameters.deviceTypeRestrictions;
            }
            if (requestParameters.friendlyName !== undefined) {
                queryParameters['friendly_name'] = requestParameters.friendlyName;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.residentKeyRequirement !== undefined) {
                queryParameters['resident_key_requirement'] = requestParameters.residentKeyRequirement;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.userVerification !== undefined) {
                queryParameters['user_verification'] = requestParameters.userVerification;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedAuthenticatorWebAuthnStageListFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorWebauthnPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedAuthenticatorWebAuthnStageRequestToJSON)(requestParameters.patchedAuthenticatorWebAuthnStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorWebAuthnStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorWebauthnRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorWebAuthnStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorWebauthnUpdate.');
            }
            if (requestParameters.authenticatorWebAuthnStageRequest === null || requestParameters.authenticatorWebAuthnStageRequest === undefined) {
                throw new runtime.RequiredError('authenticatorWebAuthnStageRequest', 'Required parameter requestParameters.authenticatorWebAuthnStageRequest was null or undefined when calling stagesAuthenticatorWebauthnUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.AuthenticatorWebAuthnStageRequestToJSON)(requestParameters.authenticatorWebAuthnStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.AuthenticatorWebAuthnStageFromJSON)(jsonValue));
        });
    }
    /**
     * AuthenticatorWebAuthnStage Viewset
     */
    stagesAuthenticatorWebauthnUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorWebauthnUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesAuthenticatorWebauthnUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/authenticator/webauthn/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesAuthenticatorWebauthnUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesAuthenticatorWebauthnUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.captchaStageRequest === null || requestParameters.captchaStageRequest === undefined) {
                throw new runtime.RequiredError('captchaStageRequest', 'Required parameter requestParameters.captchaStageRequest was null or undefined when calling stagesCaptchaCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.CaptchaStageRequestToJSON)(requestParameters.captchaStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.CaptchaStageFromJSON)(jsonValue));
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesCaptchaCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesCaptchaDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesCaptchaDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.publicKey !== undefined) {
                queryParameters['public_key'] = requestParameters.publicKey;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedCaptchaStageListFromJSON)(jsonValue));
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesCaptchaListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesCaptchaPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedCaptchaStageRequestToJSON)(requestParameters.patchedCaptchaStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.CaptchaStageFromJSON)(jsonValue));
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesCaptchaPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesCaptchaRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.CaptchaStageFromJSON)(jsonValue));
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesCaptchaRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesCaptchaUpdate.');
            }
            if (requestParameters.captchaStageRequest === null || requestParameters.captchaStageRequest === undefined) {
                throw new runtime.RequiredError('captchaStageRequest', 'Required parameter requestParameters.captchaStageRequest was null or undefined when calling stagesCaptchaUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.CaptchaStageRequestToJSON)(requestParameters.captchaStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.CaptchaStageFromJSON)(jsonValue));
        });
    }
    /**
     * CaptchaStage Viewset
     */
    stagesCaptchaUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesCaptchaUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesCaptchaUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesCaptchaUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/captcha/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesCaptchaUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesCaptchaUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.consentStageRequest === null || requestParameters.consentStageRequest === undefined) {
                throw new runtime.RequiredError('consentStageRequest', 'Required parameter requestParameters.consentStageRequest was null or undefined when calling stagesConsentCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ConsentStageRequestToJSON)(requestParameters.consentStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ConsentStageFromJSON)(jsonValue));
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesConsentCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesConsentDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesConsentDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.consentExpireIn !== undefined) {
                queryParameters['consent_expire_in'] = requestParameters.consentExpireIn;
            }
            if (requestParameters.mode !== undefined) {
                queryParameters['mode'] = requestParameters.mode;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedConsentStageListFromJSON)(jsonValue));
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesConsentListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesConsentPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedConsentStageRequestToJSON)(requestParameters.patchedConsentStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ConsentStageFromJSON)(jsonValue));
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesConsentPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesConsentRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ConsentStageFromJSON)(jsonValue));
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesConsentRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesConsentUpdate.');
            }
            if (requestParameters.consentStageRequest === null || requestParameters.consentStageRequest === undefined) {
                throw new runtime.RequiredError('consentStageRequest', 'Required parameter requestParameters.consentStageRequest was null or undefined when calling stagesConsentUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ConsentStageRequestToJSON)(requestParameters.consentStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ConsentStageFromJSON)(jsonValue));
        });
    }
    /**
     * ConsentStage Viewset
     */
    stagesConsentUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesConsentUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesConsentUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesConsentUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/consent/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesConsentUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesConsentUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.denyStageRequest === null || requestParameters.denyStageRequest === undefined) {
                throw new runtime.RequiredError('denyStageRequest', 'Required parameter requestParameters.denyStageRequest was null or undefined when calling stagesDenyCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DenyStageRequestToJSON)(requestParameters.denyStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DenyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDenyCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDenyDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesDenyDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.denyMessage !== undefined) {
                queryParameters['deny_message'] = requestParameters.denyMessage;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedDenyStageListFromJSON)(jsonValue));
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDenyListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDenyPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedDenyStageRequestToJSON)(requestParameters.patchedDenyStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DenyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDenyPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDenyRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DenyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDenyRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDenyUpdate.');
            }
            if (requestParameters.denyStageRequest === null || requestParameters.denyStageRequest === undefined) {
                throw new runtime.RequiredError('denyStageRequest', 'Required parameter requestParameters.denyStageRequest was null or undefined when calling stagesDenyUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DenyStageRequestToJSON)(requestParameters.denyStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DenyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DenyStage Viewset
     */
    stagesDenyUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDenyUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesDenyUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDenyUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/deny/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesDenyUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDenyUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.dummyStageRequest === null || requestParameters.dummyStageRequest === undefined) {
                throw new runtime.RequiredError('dummyStageRequest', 'Required parameter requestParameters.dummyStageRequest was null or undefined when calling stagesDummyCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DummyStageRequestToJSON)(requestParameters.dummyStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDummyCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDummyDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesDummyDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.throwError !== undefined) {
                queryParameters['throw_error'] = requestParameters.throwError;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedDummyStageListFromJSON)(jsonValue));
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDummyListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDummyPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedDummyStageRequestToJSON)(requestParameters.patchedDummyStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDummyPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDummyRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDummyRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDummyUpdate.');
            }
            if (requestParameters.dummyStageRequest === null || requestParameters.dummyStageRequest === undefined) {
                throw new runtime.RequiredError('dummyStageRequest', 'Required parameter requestParameters.dummyStageRequest was null or undefined when calling stagesDummyUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DummyStageRequestToJSON)(requestParameters.dummyStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyStageFromJSON)(jsonValue));
        });
    }
    /**
     * DummyStage Viewset
     */
    stagesDummyUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDummyUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesDummyUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesDummyUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/dummy/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesDummyUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesDummyUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.emailStageRequest === null || requestParameters.emailStageRequest === undefined) {
                throw new runtime.RequiredError('emailStageRequest', 'Required parameter requestParameters.emailStageRequest was null or undefined when calling stagesEmailCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.EmailStageRequestToJSON)(requestParameters.emailStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EmailStageFromJSON)(jsonValue));
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesEmailDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesEmailDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.activateUserOnSuccess !== undefined) {
                queryParameters['activate_user_on_success'] = requestParameters.activateUserOnSuccess;
            }
            if (requestParameters.fromAddress !== undefined) {
                queryParameters['from_address'] = requestParameters.fromAddress;
            }
            if (requestParameters.host !== undefined) {
                queryParameters['host'] = requestParameters.host;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.port !== undefined) {
                queryParameters['port'] = requestParameters.port;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.subject !== undefined) {
                queryParameters['subject'] = requestParameters.subject;
            }
            if (requestParameters.template !== undefined) {
                queryParameters['template'] = requestParameters.template;
            }
            if (requestParameters.timeout !== undefined) {
                queryParameters['timeout'] = requestParameters.timeout;
            }
            if (requestParameters.tokenExpiry !== undefined) {
                queryParameters['token_expiry'] = requestParameters.tokenExpiry;
            }
            if (requestParameters.useGlobalSettings !== undefined) {
                queryParameters['use_global_settings'] = requestParameters.useGlobalSettings;
            }
            if (requestParameters.useSsl !== undefined) {
                queryParameters['use_ssl'] = requestParameters.useSsl;
            }
            if (requestParameters.useTls !== undefined) {
                queryParameters['use_tls'] = requestParameters.useTls;
            }
            if (requestParameters.username !== undefined) {
                queryParameters['username'] = requestParameters.username;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedEmailStageListFromJSON)(jsonValue));
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesEmailPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedEmailStageRequestToJSON)(requestParameters.patchedEmailStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EmailStageFromJSON)(jsonValue));
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesEmailRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EmailStageFromJSON)(jsonValue));
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all available templates, including custom templates
     */
    stagesEmailTemplatesListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/templates/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.TypeCreateFromJSON));
        });
    }
    /**
     * Get all available templates, including custom templates
     */
    stagesEmailTemplatesList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailTemplatesListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesEmailUpdate.');
            }
            if (requestParameters.emailStageRequest === null || requestParameters.emailStageRequest === undefined) {
                throw new runtime.RequiredError('emailStageRequest', 'Required parameter requestParameters.emailStageRequest was null or undefined when calling stagesEmailUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.EmailStageRequestToJSON)(requestParameters.emailStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EmailStageFromJSON)(jsonValue));
        });
    }
    /**
     * EmailStage Viewset
     */
    stagesEmailUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesEmailUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesEmailUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/email/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesEmailUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesEmailUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.identificationStageRequest === null || requestParameters.identificationStageRequest === undefined) {
                throw new runtime.RequiredError('identificationStageRequest', 'Required parameter requestParameters.identificationStageRequest was null or undefined when calling stagesIdentificationCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.IdentificationStageRequestToJSON)(requestParameters.identificationStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.IdentificationStageFromJSON)(jsonValue));
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesIdentificationCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesIdentificationDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesIdentificationDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.caseInsensitiveMatching !== undefined) {
                queryParameters['case_insensitive_matching'] = requestParameters.caseInsensitiveMatching;
            }
            if (requestParameters.enrollmentFlow !== undefined) {
                queryParameters['enrollment_flow'] = requestParameters.enrollmentFlow;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.passwordStage !== undefined) {
                queryParameters['password_stage'] = requestParameters.passwordStage;
            }
            if (requestParameters.passwordlessFlow !== undefined) {
                queryParameters['passwordless_flow'] = requestParameters.passwordlessFlow;
            }
            if (requestParameters.recoveryFlow !== undefined) {
                queryParameters['recovery_flow'] = requestParameters.recoveryFlow;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.showMatchedUser !== undefined) {
                queryParameters['show_matched_user'] = requestParameters.showMatchedUser;
            }
            if (requestParameters.showSourceLabels !== undefined) {
                queryParameters['show_source_labels'] = requestParameters.showSourceLabels;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedIdentificationStageListFromJSON)(jsonValue));
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesIdentificationListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesIdentificationPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedIdentificationStageRequestToJSON)(requestParameters.patchedIdentificationStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.IdentificationStageFromJSON)(jsonValue));
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesIdentificationPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesIdentificationRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.IdentificationStageFromJSON)(jsonValue));
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesIdentificationRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesIdentificationUpdate.');
            }
            if (requestParameters.identificationStageRequest === null || requestParameters.identificationStageRequest === undefined) {
                throw new runtime.RequiredError('identificationStageRequest', 'Required parameter requestParameters.identificationStageRequest was null or undefined when calling stagesIdentificationUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.IdentificationStageRequestToJSON)(requestParameters.identificationStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.IdentificationStageFromJSON)(jsonValue));
        });
    }
    /**
     * IdentificationStage Viewset
     */
    stagesIdentificationUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesIdentificationUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesIdentificationUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesIdentificationUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/identification/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesIdentificationUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesIdentificationUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.invitationRequest === null || requestParameters.invitationRequest === undefined) {
                throw new runtime.RequiredError('invitationRequest', 'Required parameter requestParameters.invitationRequest was null or undefined when calling stagesInvitationInvitationsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.InvitationRequestToJSON)(requestParameters.invitationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationFromJSON)(jsonValue));
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationInvitationsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.inviteUuid === null || requestParameters.inviteUuid === undefined) {
                throw new runtime.RequiredError('inviteUuid', 'Required parameter requestParameters.inviteUuid was null or undefined when calling stagesInvitationInvitationsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/{invite_uuid}/`.replace(`{${"invite_uuid"}}`, encodeURIComponent(String(requestParameters.inviteUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesInvitationInvitationsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.createdByUsername !== undefined) {
                queryParameters['created_by__username'] = requestParameters.createdByUsername;
            }
            if (requestParameters.expires !== undefined) {
                queryParameters['expires'] = requestParameters.expires.toISOString();
            }
            if (requestParameters.flowSlug !== undefined) {
                queryParameters['flow__slug'] = requestParameters.flowSlug;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedInvitationListFromJSON)(jsonValue));
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationInvitationsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.inviteUuid === null || requestParameters.inviteUuid === undefined) {
                throw new runtime.RequiredError('inviteUuid', 'Required parameter requestParameters.inviteUuid was null or undefined when calling stagesInvitationInvitationsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/{invite_uuid}/`.replace(`{${"invite_uuid"}}`, encodeURIComponent(String(requestParameters.inviteUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedInvitationRequestToJSON)(requestParameters.patchedInvitationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationFromJSON)(jsonValue));
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationInvitationsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.inviteUuid === null || requestParameters.inviteUuid === undefined) {
                throw new runtime.RequiredError('inviteUuid', 'Required parameter requestParameters.inviteUuid was null or undefined when calling stagesInvitationInvitationsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/{invite_uuid}/`.replace(`{${"invite_uuid"}}`, encodeURIComponent(String(requestParameters.inviteUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationFromJSON)(jsonValue));
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationInvitationsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.inviteUuid === null || requestParameters.inviteUuid === undefined) {
                throw new runtime.RequiredError('inviteUuid', 'Required parameter requestParameters.inviteUuid was null or undefined when calling stagesInvitationInvitationsUpdate.');
            }
            if (requestParameters.invitationRequest === null || requestParameters.invitationRequest === undefined) {
                throw new runtime.RequiredError('invitationRequest', 'Required parameter requestParameters.invitationRequest was null or undefined when calling stagesInvitationInvitationsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/{invite_uuid}/`.replace(`{${"invite_uuid"}}`, encodeURIComponent(String(requestParameters.inviteUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.InvitationRequestToJSON)(requestParameters.invitationRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationFromJSON)(jsonValue));
        });
    }
    /**
     * Invitation Viewset
     */
    stagesInvitationInvitationsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationInvitationsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesInvitationInvitationsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.inviteUuid === null || requestParameters.inviteUuid === undefined) {
                throw new runtime.RequiredError('inviteUuid', 'Required parameter requestParameters.inviteUuid was null or undefined when calling stagesInvitationInvitationsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/invitations/{invite_uuid}/used_by/`.replace(`{${"invite_uuid"}}`, encodeURIComponent(String(requestParameters.inviteUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesInvitationInvitationsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationInvitationsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.invitationStageRequest === null || requestParameters.invitationStageRequest === undefined) {
                throw new runtime.RequiredError('invitationStageRequest', 'Required parameter requestParameters.invitationStageRequest was null or undefined when calling stagesInvitationStagesCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.InvitationStageRequestToJSON)(requestParameters.invitationStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationStageFromJSON)(jsonValue));
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationStagesCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesInvitationStagesDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesInvitationStagesDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.continueFlowWithoutInvitation !== undefined) {
                queryParameters['continue_flow_without_invitation'] = requestParameters.continueFlowWithoutInvitation;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.noFlows !== undefined) {
                queryParameters['no_flows'] = requestParameters.noFlows;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedInvitationStageListFromJSON)(jsonValue));
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationStagesListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesInvitationStagesPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedInvitationStageRequestToJSON)(requestParameters.patchedInvitationStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationStageFromJSON)(jsonValue));
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationStagesPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesInvitationStagesRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationStageFromJSON)(jsonValue));
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationStagesRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesInvitationStagesUpdate.');
            }
            if (requestParameters.invitationStageRequest === null || requestParameters.invitationStageRequest === undefined) {
                throw new runtime.RequiredError('invitationStageRequest', 'Required parameter requestParameters.invitationStageRequest was null or undefined when calling stagesInvitationStagesUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.InvitationStageRequestToJSON)(requestParameters.invitationStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.InvitationStageFromJSON)(jsonValue));
        });
    }
    /**
     * InvitationStage Viewset
     */
    stagesInvitationStagesUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationStagesUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesInvitationStagesUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesInvitationStagesUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/invitation/stages/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesInvitationStagesUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesInvitationStagesUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.passwordStageRequest === null || requestParameters.passwordStageRequest === undefined) {
                throw new runtime.RequiredError('passwordStageRequest', 'Required parameter requestParameters.passwordStageRequest was null or undefined when calling stagesPasswordCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PasswordStageRequestToJSON)(requestParameters.passwordStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordStageFromJSON)(jsonValue));
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPasswordCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPasswordDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesPasswordDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.configureFlow !== undefined) {
                queryParameters['configure_flow'] = requestParameters.configureFlow;
            }
            if (requestParameters.failedAttemptsBeforeCancel !== undefined) {
                queryParameters['failed_attempts_before_cancel'] = requestParameters.failedAttemptsBeforeCancel;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPasswordStageListFromJSON)(jsonValue));
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPasswordListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPasswordPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPasswordStageRequestToJSON)(requestParameters.patchedPasswordStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordStageFromJSON)(jsonValue));
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPasswordPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPasswordRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordStageFromJSON)(jsonValue));
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPasswordRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPasswordUpdate.');
            }
            if (requestParameters.passwordStageRequest === null || requestParameters.passwordStageRequest === undefined) {
                throw new runtime.RequiredError('passwordStageRequest', 'Required parameter requestParameters.passwordStageRequest was null or undefined when calling stagesPasswordUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PasswordStageRequestToJSON)(requestParameters.passwordStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordStageFromJSON)(jsonValue));
        });
    }
    /**
     * PasswordStage Viewset
     */
    stagesPasswordUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPasswordUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesPasswordUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPasswordUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/password/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesPasswordUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPasswordUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptRequest === null || requestParameters.promptRequest === undefined) {
                throw new runtime.RequiredError('promptRequest', 'Required parameter requestParameters.promptRequest was null or undefined when calling stagesPromptPromptsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PromptRequestToJSON)(requestParameters.promptRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptFromJSON)(jsonValue));
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptUuid === null || requestParameters.promptUuid === undefined) {
                throw new runtime.RequiredError('promptUuid', 'Required parameter requestParameters.promptUuid was null or undefined when calling stagesPromptPromptsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/{prompt_uuid}/`.replace(`{${"prompt_uuid"}}`, encodeURIComponent(String(requestParameters.promptUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesPromptPromptsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.fieldKey !== undefined) {
                queryParameters['field_key'] = requestParameters.fieldKey;
            }
            if (requestParameters.label !== undefined) {
                queryParameters['label'] = requestParameters.label;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.placeholder !== undefined) {
                queryParameters['placeholder'] = requestParameters.placeholder;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.type !== undefined) {
                queryParameters['type'] = requestParameters.type;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPromptListFromJSON)(jsonValue));
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptUuid === null || requestParameters.promptUuid === undefined) {
                throw new runtime.RequiredError('promptUuid', 'Required parameter requestParameters.promptUuid was null or undefined when calling stagesPromptPromptsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/{prompt_uuid}/`.replace(`{${"prompt_uuid"}}`, encodeURIComponent(String(requestParameters.promptUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPromptRequestToJSON)(requestParameters.patchedPromptRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptFromJSON)(jsonValue));
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Preview a prompt as a challenge, just like a flow would receive
     */
    stagesPromptPromptsPreviewCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptRequest === null || requestParameters.promptRequest === undefined) {
                throw new runtime.RequiredError('promptRequest', 'Required parameter requestParameters.promptRequest was null or undefined when calling stagesPromptPromptsPreviewCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/preview/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PromptRequestToJSON)(requestParameters.promptRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptChallengeFromJSON)(jsonValue));
        });
    }
    /**
     * Preview a prompt as a challenge, just like a flow would receive
     */
    stagesPromptPromptsPreviewCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsPreviewCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptUuid === null || requestParameters.promptUuid === undefined) {
                throw new runtime.RequiredError('promptUuid', 'Required parameter requestParameters.promptUuid was null or undefined when calling stagesPromptPromptsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/{prompt_uuid}/`.replace(`{${"prompt_uuid"}}`, encodeURIComponent(String(requestParameters.promptUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptFromJSON)(jsonValue));
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptUuid === null || requestParameters.promptUuid === undefined) {
                throw new runtime.RequiredError('promptUuid', 'Required parameter requestParameters.promptUuid was null or undefined when calling stagesPromptPromptsUpdate.');
            }
            if (requestParameters.promptRequest === null || requestParameters.promptRequest === undefined) {
                throw new runtime.RequiredError('promptRequest', 'Required parameter requestParameters.promptRequest was null or undefined when calling stagesPromptPromptsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/{prompt_uuid}/`.replace(`{${"prompt_uuid"}}`, encodeURIComponent(String(requestParameters.promptUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PromptRequestToJSON)(requestParameters.promptRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptFromJSON)(jsonValue));
        });
    }
    /**
     * Prompt Viewset
     */
    stagesPromptPromptsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesPromptPromptsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptUuid === null || requestParameters.promptUuid === undefined) {
                throw new runtime.RequiredError('promptUuid', 'Required parameter requestParameters.promptUuid was null or undefined when calling stagesPromptPromptsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/prompts/{prompt_uuid}/used_by/`.replace(`{${"prompt_uuid"}}`, encodeURIComponent(String(requestParameters.promptUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesPromptPromptsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptPromptsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.promptStageRequest === null || requestParameters.promptStageRequest === undefined) {
                throw new runtime.RequiredError('promptStageRequest', 'Required parameter requestParameters.promptStageRequest was null or undefined when calling stagesPromptStagesCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PromptStageRequestToJSON)(requestParameters.promptStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptStageFromJSON)(jsonValue));
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptStagesCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPromptStagesDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesPromptStagesDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.fields) {
                queryParameters['fields'] = requestParameters.fields;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.validationPolicies) {
                queryParameters['validation_policies'] = requestParameters.validationPolicies;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPromptStageListFromJSON)(jsonValue));
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptStagesListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPromptStagesPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPromptStageRequestToJSON)(requestParameters.patchedPromptStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptStageFromJSON)(jsonValue));
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptStagesPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPromptStagesRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptStageFromJSON)(jsonValue));
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptStagesRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPromptStagesUpdate.');
            }
            if (requestParameters.promptStageRequest === null || requestParameters.promptStageRequest === undefined) {
                throw new runtime.RequiredError('promptStageRequest', 'Required parameter requestParameters.promptStageRequest was null or undefined when calling stagesPromptStagesUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PromptStageRequestToJSON)(requestParameters.promptStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PromptStageFromJSON)(jsonValue));
        });
    }
    /**
     * PromptStage Viewset
     */
    stagesPromptStagesUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptStagesUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesPromptStagesUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesPromptStagesUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/prompt/stages/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesPromptStagesUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesPromptStagesUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.sourceStageRequest === null || requestParameters.sourceStageRequest === undefined) {
                throw new runtime.RequiredError('sourceStageRequest', 'Required parameter requestParameters.sourceStageRequest was null or undefined when calling stagesSourceCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SourceStageRequestToJSON)(requestParameters.sourceStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SourceStageFromJSON)(jsonValue));
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesSourceCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesSourceDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesSourceDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.resumeTimeout !== undefined) {
                queryParameters['resume_timeout'] = requestParameters.resumeTimeout;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.source !== undefined) {
                queryParameters['source'] = requestParameters.source;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedSourceStageListFromJSON)(jsonValue));
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesSourceListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourcePartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesSourcePartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedSourceStageRequestToJSON)(requestParameters.patchedSourceStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SourceStageFromJSON)(jsonValue));
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourcePartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesSourcePartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesSourceRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SourceStageFromJSON)(jsonValue));
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesSourceRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesSourceUpdate.');
            }
            if (requestParameters.sourceStageRequest === null || requestParameters.sourceStageRequest === undefined) {
                throw new runtime.RequiredError('sourceStageRequest', 'Required parameter requestParameters.sourceStageRequest was null or undefined when calling stagesSourceUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.SourceStageRequestToJSON)(requestParameters.sourceStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.SourceStageFromJSON)(jsonValue));
        });
    }
    /**
     * SourceStage Viewset
     */
    stagesSourceUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesSourceUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesSourceUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesSourceUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/source/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesSourceUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesSourceUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userDeleteStageRequest === null || requestParameters.userDeleteStageRequest === undefined) {
                throw new runtime.RequiredError('userDeleteStageRequest', 'Required parameter requestParameters.userDeleteStageRequest was null or undefined when calling stagesUserDeleteCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserDeleteStageRequestToJSON)(requestParameters.userDeleteStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserDeleteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserDeleteCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserDeleteDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesUserDeleteDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserDeleteStageListFromJSON)(jsonValue));
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserDeleteListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeletePartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserDeletePartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserDeleteStageRequestToJSON)(requestParameters.patchedUserDeleteStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserDeleteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeletePartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserDeletePartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserDeleteRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserDeleteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserDeleteRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserDeleteUpdate.');
            }
            if (requestParameters.userDeleteStageRequest === null || requestParameters.userDeleteStageRequest === undefined) {
                throw new runtime.RequiredError('userDeleteStageRequest', 'Required parameter requestParameters.userDeleteStageRequest was null or undefined when calling stagesUserDeleteUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserDeleteStageRequestToJSON)(requestParameters.userDeleteStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserDeleteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserDeleteStage Viewset
     */
    stagesUserDeleteUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserDeleteUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserDeleteUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserDeleteUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_delete/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserDeleteUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserDeleteUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userLoginStageRequest === null || requestParameters.userLoginStageRequest === undefined) {
                throw new runtime.RequiredError('userLoginStageRequest', 'Required parameter requestParameters.userLoginStageRequest was null or undefined when calling stagesUserLoginCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserLoginStageRequestToJSON)(requestParameters.userLoginStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLoginStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLoginCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLoginDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesUserLoginDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.geoipBinding !== undefined) {
                queryParameters['geoip_binding'] = requestParameters.geoipBinding;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.networkBinding !== undefined) {
                queryParameters['network_binding'] = requestParameters.networkBinding;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.rememberMeOffset !== undefined) {
                queryParameters['remember_me_offset'] = requestParameters.rememberMeOffset;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.sessionDuration !== undefined) {
                queryParameters['session_duration'] = requestParameters.sessionDuration;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.terminateOtherSessions !== undefined) {
                queryParameters['terminate_other_sessions'] = requestParameters.terminateOtherSessions;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserLoginStageListFromJSON)(jsonValue));
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLoginListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLoginPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserLoginStageRequestToJSON)(requestParameters.patchedUserLoginStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLoginStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLoginPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLoginRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLoginStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLoginRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLoginUpdate.');
            }
            if (requestParameters.userLoginStageRequest === null || requestParameters.userLoginStageRequest === undefined) {
                throw new runtime.RequiredError('userLoginStageRequest', 'Required parameter requestParameters.userLoginStageRequest was null or undefined when calling stagesUserLoginUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserLoginStageRequestToJSON)(requestParameters.userLoginStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLoginStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLoginStage Viewset
     */
    stagesUserLoginUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLoginUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserLoginUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLoginUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_login/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserLoginUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLoginUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userLogoutStageRequest === null || requestParameters.userLogoutStageRequest === undefined) {
                throw new runtime.RequiredError('userLogoutStageRequest', 'Required parameter requestParameters.userLogoutStageRequest was null or undefined when calling stagesUserLogoutCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserLogoutStageRequestToJSON)(requestParameters.userLogoutStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLogoutStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLogoutCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLogoutDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesUserLogoutDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserLogoutStageListFromJSON)(jsonValue));
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLogoutListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLogoutPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserLogoutStageRequestToJSON)(requestParameters.patchedUserLogoutStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLogoutStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLogoutPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLogoutRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLogoutStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLogoutRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLogoutUpdate.');
            }
            if (requestParameters.userLogoutStageRequest === null || requestParameters.userLogoutStageRequest === undefined) {
                throw new runtime.RequiredError('userLogoutStageRequest', 'Required parameter requestParameters.userLogoutStageRequest was null or undefined when calling stagesUserLogoutUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserLogoutStageRequestToJSON)(requestParameters.userLogoutStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserLogoutStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserLogoutStage Viewset
     */
    stagesUserLogoutUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLogoutUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserLogoutUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserLogoutUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_logout/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserLogoutUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserLogoutUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.userWriteStageRequest === null || requestParameters.userWriteStageRequest === undefined) {
                throw new runtime.RequiredError('userWriteStageRequest', 'Required parameter requestParameters.userWriteStageRequest was null or undefined when calling stagesUserWriteCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserWriteStageRequestToJSON)(requestParameters.userWriteStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserWriteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserWriteCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserWriteDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.stagesUserWriteDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.createUsersAsInactive !== undefined) {
                queryParameters['create_users_as_inactive'] = requestParameters.createUsersAsInactive;
            }
            if (requestParameters.createUsersGroup !== undefined) {
                queryParameters['create_users_group'] = requestParameters.createUsersGroup;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.stageUuid !== undefined) {
                queryParameters['stage_uuid'] = requestParameters.stageUuid;
            }
            if (requestParameters.userCreationMode !== undefined) {
                queryParameters['user_creation_mode'] = requestParameters.userCreationMode;
            }
            if (requestParameters.userPathTemplate !== undefined) {
                queryParameters['user_path_template'] = requestParameters.userPathTemplate;
            }
            if (requestParameters.userType !== undefined) {
                queryParameters['user_type'] = requestParameters.userType;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedUserWriteStageListFromJSON)(jsonValue));
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserWriteListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWritePartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserWritePartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedUserWriteStageRequestToJSON)(requestParameters.patchedUserWriteStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserWriteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWritePartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserWritePartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserWriteRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserWriteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserWriteRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserWriteUpdate.');
            }
            if (requestParameters.userWriteStageRequest === null || requestParameters.userWriteStageRequest === undefined) {
                throw new runtime.RequiredError('userWriteStageRequest', 'Required parameter requestParameters.userWriteStageRequest was null or undefined when calling stagesUserWriteUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/{stage_uuid}/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.UserWriteStageRequestToJSON)(requestParameters.userWriteStageRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.UserWriteStageFromJSON)(jsonValue));
        });
    }
    /**
     * UserWriteStage Viewset
     */
    stagesUserWriteUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserWriteUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserWriteUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.stageUuid === null || requestParameters.stageUuid === undefined) {
                throw new runtime.RequiredError('stageUuid', 'Required parameter requestParameters.stageUuid was null or undefined when calling stagesUserWriteUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/stages/user_write/{stage_uuid}/used_by/`.replace(`{${"stage_uuid"}}`, encodeURIComponent(String(requestParameters.stageUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    stagesUserWriteUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.stagesUserWriteUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
}
exports.StagesApi = StagesApi;
/**
 * @export
 */
exports.StagesAuthenticatorSmsListAuthTypeEnum = {
    Basic: 'basic',
    Bearer: 'bearer',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesAuthenticatorSmsListProviderEnum = {
    Generic: 'generic',
    Twilio: 'twilio',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesAuthenticatorTotpListDigitsEnum = {
    _6: '6',
    _8: '8',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesAuthenticatorValidateListNotConfiguredActionEnum = {
    Configure: 'configure',
    Deny: 'deny',
    Skip: 'skip',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesAuthenticatorWebauthnListAuthenticatorAttachmentEnum = {
    CrossPlatform: 'cross-platform',
    Platform: 'platform',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesAuthenticatorWebauthnListResidentKeyRequirementEnum = {
    Discouraged: 'discouraged',
    Preferred: 'preferred',
    Required: 'required',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesAuthenticatorWebauthnListUserVerificationEnum = {
    Discouraged: 'discouraged',
    Preferred: 'preferred',
    Required: 'required',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesConsentListModeEnum = {
    AlwaysRequire: 'always_require',
    Expiring: 'expiring',
    Permanent: 'permanent',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesPromptPromptsListTypeEnum = {
    AkLocale: 'ak-locale',
    Checkbox: 'checkbox',
    Date: 'date',
    DateTime: 'date-time',
    Dropdown: 'dropdown',
    Email: 'email',
    File: 'file',
    Hidden: 'hidden',
    Number: 'number',
    Password: 'password',
    RadioButtonGroup: 'radio-button-group',
    Separator: 'separator',
    Static: 'static',
    Text: 'text',
    TextArea: 'text_area',
    TextAreaReadOnly: 'text_area_read_only',
    TextReadOnly: 'text_read_only',
    Username: 'username',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesUserLoginListGeoipBindingEnum = {
    BindContinent: 'bind_continent',
    BindContinentCountry: 'bind_continent_country',
    BindContinentCountryCity: 'bind_continent_country_city',
    NoBinding: 'no_binding',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesUserLoginListNetworkBindingEnum = {
    BindAsn: 'bind_asn',
    BindAsnNetwork: 'bind_asn_network',
    BindAsnNetworkIp: 'bind_asn_network_ip',
    NoBinding: 'no_binding',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesUserWriteListUserCreationModeEnum = {
    AlwaysCreate: 'always_create',
    CreateWhenRequired: 'create_when_required',
    NeverCreate: 'never_create',
    UnknownDefaultOpenApi: '11184809'
};
/**
 * @export
 */
exports.StagesUserWriteListUserTypeEnum = {
    External: 'external',
    Internal: 'internal',
    InternalServiceAccount: 'internal_service_account',
    ServiceAccount: 'service_account',
    UnknownDefaultOpenApi: '11184809'
};
