# Generated by Django 4.0 on 2021-12-23 17:12

import django.contrib.postgres.fields
import django.db.models.deletion
from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def assign_sources(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    db_alias = schema_editor.connection.alias

    IdentificationStage = apps.get_model("authentik_stages_identification", "identificationstage")
    Source = apps.get_model("authentik_core", "source")

    sources = Source.objects.using(db_alias).all()
    for stage in IdentificationStage.objects.using(db_alias).all():
        stage.sources.using(db_alias).set(sources)
        stage.save()


class Migration(migrations.Migration):
    replaces = [
        ("authentik_stages_identification", "0002_auto_20200530_2204"),
        ("authentik_stages_identification", "0003_auto_20200615_1641"),
        ("authentik_stages_identification", "0004_identificationstage_case_insensitive_matching"),
        ("authentik_stages_identification", "0005_auto_20201003_1734"),
        ("authentik_stages_identification", "0006_identificationstage_show_matched_user"),
        ("authentik_stages_identification", "0007_remove_identificationstage_template"),
        ("authentik_stages_identification", "0008_alter_identificationstage_user_fields"),
        ("authentik_stages_identification", "0009_identificationstage_sources"),
        ("authentik_stages_identification", "0010_identificationstage_password_stage"),
        ("authentik_stages_identification", "0011_alter_identificationstage_user_fields"),
        ("authentik_stages_identification", "0012_identificationstage_show_source_labels"),
        ("authentik_stages_identification", "0013_identificationstage_passwordless_flow"),
    ]

    dependencies = [
        ("authentik_stages_identification", "0001_initial"),
        ("authentik_core", "0021_alter_application_slug"),
        ("authentik_flows", "0003_auto_20200523_1133"),
        ("authentik_stages_password", "0005_auto_20210402_2221"),
        ("authentik_flows", "0007_auto_20200703_2059"),
        ("authentik_flows", "0020_flowtoken"),
    ]

    operations = [
        migrations.AddField(
            model_name="identificationstage",
            name="enrollment_flow",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Optional enrollment flow, which is linked at the bottom of the page.",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="authentik_flows.flow",
            ),
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="recovery_flow",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Optional recovery flow, which is linked at the bottom of the page.",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="authentik_flows.flow",
            ),
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="case_insensitive_matching",
            field=models.BooleanField(
                default=True,
                help_text="When enabled, user fields are matched regardless of their casing.",
            ),
        ),
        migrations.AlterField(
            model_name="identificationstage",
            name="user_fields",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[("email", "E Mail"), ("username", "Username")], max_length=100
                ),
                help_text=(
                    "Fields of the user object to match against. (Hold shift to select multiple"
                    " options)"
                ),
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="show_matched_user",
            field=models.BooleanField(
                default=True,
                help_text=(
                    "When a valid username/email has been entered, and this option is enabled, the"
                    " user's username and avatar will be shown. Otherwise, the text that the user"
                    " entered will be shown"
                ),
            ),
        ),
        migrations.RemoveField(
            model_name="identificationstage",
            name="template",
        ),
        migrations.AlterField(
            model_name="identificationstage",
            name="user_fields",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[("email", "E Mail"), ("username", "Username")], max_length=100
                ),
                blank=True,
                help_text=(
                    "Fields of the user object to match against. (Hold shift to select multiple"
                    " options)"
                ),
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="sources",
            field=models.ManyToManyField(
                default=list,
                help_text="Specify which sources should be shown.",
                to="authentik_core.Source",
                blank=True,
            ),
        ),
        migrations.RunPython(
            code=assign_sources,
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="password_stage",
            field=models.ForeignKey(
                default=None,
                help_text=(
                    "When set, shows a password field, instead of showing the password field as"
                    " separate step."
                ),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="authentik_stages_password.passwordstage",
            ),
        ),
        migrations.AlterField(
            model_name="identificationstage",
            name="user_fields",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[("email", "E Mail"), ("username", "Username"), ("upn", "Upn")],
                    max_length=100,
                ),
                blank=True,
                help_text=(
                    "Fields of the user object to match against. (Hold shift to select multiple"
                    " options)"
                ),
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="show_source_labels",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="identificationstage",
            name="passwordless_flow",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Optional passwordless flow, which is linked at the bottom of the page.",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="authentik_flows.flow",
            ),
        ),
    ]
