# Generated by Django 3.0.8 on 2020-07-20 09:41

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import authentik.core.models
import authentik.lib.utils.time


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_core", "0006_auto_20200709_1608"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authentik_stages_consent", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="consentstage",
            name="consent_expire_in",
            field=models.TextField(
                default="weeks=4",
                help_text=(
                    "Offset after which consent expires. (Format: hours=1;minutes=2;seconds=3)."
                ),
                validators=[authentik.lib.utils.time.timedelta_string_validator],
                verbose_name="Consent expires in",
            ),
        ),
        migrations.AddField(
            model_name="consentstage",
            name="mode",
            field=models.TextField(
                choices=[
                    ("always_require", "Always Require"),
                    ("permanent", "Permanent"),
                    ("expiring", "Expiring"),
                ],
                default="always_require",
            ),
        ),
        migrations.CreateModel(
            name="UserConsent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(default=authentik.core.models.default_token_duration),
                ),
                ("expiring", models.BooleanField(default=True)),
                (
                    "application",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_core.Application",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="ak_consent",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Consent",
                "verbose_name_plural": "User Consents",
                "unique_together": {("user", "application")},
            },
        ),
    ]
