# Generated by Django 5.0.4 on 2024-04-07 14:34

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("authentik_core", "0033_alter_user_options"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SCIMSource",
            fields=[
                (
                    "source_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.source",
                    ),
                ),
                (
                    "token",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_core.token",
                    ),
                ),
            ],
            options={
                "verbose_name": "SCIM Source",
                "verbose_name_plural": "SCIM Sources",
            },
            bases=("authentik_core.source",),
        ),
        migrations.CreateModel(
            name="SCIMSourceGroup",
            fields=[
                ("id", models.TextField(primary_key=True, serialize=False)),
                ("attributes", models.JSONField(default=dict)),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="authentik_core.group"
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_sources_scim.scimsource",
                    ),
                ),
            ],
            options={
                "unique_together": {("id", "group", "source")},
            },
        ),
        migrations.CreateModel(
            name="SCIMSourceUser",
            fields=[
                ("id", models.TextField(primary_key=True, serialize=False)),
                ("attributes", models.JSONField(default=dict)),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_sources_scim.scimsource",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "unique_together": {("id", "user", "source")},
            },
        ),
    ]
